/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.model;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.core.model.Parent;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.photran.internal.core.analysis.loops.GenericASTVisitorWithLoops;
import org.eclipse.photran.internal.core.lexer.Terminal;
import org.eclipse.photran.internal.core.lexer.Token;
import org.eclipse.photran.internal.core.model.FortranElement;
import org.eclipse.photran.internal.core.model.FortranModelBuilder;
import org.eclipse.photran.internal.core.parser.IASTListNode;
import org.eclipse.photran.internal.core.parser.IASTNode;
import org.eclipse.photran.internal.core.parser.IASTVisitor;

public final class FortranParseTreeModelBuildingVisitor
extends GenericASTVisitorWithLoops {
    private TranslationUnit translationUnit;
    private FortranModelBuilder modelBuilder;
    private LinkedList<IASTNode> parentParseTreeNodeStack = new LinkedList();
    private LinkedList<FortranElement> parentElementStack = new LinkedList();
    private String methodNameDescPrefix = "";

    public FortranParseTreeModelBuildingVisitor(TranslationUnit translationUnit, FortranModelBuilder modelBuilder) {
        this.translationUnit = translationUnit;
        this.modelBuilder = modelBuilder;
    }

    private Parent getCurrentParent() {
        if (this.parentElementStack.isEmpty()) {
            return this.translationUnit;
        }
        return (Parent)this.parentElementStack.getLast();
    }

    private boolean isCurrentParent(IASTNode node) {
        if (this.parentParseTreeNodeStack.isEmpty()) {
            return false;
        }
        return node == this.parentParseTreeNodeStack.getLast();
    }

    private void beginAddingChildrenFor(IASTNode parseTreeNode, FortranElement element) {
        this.parentParseTreeNodeStack.addLast(parseTreeNode);
        this.parentElementStack.addLast(element);
    }

    private void doneAddingChildrenFor(IASTNode node) {
        if (this.isCurrentParent(node)) {
            this.parentParseTreeNodeStack.removeLast();
            this.parentElementStack.removeLast();
        }
    }

    public void visitASTNode(IASTNode node) {
        FortranElement element = this.addElementForNode(node);
        this.beginAddingChildrenFor(node, element);
        this.addMethodDescriptions(node);
        this.doneAddingChildrenFor(node);
    }

    private FortranElement addElementForNode(IASTNode node) {
        String description = String.valueOf(this.methodNameDescPrefix) + node.getClass().getSimpleName();
        FortranElement.UnknownNode element = new FortranElement.UnknownNode(this.getCurrentParent(), description);
        try {
            this.modelBuilder.addF90Element((FortranElement)element);
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
        return element;
    }

    private void addMethodDescriptions(IASTNode node) {
        if (node instanceof IASTListNode) {
            this.addListEltDescriptions((IASTListNode<? extends IASTNode>)((IASTListNode)node));
        } else {
            Method[] methodArray = node.getClass().getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (this.shouldIncludeMethodDesc(node, m)) {
                    this.addMethodDesc(node, m);
                }
                ++n2;
            }
        }
    }

    private void addListEltDescriptions(IASTListNode<? extends IASTNode> list) {
        int i = 0;
        while (i < list.size()) {
            this.methodNameDescPrefix = "get(" + i + "): ";
            if (list.get(i) != null) {
                ((IASTNode)list.get(i)).accept((IASTVisitor)this);
            }
            ++i;
        }
    }

    private boolean shouldIncludeMethodDesc(IASTNode node, Method m) {
        return m.getDeclaringClass() == node.getClass() && m.getReturnType() != null && m.getParameterTypes().length == 0 && !m.getName().equals("getParent") && !m.getName().equals("getChildren") && !m.getName().equals("findFirstToken") && !m.getName().equals("findLastToken");
    }

    private void addMethodDesc(IASTNode node, Method m) {
        try {
            this.methodNameDescPrefix = String.valueOf(m.getName()) + "(): ";
            if (IASTNode.class.isAssignableFrom(m.getReturnType())) {
                this.describeASTGetterMethod(node, m);
            } else if (m.getReturnType() != null) {
                this.describeOtherMethod(node, m);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    private void describeASTGetterMethod(IASTNode node, Method m) throws IllegalAccessException, InvocationTargetException, CModelException {
        IASTNode n = (IASTNode)m.invoke((Object)node, null);
        if (n == null) {
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), String.valueOf(this.methodNameDescPrefix) + "null"));
        } else {
            n.accept((IASTVisitor)this);
        }
    }

    private void describeOtherMethod(IASTNode node, Method m) throws IllegalAccessException, InvocationTargetException, CModelException {
        Object n = m.invoke((Object)node, null);
        if (n == null) {
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), String.valueOf(this.methodNameDescPrefix) + "null"));
        } else {
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), String.valueOf(this.methodNameDescPrefix) + n));
        }
    }

    public void visitToken(Token token) {
        String description = String.valueOf(this.methodNameDescPrefix) + token.getClass().getSimpleName();
        FortranElement.UnknownNode element = new FortranElement.UnknownNode(this.getCurrentParent(), description);
        this.modelBuilder.configureElement((FortranElement)element, token);
        try {
            this.modelBuilder.addF90Element((FortranElement)element);
            this.beginAddingChildrenFor((IASTNode)token, (FortranElement)element);
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getTerminal(): Terminal." + this.findTerminal(token.getTerminal())));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getText(): \"" + token.getText().replaceAll("\\n", "\\\\n") + "\""));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getPreprocessorDirective(): " + token.getPreprocessorDirective()));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getPhysicalFile(): " + token.getPhysicalFile()));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getFileOffset(): " + token.getFileOffset()));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getLogicalFile(): " + token.getLogicalFile()));
            this.modelBuilder.addF90Element((FortranElement)new FortranElement.UnknownNode(this.getCurrentParent(), "getStreamOffset(): " + token.getStreamOffset()));
            this.doneAddingChildrenFor((IASTNode)token);
        }
        catch (CModelException cModelException) {
            // empty catch block
        }
    }

    private String findTerminal(Terminal terminal) {
        Field[] fieldArray = Terminal.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                if (f.get(null) == terminal) {
                    return f.getName();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            ++n2;
        }
        return "?";
    }
}

