/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.drafter.ui.model;

import org.eclipse.papyrus.uml.profile.drafter.ui.model.IModelVisitor;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.LifeStatusKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.MemberKind;
import org.eclipse.papyrus.uml.profile.drafter.ui.model.StateKind;
import org.eclipse.uml2.uml.Class;

public class MetaclassModel {
    protected MemberKind memberKind = MemberKind.owned;
    protected StateKind stateKind = StateKind.loaded;
    protected LifeStatusKind lifeStatusKind = LifeStatusKind.running;
    private Class extendedMetaClass;
    protected String proposedName;

    public MetaclassModel(MemberKind memberKind) {
        this.memberKind = memberKind;
    }

    public MetaclassModel(MemberKind memberKind, Class extendedMetaClass) {
        this.memberKind = memberKind;
        this.stateKind = StateKind.loaded;
        this.extendedMetaClass = extendedMetaClass;
    }

    public MetaclassModel(MemberKind memberKind, String proposedName) {
        this.memberKind = memberKind;
        this.proposedName = proposedName;
        this.stateKind = StateKind.created;
    }

    protected Class getExtendedMetaClass() {
        return this.extendedMetaClass;
    }

    public void accept(IModelVisitor visitor) {
        visitor.visit(this);
    }

    public LifeStatusKind getLifeStatusKind() {
        return this.lifeStatusKind;
    }

    public void setLifeStatusKind(LifeStatusKind lifeStatusKind) {
        this.lifeStatusKind = lifeStatusKind;
    }

    public MemberKind getMemberKind() {
        return this.memberKind;
    }

    public StateKind getStateKind() {
        return this.stateKind;
    }

    public void modelChangedEvent() {
        switch (this.stateKind) {
            case loaded: {
                this.stateKind = StateKind.modified;
                break;
            }
        }
    }

    public void deleteModelEvent() {
        switch (this.lifeStatusKind) {
            case running: {
                this.lifeStatusKind = LifeStatusKind.deleted;
                break;
            }
            case deleted: {
                this.lifeStatusKind = LifeStatusKind.running;
                break;
            }
        }
    }
}

