/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.IStereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.StereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCommentViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypeCompartmentCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateAppliedStereotypePropertyViewCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.command.CreateStereotypeLabelCommand;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypesAppliedCommand
extends AbstractTransactionalCommand {
    protected Diagram diagram;
    protected View currentView;
    protected IStereotypeViewProvider provider;
    protected StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    protected StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();

    public StereotypesAppliedCommand(TransactionalEditingDomain domain, Diagram diagram) {
        super(domain, "Stereotypes Applied", null);
        this.diagram = diagram;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) {
        TreeIterator allContentIterator = this.diagram.eAllContents();
        while (allContentIterator.hasNext()) {
            EObject eObject = (EObject)allContentIterator.next();
            if (!(eObject instanceof View)) continue;
            View view = (View)eObject;
            if (!StereotypeMigrationHelper.getInstance().hasStereotypeEAnnotation(view) || view.getElement() == null) continue;
            this.currentView = view;
            this.provider = new StereotypeViewProvider(view);
            List<Stereotype> allStereotypes = this.getAllStereotypes();
            if (allStereotypes.isEmpty()) continue;
            for (Stereotype stereotype : allStereotypes) {
                this.createAppliedLabelStereotype(view, stereotype);
            }
            String appliedStereotypesPropertiesLocalization = this.migrationHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)view);
            if ("Compartment".equals(appliedStereotypesPropertiesLocalization)) {
                for (Stereotype stereotype : allStereotypes) {
                    this.createAppliedCompartmentStereotype(stereotype);
                }
            } else if ("With brace".equals(appliedStereotypesPropertiesLocalization)) {
                for (Stereotype stereotype : allStereotypes) {
                    this.createAppliedBraceCompartmentStereotype(stereotype);
                }
            }
            this.createComment(allStereotypes);
        }
        return CommandResult.newOKCommandResult();
    }

    private void createComment(List<Stereotype> stereotypes) {
        Node comment = this.helper.getStereotypeComment(this.currentView);
        String appliedStereotypesLocalization = this.migrationHelper.getAppliedStereotypesPropertiesLocalization((EModelElement)this.currentView);
        TransactionalEditingDomain currentDomain = this.getEditingDomain();
        if (comment == null) {
            CreateAppliedStereotypeCommentViewCommand command = new CreateAppliedStereotypeCommentViewCommand(currentDomain, this.currentView, 200, 100, this.currentView.getElement(), false);
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
            comment = this.helper.getStereotypeComment(this.currentView);
        }
        if (comment != null) {
            for (Stereotype stereotype : stereotypes) {
                BasicCompartment braceStructure;
                BasicCompartment compartmentStructure = this.helper.getStereotypeCompartment((View)comment, stereotype);
                if (compartmentStructure == null && !this.helper.isCompartmentExist((View)comment, stereotype)) {
                    CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(currentDomain, (View)comment, stereotype, "StereotypeCompartment");
                    CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
                }
                if ((compartmentStructure = this.helper.getStereotypeCompartment((View)comment, stereotype)) != null && stereotype != null) {
                    EList properties = stereotype.allAttributes();
                    for (Property property : properties) {
                        if (property == null || property.getName().startsWith("base_") || this.helper.isPropertyExist((View)compartmentStructure, property)) continue;
                        CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(currentDomain, (View)compartmentStructure, property, "StereotypeProperty");
                        CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
                    }
                }
                if ((braceStructure = this.helper.getStereotypeCompartment((View)comment, stereotype)) != null) continue;
                if (!this.helper.isCompartmentExist((View)comment, stereotype)) {
                    CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(currentDomain, (View)comment, stereotype, "StereotypeBrace");
                    CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
                }
                if ((braceStructure = this.helper.getStereotypeBraceCompartment((View)comment, stereotype)) == null || stereotype == null) continue;
                EList properties = stereotype.allAttributes();
                for (Property property : properties) {
                    if (property == null || property.getName().startsWith("base_") || this.helper.isBracePropertyExist((Node)braceStructure, property)) continue;
                    CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(currentDomain, (View)braceStructure, property, "StereotypePropertyBrace");
                    CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
                }
            }
            if ("Comment".equals(appliedStereotypesLocalization)) {
                this.hideStereotypePropertiesNotDisplayed(StereotypeLocationEnum.IN_COMMENT);
            }
        }
    }

    private List<Stereotype> getAllStereotypes() {
        ArrayList<Stereotype> stereotypes = new ArrayList<Stereotype>();
        String stereotypesToDisplay = this.migrationHelper.getStereotypesToDisplay((EModelElement)this.currentView);
        if (!"".equals(stereotypesToDisplay)) {
            String[] split;
            String[] stringArray = split = stereotypesToDisplay.split(",");
            int n = split.length;
            int n2 = 0;
            while (n2 < n) {
                String stereotypeString = stringArray[n2];
                Stereotype stereotypeFromString = this.migrationHelper.getStereotypeFromString(this.currentView, stereotypeString);
                if (stereotypeFromString != null) {
                    stereotypes.add(stereotypeFromString);
                }
                ++n2;
            }
        }
        List<String> parsePropStereoDisplay = this.parsePropStereoDisplay();
        for (String stereotypeName : parsePropStereoDisplay) {
            Stereotype stereotypeFromString = this.migrationHelper.getStereotypeFromString(this.currentView, stereotypeName);
            if (stereotypeFromString == null || stereotypes.contains(stereotypeFromString)) continue;
            stereotypes.add(stereotypeFromString);
        }
        return stereotypes;
    }

    private List<String> parsePropStereoDisplay() {
        ArrayList<String> stringStereotypes = new ArrayList<String>();
        String appliedStereotypesPropertiesToDisplay = this.migrationHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)this.currentView);
        if (!"".equals(appliedStereotypesPropertiesToDisplay)) {
            String[] splitedProperties;
            String[] stringArray = splitedProperties = appliedStereotypesPropertiesToDisplay.split(",");
            int n = splitedProperties.length;
            int n2 = 0;
            while (n2 < n) {
                String substring;
                String property = stringArray[n2];
                int indexOf = property.indexOf(".");
                if (-1 != indexOf && !stringStereotypes.contains(substring = property.substring(0, indexOf))) {
                    stringStereotypes.add(substring);
                }
                ++n2;
            }
        }
        return stringStereotypes;
    }

    private void createAppliedLabelStereotype(View view, Stereotype stereotype) {
        TransactionalEditingDomain currentDomain = this.getEditingDomain();
        if (!this.helper.isLabelExist(view, stereotype)) {
            CreateStereotypeLabelCommand command = new CreateStereotypeLabelCommand(currentDomain, view, stereotype);
            CommandUtil.executeUnsafeCommand((Command)command, (Object)view);
        }
    }

    private void createAppliedCompartmentStereotype(Stereotype stereotype) {
        BasicCompartment compartment;
        TransactionalEditingDomain currentDomain = this.getEditingDomain();
        if (!this.helper.isCompartmentExist(this.currentView, stereotype)) {
            CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(currentDomain, this.currentView, stereotype, "StereotypeCompartment");
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
        }
        if ((compartment = this.helper.getStereotypeCompartment(this.currentView, stereotype)) != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                if (property == null || property.getName().startsWith("base_") || this.helper.isPropertyExist((View)compartment, property)) continue;
                CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(currentDomain, (View)compartment, property, "StereotypeProperty");
                CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
            }
            this.hideStereotypePropertiesNotDisplayed(StereotypeLocationEnum.IN_COMPARTMENT);
        }
    }

    private void createAppliedBraceCompartmentStereotype(Stereotype stereotype) {
        BasicCompartment braceCompartment;
        TransactionalEditingDomain currentDomain = this.getEditingDomain();
        if (!this.helper.isBraceCompartmentExist(this.currentView, stereotype)) {
            CreateAppliedStereotypeCompartmentCommand command = new CreateAppliedStereotypeCompartmentCommand(currentDomain, this.currentView, stereotype, "StereotypeBrace");
            CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
        }
        if ((braceCompartment = this.helper.getStereotypeBraceCompartment(this.currentView, stereotype)) != null && stereotype != null) {
            EList properties = stereotype.allAttributes();
            for (Property property : properties) {
                if (property == null || property.getName().startsWith("base_") || this.helper.isBracePropertyExist((Node)braceCompartment, property)) continue;
                CreateAppliedStereotypePropertyViewCommand command = new CreateAppliedStereotypePropertyViewCommand(currentDomain, (View)braceCompartment, property, "StereotypePropertyBrace");
                CommandUtil.executeUnsafeCommand((Command)command, (Object)this.currentView);
            }
            this.hideStereotypePropertiesNotDisplayed(StereotypeLocationEnum.IN_BRACE);
        }
    }

    private void hideStereotypePropertiesNotDisplayed(Enum<?> location) {
        String propertyList = this.migrationHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)this.currentView);
        if (!"".equals(propertyList)) {
            ArrayList<String> displayedProperties = new ArrayList<String>(Arrays.asList(propertyList.split(",")));
            EList<Stereotype> appliedStereotypesFromView = this.migrationHelper.getAppliedStereotypesFromView(this.currentView);
            if (appliedStereotypesFromView != null) {
                for (Stereotype stereotype : appliedStereotypesFromView) {
                    for (Property property : stereotype.allAttributes()) {
                        if (displayedProperties.contains(property.getQualifiedName())) continue;
                        this.hideProperty(stereotype, property, location);
                    }
                }
            }
        }
    }

    private void hideProperty(Stereotype stereotype, Property property, Enum<?> location) {
        View propertyView;
        View compartment = this.provider.getCompartment(stereotype, location);
        if (compartment != null && (propertyView = this.provider.getProperty(property, stereotype, location)) != null) {
            this.migrationHelper.updateVisibilityAndPersistence(propertyView, (EObject)this.currentView, false);
        }
    }
}

