/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.ide.IDE;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;

public class DecoratorModelLabelDecorator
extends BaseLabelProvider
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof Package && eObject.eResource() != null) {
            this.decoratePackage((Package)eObject, decoration);
        } else if (element instanceof IFile) {
            this.decorateFile((IFile)element, decoration);
        } else if (element instanceof IPapyrusFile) {
            this.decorateFile((IPapyrusFile)element, decoration);
        }
    }

    private void decorateFile(IFile file, IDecoration decoration) {
        IContentType type = IDE.getContentType((IFile)file);
        if (type != null && type.isKindOf(DecoratorModelUtils.DECORATOR_MODEL_CONTENT_TYPE)) {
            this.addOverlay(decoration);
        }
    }

    private void decorateFile(IPapyrusFile file, IDecoration decoration) {
        IResource[] iResourceArray = file.getAssociatedResources();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType type;
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && (type = IDE.getContentType((IFile)((IFile)resource))) != null && type.isKindOf(DecoratorModelUtils.DECORATOR_MODEL_CONTENT_TYPE)) {
                this.addOverlay(decoration);
                break;
            }
            ++n2;
        }
    }

    private void addOverlay(IDecoration decoration) {
        decoration.addOverlay(Activator.getDefault().getIcon("full/ovr16/profileApps.png"), 1);
    }

    private void decoratePackage(Package package_, IDecoration decoration) {
        if (package_.eContainer() == null && !DecoratorModelLabelDecorator.isUserOpenedDecoratorModel(package_) && !this.decoratePackageIcon(package_, decoration)) {
            return;
        }
        this.decoratePackageText(package_, decoration);
    }

    private static boolean isUserOpenedDecoratorModel(Package package_) {
        Resource main;
        UmlModel uml;
        boolean result = false;
        ResourceSet rset = EMFHelper.getResourceSet((EObject)package_);
        if (rset instanceof ModelSet && (uml = (UmlModel)((ModelSet)rset).getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel")) != null && DecoratorModelUtils.isDecoratorModel((Resource)(main = uml.getResource()))) {
            if (DecoratorModelUtils.isDecoratorModelFor((Resource)main, (Resource)package_.eResource())) {
                result = true;
            } else {
                for (Package next : DecoratorModelUtils.getLoadedSubUnitPackages((Package)package_)) {
                    if (!DecoratorModelUtils.isDecoratorModelFor((Resource)main, (Resource)next.eResource())) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private boolean decoratePackageIcon(Package package_, IDecoration decoration) {
        boolean result = false;
        ListenableFuture hasUnloadedDecoratorModels = DecoratorModelUtils.hasUnloadedDecoratorModelsAsync((Package)package_, (boolean)true);
        if (hasUnloadedDecoratorModels.isDone()) {
            result = true;
            if (((Boolean)Futures.getUnchecked((Future)hasUnloadedDecoratorModels)).booleanValue()) {
                this.addOverlay(decoration);
            }
            result = true;
        } else {
            hasUnloadedDecoratorModels.addListener(this.postUpdate(package_), (Executor)Activator.getDefault().getExecutorService());
        }
        return result;
    }

    private void decoratePackageText(Package package_, IDecoration decoration) {
        Set profileApplicationModels = null;
        for (ProfileApplication profileApplication : DecoratorModelUtils.getDecoratorModelProfileApplications((Package)package_)) {
            if (profileApplicationModels == null) {
                profileApplicationModels = Sets.newLinkedHashSet();
            }
            profileApplicationModels.add((Package)EcoreUtil.getRootContainer((EObject)profileApplication));
        }
        if (profileApplicationModels != null) {
            StringBuilder suffix = new StringBuilder();
            for (Package next : profileApplicationModels) {
                if (suffix.length() == 0) {
                    suffix.append(" (");
                } else {
                    suffix.append(", ");
                }
                String modelName = UMLLabelInternationalization.getInstance().getLabel((NamedElement)next);
                if (modelName == null) {
                    modelName = next.eResource().getURI().trimFileExtension().lastSegment();
                }
                suffix.append(modelName);
            }
            if (suffix.length() > 0) {
                suffix.append(")");
            }
            if (suffix.length() > 0) {
                decoration.addSuffix(suffix.toString());
            }
        }
    }

    private Runnable postUpdate(final Object element) {
        return new Runnable(){

            @Override
            public void run() {
                DecoratorModelLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DecoratorModelLabelDecorator.this, element));
            }
        };
    }
}

