/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.eclipse.project.editors.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.papyrus.eclipse.project.editors.Activator;
import org.eclipse.papyrus.eclipse.project.editors.interfaces.IFileEditor;

public abstract class AbstractFileEditor
implements IFileEditor {
    private final IProject project;
    private boolean dirty;

    public AbstractFileEditor(IProject project) {
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public void init() {
    }

    @Override
    public Set<String> getMissingFiles() {
        return new HashSet<String>();
    }

    protected InputStream getInputStream(String text) {
        if (text == null) {
            Activator.log.warn("Cannot open an input stream for a null text");
            return null;
        }
        final StringReader sr = new StringReader(text);
        InputStream is = new InputStream(){

            @Override
            public int read() throws IOException {
                return sr.read();
            }
        };
        return is;
    }

    @Override
    public boolean exists() {
        return this.getMissingFiles().size() == 0;
    }

    @Override
    public void create() {
        this.createFiles(this.getMissingFiles());
        this.init();
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected final void touch() {
        this.dirty = true;
    }

    @Override
    public final void save() {
        if (this.isDirty()) {
            this.doSave();
            this.dirty = false;
        }
    }

    protected abstract void doSave();
}

