/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.handlers;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PageImport {
    private String name;

    public PageImport(String name) {
        this.name = name;
    }

    public int add(IDocument document) {
        int offset = -1;
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
        try {
            if (model instanceof IDOMModel) {
                IDOMModel dom = (IDOMModel)model;
                boolean isXML = this.isXMLDocument(dom);
                int insertPosition = this.getInsertPosition(dom, isXML);
                offset = this.insertImportDeclaration(document, insertPosition, isXML);
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return offset;
    }

    private boolean isXMLDocument(IDOMModel model) {
        IDOMDocument documentNode = model.getDocument();
        Element docElement = documentNode.getDocumentElement();
        return docElement != null && (docElement.getNodeName().equals("jsp:root") || docElement.getAttributeNode("xmlns:jsp") != null || ((IDOMNode)docElement).getStartStructuredDocumentRegion() == null && ((IDOMNode)docElement).getEndStructuredDocumentRegion() == null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getInsertPosition(IDOMModel model, boolean isXML) {
        int pos = 0;
        IDOMDocument documentNode = model.getDocument();
        Node targetElement = null;
        if (isXML) {
            targetElement = documentNode.getDocumentElement();
        }
        if (targetElement == null) {
            targetElement = this.getInsertNode(documentNode);
        }
        if (targetElement == null) {
            return 0;
        }
        IStructuredDocumentRegion sdRegion = ((IDOMNode)targetElement).getFirstStructuredDocumentRegion();
        if (!isXML) {
            return sdRegion.getStartOffset();
        }
        pos = sdRegion.getEndOffset();
        try {
            IStructuredDocument doc = model.getStructuredDocument();
            while (pos < doc.getLength()) {
                if (doc.getChar(pos) != '\r' && doc.getChar(pos) != '\n') {
                    return pos;
                }
                ++pos;
            }
            return pos;
        }
        catch (BadLocationException badLocationException) {
            return pos;
        }
    }

    private Node getInsertNode(IDOMDocument documentNode) {
        NodeList childNodes = documentNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (childNodes.item(i).getNodeType() == 1) {
                return childNodes.item(i);
            }
            ++i;
        }
        return documentNode.getFirstChild();
    }

    private int insertImportDeclaration(IDocument document, int position, boolean isXML) {
        String closing;
        String opening;
        String delim = document instanceof IStructuredDocument ? ((IStructuredDocument)document).getLineDelimiter() : TextUtilities.getDefaultLineDelimiter((IDocument)document);
        boolean isCustomTag = this.isCustomTagDocument(document);
        if (isCustomTag) {
            if (isXML) {
                opening = "<jsp:directive.tag import=\"";
                closing = "\"/>";
            } else {
                opening = "<%@tag import=\"";
                closing = "\"%>";
            }
        } else if (isXML) {
            opening = "<jsp:directive.page import=\"";
            closing = "\"/>";
        } else {
            opening = "<%@page import=\"";
            closing = "\"%>";
        }
        String declaration = String.valueOf(opening) + this.name + closing + delim;
        InsertEdit edit = new InsertEdit(position, declaration);
        try {
            edit.apply(document);
            return declaration.length();
        }
        catch (BadLocationException badLocationException) {
        }
        catch (MalformedTreeException malformedTreeException) {}
        return -1;
    }

    private boolean isCustomTagDocument(IDocument doc) {
        boolean isTag = false;
        IStructuredModel sModel = StructuredModelManager.getModelManager().getExistingModelForRead(doc);
        try {
            String contentType;
            if (sModel instanceof IDOMModel && (contentType = ((IDOMModel)sModel).getContentTypeIdentifier()) != null) {
                IContentType modelCT = Platform.getContentTypeManager().getContentType(contentType);
                IContentType tagCT = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPTAG);
                if (modelCT != null && tagCT != null) {
                    isTag = modelCT.isKindOf(tagCT);
                }
            }
        }
        finally {
            if (sModel != null) {
                sModel.releaseFromRead();
            }
        }
        return isTag;
    }
}

