/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.breakpointproviders;

import com.ibm.icu.util.StringTokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class ClassPatternRegistry {
    private static ClassPatternRegistry fInstance = null;
    private Map fPatterns = null;
    private static final Iterator EMPTY = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    private ClassPatternRegistry() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.jst.jsp.ui", "classPatternProvider");
            this.fPatterns = new HashMap(elements.length);
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                String contentType = element.getAttribute("contentType");
                String pattern = element.getAttribute("pattern");
                if (pattern != null && contentType != null) {
                    StringTokenizer tokenizer = new StringTokenizer(pattern, ",");
                    HashSet<String> patterns = (HashSet<String>)this.fPatterns.get(contentType);
                    if (patterns == null) {
                        patterns = new HashSet<String>(0);
                        this.fPatterns.put(contentType, patterns);
                    }
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if ((token = token.trim()).length() <= 0) continue;
                        patterns.add(token);
                    }
                }
                ++i;
            }
        }
    }

    public String getClassPattern(String contentType) {
        if (this.fPatterns == null) {
            return null;
        }
        Set patterns = (Set)this.fPatterns.get(contentType);
        if (patterns != null) {
            Iterator it = patterns.iterator();
            StringBuffer buffer = new StringBuffer();
            while (it.hasNext()) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(it.next());
            }
            return buffer.toString();
        }
        return null;
    }

    public Iterator getClassPatternSegments(String contentType) {
        Set patterns;
        Iterator result = EMPTY;
        if (this.fPatterns != null && (patterns = (Set)this.fPatterns.get(contentType)) != null) {
            result = patterns.iterator();
        }
        return result;
    }

    public static synchronized ClassPatternRegistry getInstance() {
        if (fInstance == null) {
            fInstance = new ClassPatternRegistry();
        }
        return fInstance;
    }
}

