/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.internal.view.model.ITagRegistry;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.facelet.core.internal.util.ViewUtil;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XHTMLContentAssistProcessor
extends AbstractContentAssistProcessor {
    private IFile _file;
    private FaceletDocumentFactory _factory;
    private static final ICompletionProposal[] NO_PROPOSALS = new ICompletionProposal[0];

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        ICompletionProposal[] proposals = null;
        this._file = this.getFile(textViewer, documentPosition);
        if (this._file != null && this.shouldContribute(this._file)) {
            this._factory = new FaceletDocumentFactory(this._file.getProject());
            proposals = super.computeCompletionProposals(textViewer, documentPosition);
        }
        return proposals != null ? proposals : NO_PROPOSALS;
    }

    protected List getAvailableChildElementDeclarations(Element parent, int childPosition, int kindOfAction) {
        Map<String, ViewUtil.PrefixEntry> namespaces = this.getDocumentNamespaces(this._factory, childPosition);
        ArrayList availableChildElements = new ArrayList();
        for (Map.Entry<String, ViewUtil.PrefixEntry> entry : namespaces.entrySet()) {
            String prefix = entry.getValue().getPrefix();
            CMDocument cmDocument = this._factory.createCMDocumentForContext(entry.getValue().getUri(), prefix);
            if (cmDocument == null) continue;
            Iterator it = cmDocument.getElements().iterator();
            while (it.hasNext()) {
                availableChildElements.add(it.next());
            }
        }
        return availableChildElements;
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        ITextRegion textRegion = this.findNameRegionIfIsHTMLRoot(contentAssistRequest);
        if (textRegion != null) {
            String prefix;
            int colonPos;
            IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
            NamedNodeMap attributes = node.getAttributes();
            String attrName = node.getFirstStructuredDocumentRegion().getText(textRegion);
            if (attrName != null && (colonPos = attrName.indexOf(58)) > -1 && colonPos < attrName.length() - 1 && "xmlns".equals(prefix = attrName.substring(0, colonPos))) {
                ITagRegistry tagRegistry = ViewUtil.getHtmlTagRegistry((IProject)this._file.getProject());
                if (tagRegistry != null) {
                    Set alreadyUsed = ViewUtil.getDeclaredNamespaces((NamedNodeMap)attributes);
                    Collection namespaces = tagRegistry.getAllTagLibraries();
                    for (Namespace ns : namespaces) {
                        String possibleValue = ns.getNSUri();
                        if (ViewUtil.hasAttributeValue((Set)alreadyUsed, (String)possibleValue)) continue;
                        String rString = "\"" + possibleValue + "\"";
                        int rOffset = contentAssistRequest.getReplacementBeginPosition();
                        int rLength = contentAssistRequest.getReplacementLength();
                        int cursorAfter = possibleValue.length() + 1;
                        String displayString = "\"" + possibleValue + "\"";
                        CustomCompletionProposal proposal = new CustomCompletionProposal(rString, rOffset, rLength, cursorAfter, null, displayString, null, null, 800);
                        contentAssistRequest.addProposal((ICompletionProposal)proposal);
                    }
                }
                return;
            }
        }
        super.addAttributeValueProposals(contentAssistRequest);
    }

    private ITextRegion findNameRegionIfIsHTMLRoot(ContentAssistRequest contentAssistRequest) {
        IDOMNode node = (IDOMNode)contentAssistRequest.getNode();
        if (node.getNodeType() == 1 && "html".equals(node.getNodeName()) && node.getOwnerDocument().getDocumentElement() == node) {
            IStructuredDocumentRegion open = node.getFirstStructuredDocumentRegion();
            ITextRegionList openRegions = open.getRegions();
            int i = openRegions.indexOf(contentAssistRequest.getRegion());
            if (i < 0) {
                return null;
            }
            ITextRegion nameRegion = null;
            while (i >= 0) {
                if ((nameRegion = openRegions.get(i--)).getType() == "XML_TAG_ATTRIBUTE_NAME") break;
            }
            return nameRegion;
        }
        return null;
    }

    private Map<String, ViewUtil.PrefixEntry> getDocumentNamespaces(FaceletDocumentFactory factory, int offset) {
        IDOMContextResolver domContextResolver;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(this.fTextViewer, offset);
        Document doc = null;
        if (context != null && (doc = (domContextResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context)).getDOMDocument()) == null) {
            return Collections.EMPTY_MAP;
        }
        return ViewUtil.getDocumentNamespaces(doc);
    }

    protected CMElementDeclaration getCMElementDeclaration(Node node) {
        Element element;
        CMElementDeclaration elementDecl;
        if (node.getNodeType() == 1 && node.getPrefix() != null && (elementDecl = this._factory.createCMElementDeclaration(element = (Element)node)) != null) {
            return elementDecl;
        }
        return null;
    }

    private boolean shouldContribute(IFile file) {
        return ViewUtil.isFaceletVDLFile((IFile)file);
    }

    private IFile getFile(ITextViewer textViewer, int documentPosition) {
        IResource resource;
        IWorkspaceContextResolver resolver;
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext(textViewer, documentPosition);
        if (context != null && (resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(context)) != null && (resource = resolver.getResource()) != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }
}

