/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompositeOrTypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintOperator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ConstraintVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraint;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.ITypeConstraintFactory;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.SimpleTypeConstraint;

public class TypeConstraintFactory
implements ITypeConstraintFactory {
    private Map<ConstraintVariable, Map<ConstraintVariable, Map<ConstraintOperator, SimpleTypeConstraint>>> fSimpleConstraints = new HashMap<ConstraintVariable, Map<ConstraintVariable, Map<ConstraintOperator, SimpleTypeConstraint>>>();
    private Map<ConstraintVariable, Map<String, CompositeOrTypeConstraint>> fOrConstraints = new HashMap<ConstraintVariable, Map<String, CompositeOrTypeConstraint>>();
    protected static final boolean PRINT_STATS = false;
    protected int fNrCreated = 0;
    protected int fNrFiltered = 0;
    protected int fNrRetrieved = 0;

    private SimpleTypeConstraint createSimpleTypeConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        if (this.fSimpleConstraints.containsKey(v1)) {
            Map<ConstraintVariable, Map<ConstraintOperator, SimpleTypeConstraint>> m2 = this.fSimpleConstraints.get(v1);
            if (m2.containsKey(v2)) {
                Map<ConstraintOperator, SimpleTypeConstraint> m3 = m2.get(v2);
                if (m3.containsKey(operator)) {
                    return m3.get(operator);
                }
                return this.storeConstraint(v1, v2, operator, m3);
            }
            HashMap<ConstraintOperator, SimpleTypeConstraint> m3 = new HashMap<ConstraintOperator, SimpleTypeConstraint>();
            m2.put(v2, m3);
            return this.storeConstraint(v1, v2, operator, m3);
        }
        HashMap<ConstraintVariable, HashMap<ConstraintOperator, SimpleTypeConstraint>> m2 = new HashMap<ConstraintVariable, HashMap<ConstraintOperator, SimpleTypeConstraint>>();
        this.fSimpleConstraints.put(v1, m2);
        HashMap<ConstraintOperator, SimpleTypeConstraint> m3 = new HashMap<ConstraintOperator, SimpleTypeConstraint>();
        m2.put(v2, m3);
        return this.storeConstraint(v1, v2, operator, m3);
    }

    private SimpleTypeConstraint storeConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator, Map<ConstraintOperator, SimpleTypeConstraint> m3) {
        SimpleTypeConstraint constraint = new SimpleTypeConstraint(v1, v2, operator);
        m3.put(operator, constraint);
        return constraint;
    }

    public ITypeConstraint[] createConstraint(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        if (this.filter(v1, v2, operator)) {
            return new ITypeConstraint[0];
        }
        return new ITypeConstraint[]{this.createSimpleTypeConstraint(v1, v2, operator)};
    }

    @Override
    public ITypeConstraint[] createSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createSubTypeOperator());
    }

    @Override
    public ITypeConstraint[] createStrictSubtypeConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createStrictSubtypeOperator());
    }

    @Override
    public ITypeConstraint[] createEqualsConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createEqualsOperator());
    }

    @Override
    public ITypeConstraint[] createDefinesConstraint(ConstraintVariable v1, ConstraintVariable v2) {
        return this.createConstraint(v1, v2, ConstraintOperator.createDefinesOperator());
    }

    @Override
    public boolean filter(ConstraintVariable v1, ConstraintVariable v2, ConstraintOperator operator) {
        return v1.getBinding() != null && v1.getBinding().isPrimitive() && v2.getBinding() != null && v2.getBinding().isPrimitive() || v1 == v2;
    }

    @Override
    public CompositeOrTypeConstraint createCompositeOrTypeConstraint(ITypeConstraint[] constraints) {
        Map<Object, Object> m2;
        ConstraintVariable left = ((SimpleTypeConstraint)constraints[0]).getLeft();
        String bounds = "";
        ITypeConstraint[] iTypeConstraintArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeConstraint constraint = iTypeConstraintArray[n2];
            ConstraintVariable right = ((SimpleTypeConstraint)constraint).getRight();
            ITypeBinding binding = right.getBinding();
            String typeName = binding.getQualifiedName();
            bounds = String.valueOf(bounds) + typeName + ",";
            ++n2;
        }
        if (this.fOrConstraints.containsKey(left)) {
            m2 = this.fOrConstraints.get(left);
            if (m2.containsKey(bounds)) {
                return (CompositeOrTypeConstraint)m2.get(bounds);
            }
            CompositeOrTypeConstraint constraint = new CompositeOrTypeConstraint(constraints);
            m2.put(bounds, constraint);
            return constraint;
        }
        m2 = new HashMap();
        this.fOrConstraints.put(left, m2);
        CompositeOrTypeConstraint constraint = new CompositeOrTypeConstraint(constraints);
        m2.put(bounds, constraint);
        return constraint;
    }

    protected void dumpStats() {
        System.out.println("Constraints: " + this.fNrCreated + " created, " + this.fNrRetrieved + " retrieved, " + this.fNrFiltered + " filtered");
    }
}

