/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.acceleo.compatibility.model.mt.core.Template;
import org.eclipse.acceleo.compatibility.model.mt.expressions.Expression;
import org.eclipse.acceleo.compatibility.model.mt.statements.If;
import org.eclipse.acceleo.compatibility.model.mt.statements.Statement;
import org.eclipse.acceleo.compatibility.model.mt.statements.StatementsFactory;
import org.eclipse.acceleo.internal.compatibility.AcceleoCompatibilityMessages;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.expressions.ExpressionParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.ast.statements.StatementParser;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.Region;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateConstants;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TemplateSyntaxException;
import org.eclipse.acceleo.internal.compatibility.parser.mt.common.TextSearch;

public final class IfParser {
    private IfParser() {
    }

    public static If createIf(int offset, String buffer, Region range, Template template) throws TemplateSyntaxException {
        List<Object> ifBlock;
        List<Object> elseBlock;
        Expression condition;
        ArrayList<Expression> elseIfConditions = new ArrayList<Expression>();
        ArrayList<List<Statement>> elseIfBlocks = new ArrayList<List<Statement>>();
        Region iThen = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfThen(), range, TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
        if (iThen.b() > -1) {
            int iThenEnd;
            condition = ExpressionParser.createExpression(offset, buffer, new Region(range.b(), iThen.b()), template);
            Region iElse = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfElse(), new Region(iThen.e(), range.e()), null, TemplateConstants.getDefault().getInhibsStatement());
            if (iElse.b() > -1) {
                iThenEnd = iElse.b();
                Region elsePos = new Region(iElse.e(), range.e());
                elsePos = StatementParser.formatTemplate(buffer, elsePos, 0);
                elseBlock = StatementParser.createStatement(offset, buffer, elsePos, template);
            } else {
                iThenEnd = range.e();
                elseBlock = new ArrayList();
            }
            int iElseIfEndMax = iThenEnd;
            Region iElseIf = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfElseIf(), new Region(iThen.e(), iElseIfEndMax), null, TemplateConstants.getDefault().getInhibsStatement());
            if (iElseIf.b() > -1) {
                iThenEnd = iElseIf.b();
                while (iElseIf.b() > -1) {
                    Region iTestEnd = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfThen(), new Region(iElseIf.e(), iElseIfEndMax), TemplateConstants.getDefault().getSpec(), TemplateConstants.getDefault().getInhibsExpression());
                    if (iTestEnd.b() <= -1) {
                        throw new TemplateSyntaxException(AcceleoCompatibilityMessages.getString("TemplateSyntaxError.MissingCloseIf"), template, new Region(iElseIf.e(), iElseIfEndMax));
                    }
                    Expression elseIfTest = ExpressionParser.createExpression(offset, buffer, new Region(iElseIf.e(), iTestEnd.b()), template);
                    iElseIf = TextSearch.indexIn(buffer, TemplateConstants.getDefault().getIfElseIf(), new Region(iTestEnd.e(), iElseIfEndMax), null, TemplateConstants.getDefault().getInhibsStatement());
                    Region elseIfPos = iElseIf.b() > -1 ? new Region(iTestEnd.e(), iElseIf.b()) : new Region(iTestEnd.e(), iElseIfEndMax);
                    elseIfPos = StatementParser.formatTemplate(buffer, elseIfPos, 0);
                    List<Statement> elseIfBlock = StatementParser.createStatement(offset, buffer, elseIfPos, template);
                    elseIfConditions.add(elseIfTest);
                    elseIfBlocks.add(elseIfBlock);
                }
            }
            Region ifPos = new Region(iThen.e(), iThenEnd);
            ifPos = StatementParser.formatTemplate(buffer, ifPos, 0);
            ifBlock = StatementParser.createStatement(offset, buffer, ifPos, template);
        } else {
            condition = ExpressionParser.createExpression(offset, buffer, new Region(range.b(), range.e()), template);
            ifBlock = new ArrayList();
            elseBlock = new ArrayList();
        }
        If eIf = StatementsFactory.eINSTANCE.createIf();
        eIf.setCondition(condition);
        eIf.getThenStatements().addAll(ifBlock);
        eIf.getElseStatements().addAll(elseBlock);
        int i = 0;
        while (i < elseIfConditions.size()) {
            if (elseIfConditions.get(i) != null) {
                If eElseIf = StatementsFactory.eINSTANCE.createIf();
                eElseIf.setCondition((Expression)elseIfConditions.get(i));
                if (elseIfBlocks.get(i) != null) {
                    eElseIf.getThenStatements().addAll((Collection)elseIfBlocks.get(i));
                }
                eIf.getElseIf().add((Object)eElseIf);
            }
            ++i;
        }
        eIf.setBegin(offset + range.b());
        eIf.setEnd(offset + range.e());
        return eIf;
    }
}

