/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.Var;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.StaticScope;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Scope
implements StaticScope {
    private final Map<String, Var> vars = new LinkedHashMap<String, Var>();
    private final Scope parent;
    protected final int depth;
    protected final Node rootNode;
    private Var arguments;

    Scope(Scope parent, Node rootNode) {
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)rootNode);
        Preconditions.checkArgument((rootNode != parent.rootNode ? 1 : 0) != 0, (String)"Root node: %s\nParent's root node: %s", (Object[])new Object[]{rootNode, parent.rootNode});
        this.parent = parent;
        this.rootNode = rootNode;
        this.depth = parent.depth + 1;
    }

    protected Scope(Node rootNode) {
        Preconditions.checkNotNull((Object)rootNode);
        this.parent = null;
        this.rootNode = rootNode;
        this.depth = 0;
    }

    public String toString() {
        return "Scope@" + this.rootNode;
    }

    static Scope createGlobalScope(Node rootNode) {
        return new Scope(rootNode);
    }

    public int getDepth() {
        return this.depth;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public Scope getParent() {
        return this.parent;
    }

    Scope getGlobalScope() {
        Scope result = this;
        while (result.getParent() != null) {
            result = result.getParent();
        }
        return result;
    }

    @Override
    public StaticScope getParentScope() {
        return this.parent;
    }

    Var declare(String name, Node nameNode, CompilerInput input) {
        Preconditions.checkState((name != null && !name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(name) == null ? 1 : 0) != 0);
        Var var = new Var(name, nameNode, this, this.vars.size(), input);
        this.vars.put(name, var);
        return var;
    }

    void undeclare(Var var) {
        Preconditions.checkState((var.scope == this ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(var.name) == var ? 1 : 0) != 0);
        this.vars.remove(var.name);
    }

    @Override
    public Var getSlot(String name) {
        return this.getVar(name);
    }

    @Override
    public Var getOwnSlot(String name) {
        return this.vars.get(name);
    }

    public Var getVar(String name) {
        Scope scope = this;
        while (scope != null) {
            Var var = scope.vars.get(name);
            if (var != null) {
                return var;
            }
            if ("arguments".equals(name) && NodeUtil.isVanillaFunction(scope.getRootNode())) {
                return scope.getArgumentsVar();
            }
            scope = scope.parent;
        }
        return null;
    }

    public Var getArgumentsVar() {
        if (this.arguments == null) {
            this.arguments = Var.makeArgumentsVar(this);
        }
        return this.arguments;
    }

    public boolean isDeclared(String name, boolean recurse) {
        Scope scope = this;
        while (true) {
            if (scope.vars.containsKey(name)) {
                return true;
            }
            if (!scope.isFunctionBlockScope() && (scope.parent == null || !recurse)) break;
            scope = scope.parent;
        }
        return false;
    }

    public <T extends Var> Iterator<T> getVars() {
        return this.vars.values().iterator();
    }

    Iterable<Var> getVarIterable() {
        return this.vars.values();
    }

    public Iterable<? extends Var> getAllSymbols() {
        return Collections.unmodifiableCollection(this.vars.values());
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return this.parent != null;
    }

    public boolean isBlockScope() {
        return NodeUtil.createsBlockScope(this.rootNode);
    }

    public boolean isFunctionBlockScope() {
        return this.isBlockScope() && this.parent != null && this.parent.getRootNode().isFunction();
    }

    public boolean isFunctionScope() {
        return this.getRootNode().isFunction();
    }

    public Scope getClosestHoistScope() {
        Scope current = this;
        while (current != null) {
            if (current.isFunctionScope() || current.isFunctionBlockScope() || current.isGlobal()) {
                return current;
            }
            current = current.parent;
        }
        return null;
    }
}

