/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.BreakpointTypeExtension;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.internal.ScriptRegExpBreakpointTarget;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonProtocolParseException;
import org.eclipse.wst.jsdt.chromium.internal.v8native.BreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.v8native.DebugSession;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8CommandCallbackBase;
import org.eclipse.wst.jsdt.chromium.internal.v8native.V8VersionFeatures;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.BreakpointBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.CommandResponseBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FailedCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.FlagsBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.ListBreakpointsBody;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.SuccessCommandResponse;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.input.data.BreakpointInfo;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ChangeBreakpointMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.DebuggerMessageFactory;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.FlagsMessage;
import org.eclipse.wst.jsdt.chromium.internal.v8native.protocol.output.ListBreakpointsMessage;
import org.eclipse.wst.jsdt.chromium.util.GenericCallback;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class BreakpointManager {
    private static final Logger LOGGER = Logger.getLogger(BreakpointManager.class.getName());
    private final Map<Long, BreakpointImpl> idToBreakpoint = Collections.synchronizedMap(new HashMap());
    private final DebugSession debugSession;
    private static final List<String> BREAK_ON_EXCEPTION_FLAG_NAMES = Arrays.asList("breakOnCaughtException", "breakOnUncaughtException");
    private final BreakpointTypeExtension breakpointTypeExtension = new BreakpointTypeExtension(){
        private final BreakpointTypeExtension.FunctionSupport functionSupport = new BreakpointTypeExtension.FunctionSupport(){

            @Override
            public Breakpoint.Target createTarget(String expression) {
                return new BreakpointImpl.FunctionTarget(expression);
            }
        };
        private final BreakpointTypeExtension.ScriptRegExpSupport scriptRegExpSupport = new BreakpointTypeExtension.ScriptRegExpSupport(){

            @Override
            public Breakpoint.Target createTarget(String regExp) {
                return new ScriptRegExpBreakpointTarget(regExp);
            }
        };

        @Override
        public BreakpointTypeExtension.FunctionSupport getFunctionSupport() {
            return this.functionSupport;
        }

        @Override
        public BreakpointTypeExtension.ScriptRegExpSupport getScriptRegExpSupport() {
            if (!V8VersionFeatures.isRegExpBreakpointSupported(BreakpointManager.this.debugSession.getVmVersion())) {
                return null;
            }
            return this.scriptRegExpSupport;
        }
    };

    public BreakpointManager(DebugSession debugSession) {
        this.debugSession = debugSession;
    }

    DebugSession getDebugSession() {
        return this.debugSession;
    }

    public BreakpointTypeExtension getBreakpointTypeExtension() {
        return this.breakpointTypeExtension;
    }

    public RelayOk setBreakpoint(Breakpoint.Target target, int line, int column, boolean enabled, String condition, JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        return this.setBreakpoint(target, line, column, enabled, condition, -1, callback, syncCallback);
    }

    RelayOk setBreakpoint(final Breakpoint.Target target, final int line, int column, final boolean enabled, final String condition, int ignoreCount, final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        return this.debugSession.sendMessageAsync(DebuggerMessageFactory.setBreakpoint(target, BreakpointManager.toNullableInteger(line), BreakpointManager.toNullableInteger(column), enabled, condition, BreakpointManager.toNullableInteger(ignoreCount)), true, new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                BreakpointBody body;
                try {
                    body = successResponse.body().asBreakpointBody();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                long id = body.breakpoint();
                BreakpointImpl breakpoint = new BreakpointImpl(id, target, line, enabled, condition, BreakpointManager.this);
                BreakpointManager.this.idToBreakpoint.put(breakpoint.getId(), breakpoint);
                if (callback != null) {
                    callback.success(breakpoint);
                }
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                if (callback != null) {
                    callback.failure(message);
                }
            }
        }, syncCallback);
    }

    public Breakpoint getBreakpoint(Long id) {
        return this.idToBreakpoint.get(id);
    }

    public RelayOk clearBreakpoint(BreakpointImpl breakpointImpl, final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback, long originalId) {
        long id = originalId;
        if (id == -1L) {
            return RelaySyncCallback.finish(syncCallback);
        }
        this.idToBreakpoint.remove(id);
        return this.debugSession.sendMessageAsync(DebuggerMessageFactory.clearBreakpoint(id), true, new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                if (callback != null) {
                    callback.success(null);
                }
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                if (callback != null) {
                    callback.failure(message);
                }
            }
        }, syncCallback);
    }

    public RelayOk changeBreakpoint(final BreakpointImpl breakpointImpl, final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        ChangeBreakpointMessage message = new ChangeBreakpointMessage(breakpointImpl.getId(), breakpointImpl.isEnabled(), breakpointImpl.getCondition());
        return this.debugSession.sendMessageAsync(message, true, new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                if (callback != null) {
                    callback.success(breakpointImpl);
                }
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                if (callback != null) {
                    callback.failure(message);
                }
            }
        }, syncCallback);
    }

    public RelayOk reloadBreakpoints(final JavascriptVm.ListBreakpointsCallback callback, SyncCallback syncCallback) {
        V8CommandCallbackBase v8Callback = new V8CommandCallbackBase(){

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                callback.failure(new Exception(message));
            }

            @Override
            public void success(SuccessCommandResponse successResponse) {
                Collection updatedBreakpoints;
                ListBreakpointsBody listBreakpointsBody;
                CommandResponseBody body = successResponse.body();
                try {
                    listBreakpointsBody = body.asListBreakpointsBody();
                }
                catch (JsonProtocolParseException e) {
                    callback.failure(new Exception("Failed to read server response", e));
                    return;
                }
                List<BreakpointInfo> infos = listBreakpointsBody.breakpoints();
                try {
                    updatedBreakpoints = BreakpointManager.this.syncBreakpoints(infos);
                }
                catch (RuntimeException e) {
                    callback.failure(new Exception("Failed to read server response", e));
                    return;
                }
                callback.success(Collections.unmodifiableCollection(updatedBreakpoints));
            }
        };
        return this.debugSession.sendMessageAsync(new ListBreakpointsMessage(), true, v8Callback, syncCallback);
    }

    public RelayOk enableBreakpoints(Boolean enabled, GenericCallback<Boolean> callback, SyncCallback syncCallback) {
        return this.setRemoteFlag("breakPointsActive", enabled, callback, syncCallback);
    }

    public RelayOk setBreakOnException(JavascriptVm.ExceptionCatchMode catchMode, final GenericCallback<JavascriptVm.ExceptionCatchMode> callback, SyncCallback syncCallback) {
        Boolean uncaughtValue;
        Boolean caughtValue;
        if (catchMode == null) {
            caughtValue = null;
            uncaughtValue = null;
        } else {
            switch (catchMode) {
                case ALL: {
                    caughtValue = true;
                    uncaughtValue = true;
                    break;
                }
                case NONE: {
                    caughtValue = false;
                    uncaughtValue = false;
                    break;
                }
                case UNCAUGHT: {
                    caughtValue = false;
                    uncaughtValue = true;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        List<Boolean> flagValues = Arrays.asList(caughtValue, uncaughtValue);
        GenericCallback<List<Boolean>> wrappedCallback = callback == null ? null : new GenericCallback<List<Boolean>>(){

            @Override
            public void success(List<Boolean> values) {
                JavascriptVm.ExceptionCatchMode newCatchMode = values.get(0).booleanValue() ? (values.get(1).booleanValue() ? JavascriptVm.ExceptionCatchMode.ALL : null) : (values.get(1) != false ? JavascriptVm.ExceptionCatchMode.UNCAUGHT : JavascriptVm.ExceptionCatchMode.NONE);
                callback.success(newCatchMode);
            }

            @Override
            public void failure(Exception exception) {
                callback.failure(exception);
            }
        };
        return this.setRemoteFlags(BREAK_ON_EXCEPTION_FLAG_NAMES, flagValues, wrappedCallback, syncCallback);
    }

    private RelayOk setRemoteFlag(String flagName, Boolean value, final GenericCallback<Boolean> callback, SyncCallback syncCallback) {
        GenericCallback<List<Boolean>> wrappedCallback = callback == null ? null : new GenericCallback<List<Boolean>>(){

            @Override
            public void success(List<Boolean> value) {
                callback.success(value.get(0));
            }

            @Override
            public void failure(Exception exception) {
                callback.failure(exception);
            }
        };
        return this.setRemoteFlags(Collections.singletonList(flagName), Collections.singletonList(value), wrappedCallback, syncCallback);
    }

    private RelayOk setRemoteFlags(final List<String> flagNames, List<Boolean> values, final GenericCallback<List<Boolean>> callback, SyncCallback syncCallback) {
        HashMap<String, Object> flagMap = new HashMap<String, Object>(values.size());
        int i = 0;
        while (i < flagNames.size()) {
            Boolean jsonValue = values.get(i);
            flagMap.put(flagNames.get(i), jsonValue);
            ++i;
        }
        V8CommandCallbackBase v8Callback = callback == null ? null : new V8CommandCallbackBase(){

            @Override
            public void success(SuccessCommandResponse successResponse) {
                FlagsBody body;
                try {
                    body = successResponse.body().asFlagsBody();
                }
                catch (JsonProtocolParseException e) {
                    throw new RuntimeException(e);
                }
                List<FlagsBody.FlagInfo> flagList = body.flags();
                ArrayList<Boolean> result = new ArrayList<Boolean>(flagNames.size());
                for (String name : flagNames) {
                    Boolean boolValue;
                    FlagsBody.FlagInfo f2;
                    block6: {
                        for (FlagsBody.FlagInfo f2 : flagList) {
                            if (!name.equals(f2.name())) continue;
                            break block6;
                        }
                        throw new RuntimeException("Failed to find the correct flag in response");
                    }
                    FlagsBody.FlagInfo flag = f2;
                    Object flagValue = flag.value();
                    if (!(flagValue instanceof Boolean)) {
                        LOGGER.info("Flag value has a wrong type");
                        boolValue = null;
                    } else {
                        boolValue = (Boolean)flagValue;
                    }
                    result.add(boolValue);
                }
                callback.success(result);
            }

            @Override
            public void failure(String message, FailedCommandResponse.ErrorDetails errorDetails) {
                callback.failure(new Exception(message));
            }
        };
        return this.debugSession.sendMessageAsync(new FlagsMessage(flagMap), true, v8Callback, syncCallback);
    }

    private static Integer toNullableInteger(int value) {
        return value == -1 ? null : Integer.valueOf(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Breakpoint> syncBreakpoints(List<BreakpointInfo> infoList) {
        Map<Long, BreakpointImpl> map = this.idToBreakpoint;
        synchronized (map) {
            ArrayList<Breakpoint> result = new ArrayList<Breakpoint>();
            HashMap<Long, BreakpointImpl> actualBreakpoints = new HashMap<Long, BreakpointImpl>();
            for (BreakpointInfo info : infoList) {
                if (info.type() == BreakpointInfo.Type.FUNCTION) continue;
                BreakpointImpl breakpoint = this.idToBreakpoint.get(info.number());
                if (breakpoint == null) {
                    breakpoint = new BreakpointImpl(info, this);
                } else {
                    breakpoint.updateFromRemote(info);
                }
                BreakpointImpl conflict = actualBreakpoints.put(info.number(), breakpoint);
                if (conflict != null) {
                    throw new RuntimeException("Duplicated breakpoint number " + info.number());
                }
                result.add(breakpoint);
            }
            Iterator<Long> it = this.idToBreakpoint.keySet().iterator();
            while (it.hasNext()) {
                Long id = it.next();
                if (actualBreakpoints.containsKey(id)) continue;
                it.remove();
            }
            for (BreakpointImpl breakpoint : actualBreakpoints.values()) {
                if (this.idToBreakpoint.containsKey(breakpoint.getId())) continue;
                this.idToBreakpoint.put(breakpoint.getId(), breakpoint);
                result.add(breakpoint);
            }
            return result;
        }
    }
}

