/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IFileContentManager;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationContext;
import org.eclipse.team.core.subscribers.SubscriberScopeManager;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.AbstractCommitAction;
import org.eclipse.team.internal.ccvs.ui.mappings.WorkspaceSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardCommitPage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardFileTypePage;
import org.eclipse.team.internal.ccvs.ui.wizards.CommitWizardParticipant;
import org.eclipse.team.internal.ccvs.ui.wizards.ResizableWizard;
import org.eclipse.team.internal.core.subscribers.SubscriberDiffTreeEventHandler;
import org.eclipse.team.internal.ui.Policy;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class CommitWizard
extends ResizableWizard {
    public static final String COMMIT_WIZARD_DIALOG_SETTINGS = "CommitWizard";
    private final IResource[] fResources;
    private IResource[] fUnaddedDiffs;
    private final ModelSynchronizeParticipant fParticipant;
    private CommitWizardFileTypePage fFileTypePage;
    private CommitWizardCommitPage fCommitPage;
    private IJobChangeListener jobListener;
    private IWorkbenchPart part;

    public CommitWizard(SyncInfoSet infos) throws CVSException {
        this(infos.getResources());
    }

    public CommitWizard(IResource[] resources) throws CVSException {
        super(COMMIT_WIZARD_DIALOG_SETTINGS, CVSUIPlugin.getPlugin().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(CVSUIMessages.CommitWizard_2);
        this.setDefaultPageImageDescriptor(CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png"));
        this.fResources = resources;
        ResourceMapping[] mappings = Utils.getResourceMappings((Object[])resources);
        this.fParticipant = this.createWorkspaceParticipant(mappings, this.getShell());
        this.getAllOutOfSync();
        this.fUnaddedDiffs = this.getUnaddedResources(this.getDiffTree().getAffectedResources());
    }

    private ModelSynchronizeParticipant createWorkspaceParticipant(ResourceMapping[] selectedMappings, Shell shell) {
        SubscriberScopeManager manager = WorkspaceSubscriberContext.createWorkspaceScopeManager(selectedMappings, true, CommitAction.isIncludeChangeSets(shell, CVSUIMessages.SyncAction_1));
        return new CommitWizardParticipant((SynchronizationContext)WorkspaceSubscriberContext.createContext((ISynchronizationScopeManager)manager, 3), this);
    }

    public CommitWizard(SyncInfoSet infos, IJobChangeListener jobListener) throws CVSException {
        this(infos);
        this.jobListener = jobListener;
    }

    private void getAllOutOfSync() throws CVSException {
        try {
            ISynchronizationContext context = this.getParticipant().getContext();
            SubscriberDiffTreeEventHandler handler = (SubscriberDiffTreeEventHandler)Adapters.adapt((Object)context, SubscriberDiffTreeEventHandler.class);
            handler.initializeIfNeeded();
            Job.getJobManager().join((Object)context, null);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    public boolean hasOutgoingChanges() {
        IResourceDiffTree tree = this.getDiffTree();
        return tree != null && tree.hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                return AbstractCommitAction.hasLocalChange(diff);
            }
        });
    }

    boolean hasConflicts() {
        IResourceDiffTree tree = this.getDiffTree();
        return tree != null && tree.hasMatchingDiffs(ResourcesPlugin.getWorkspace().getRoot().getFullPath(), new FastDiffFilter(){

            public boolean select(IDiff diff) {
                if (diff instanceof IThreeWayDiff) {
                    IThreeWayDiff twd = (IThreeWayDiff)diff;
                    return twd.getDirection() == 768;
                }
                return false;
            }
        });
    }

    public int getHighestProblemSeverity() {
        IResource[] resources = this.getDiffTree().getAffectedResources();
        int mostSeriousSeverity = -1;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            try {
                int severity = resource.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 0);
                if (severity > mostSeriousSeverity) {
                    mostSeriousSeverity = severity;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return mostSeriousSeverity;
    }

    IResourceDiffTree getDiffTree() {
        return this.fParticipant.getContext().getDiffTree();
    }

    public CommitWizardFileTypePage getFileTypePage() {
        return this.fFileTypePage;
    }

    public CommitWizardCommitPage getCommitPage() {
        return this.fCommitPage;
    }

    public ModelSynchronizeParticipant getParticipant() {
        return this.fParticipant;
    }

    public boolean canFinish() {
        IWizardPage current = this.getContainer().getCurrentPage();
        if (current == this.fFileTypePage && this.fCommitPage != null) {
            return false;
        }
        return super.canFinish();
    }

    @Override
    public boolean performFinish() {
        IResource[] unadded;
        String comment = this.fCommitPage.getComment(this.getShell());
        if (comment == null) {
            return false;
        }
        IResource[] resources = AbstractCommitAction.getOutgoingChanges(this.getDiffTree(), this.fCommitPage.getTraversalsToCommit(), null);
        if (resources.length == 0) {
            return true;
        }
        try {
            unadded = this.getUnaddedResources(resources);
        }
        catch (CVSException cVSException) {
            return false;
        }
        IResource[] files = this.getFiles(resources);
        AddAndCommitOperation operation = new AddAndCommitOperation(this.getPart(), files, unadded, comment);
        if (this.jobListener != null) {
            operation.setJobChangeListener(this.jobListener);
        }
        if (this.fFileTypePage != null) {
            HashMap extensionsToSave = new HashMap();
            HashMap extensionsNotToSave = new HashMap();
            this.fFileTypePage.getModesForExtensions(extensionsToSave, extensionsNotToSave);
            CommitWizardFileTypePage.saveExtensionMappings(extensionsToSave);
            operation.setModesForExtensionsForOneTime(extensionsNotToSave);
            HashMap namesToSave = new HashMap();
            HashMap namesNotToSave = new HashMap();
            this.fFileTypePage.getModesForNames(namesToSave, namesNotToSave);
            CommitWizardFileTypePage.saveNameMappings(namesToSave);
            operation.setModesForNamesForOneTime(namesNotToSave);
        }
        try {
            operation.run();
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.fCommitPage.finish();
        return super.performFinish();
    }

    public boolean performCancel() {
        this.fCommitPage.finish();
        return super.performCancel();
    }

    public void addPages() {
        HashSet<String> names = new HashSet<String>();
        HashSet<String> extensions = new HashSet<String>();
        this.getUnknownNamesAndExtension(this.fUnaddedDiffs, names, extensions);
        if (names.size() + extensions.size() > 0) {
            this.fFileTypePage = new CommitWizardFileTypePage(extensions, names);
            this.addPage((IWizardPage)this.fFileTypePage);
        }
        this.fCommitPage = new CommitWizardCommitPage(this.fResources, this);
        this.addPage((IWizardPage)this.fCommitPage);
        super.addPages();
    }

    public void dispose() {
        this.fParticipant.dispose();
        super.dispose();
    }

    public static void run(IWorkbenchPart part, Shell shell, IResource[] resources) throws CVSException {
        try {
            CommitWizard commitWizard = new CommitWizard(resources);
            commitWizard.setPart(part);
            CommitWizard.run(shell, commitWizard);
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    private void setPart(IWorkbenchPart part) {
        this.part = part;
    }

    public static void run(Shell shell, SyncInfoSet infos, IJobChangeListener jobListener) throws CVSException {
        try {
            CommitWizard.run(shell, new CommitWizard(infos, jobListener));
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public static void run(IWorkbenchPart part, Shell shell, ResourceTraversal[] traversals) throws CVSException {
        try {
            IResource[][] resources = new IResource[1][];
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                try {
                    iResourceArray[0] = CommitWizard.getDeepResourcesToCommit(traversals, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            });
            CommitWizard.run(part, shell, resources[0]);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InvocationTargetException e) {
            throw CVSException.wrapException((Exception)e);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IWorkbenchPart getPart() {
        if (this.part != null) {
            return this.part;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
    }

    private static void run(Shell shell, CommitWizard wizard) {
        if (!wizard.hasOutgoingChanges()) {
            MessageDialog.openInformation((Shell)shell, (String)CVSUIMessages.CommitWizard_6, (String)CVSUIMessages.CommitWizard_7);
        } else {
            int highestProblemSeverity = wizard.getHighestProblemSeverity();
            IPreferenceStore preferenceStore = CVSUIPlugin.getPlugin().getPreferenceStore();
            switch (highestProblemSeverity) {
                case 1: {
                    MessageDialogWithToggle warningDialog;
                    String allowCommitsWithWarnings = preferenceStore.getString("pref_commit_with_warning");
                    if (!"prompt".equals(allowCommitsWithWarnings) && !"never".equals(allowCommitsWithWarnings) || 2 == (warningDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)CVSUIMessages.CommitWizard_8, (String)CVSUIMessages.CommitWizard_9, (String)CVSUIMessages.CommitWizard_10, (boolean)false, (IPreferenceStore)preferenceStore, (String)"pref_commit_with_warning")).getReturnCode()) break;
                    return;
                }
                case 2: {
                    MessageDialogWithToggle errorDialog;
                    String allowCommitsWithErrors = preferenceStore.getString("pref_commit_with_errors");
                    if (!"prompt".equals(allowCommitsWithErrors) && !"never".equals(allowCommitsWithErrors) || 2 == (errorDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)CVSUIMessages.CommitWizard_11, (String)CVSUIMessages.CommitWizard_12, (String)CVSUIMessages.CommitWizard_13, (boolean)false, (IPreferenceStore)preferenceStore, (String)"pref_commit_with_errors")).getReturnCode()) break;
                    return;
                }
            }
            CommitWizard.open(shell, wizard);
        }
    }

    protected static int open(Shell shell, ResizableWizard wizard) {
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.setPageSize(wizard.loadSize());
        return dialog.open();
    }

    private void getUnknownNamesAndExtension(IResource[] resources, Collection<String> names, Collection<String> extensions) {
        IFileContentManager manager = Team.getFileContentManager();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource local = iResourceArray[n2];
            if (local instanceof IFile && manager.getType((IStorage)((IFile)local)) == 0) {
                String extension = local.getFileExtension();
                if (extension != null && !manager.isKnownExtension(extension)) {
                    extensions.add(extension);
                }
                String name = local.getName();
                if (extension == null && name != null && !manager.isKnownFilename(name)) {
                    names.add(name);
                }
            }
            ++n2;
        }
    }

    private IResource[] getUnaddedResources(IResource[] resources) throws CVSException {
        ArrayList<IResource> unadded = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!CommitWizard.isAdded(resource)) {
                unadded.add(resource);
            }
            ++n2;
        }
        return unadded.toArray(new IResource[0]);
    }

    private IResource[] getFiles(IResource[] resources) {
        ArrayList<IResource> files = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                files.add(resource);
            }
            ++n2;
        }
        return files.toArray(new IResource[0]);
    }

    private static boolean isAdded(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (cvsResource.isFolder()) {
            return ((ICVSFolder)cvsResource).isCVSFolder();
        }
        return cvsResource.isManaged();
    }

    private static IResource[] getDeepResourcesToCommit(ResourceTraversal[] traversals, IProgressMonitor monitor) throws CoreException {
        ArrayList<IResource> roots = new ArrayList<IResource>();
        ResourceTraversal[] resourceTraversalArray = traversals;
        int n = traversals.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceTraversal traversal = resourceTraversalArray[n2];
            IResource[] resources = traversal.getResources();
            if (traversal.getDepth() == 2) {
                roots.addAll(Arrays.asList(resources));
            } else if (traversal.getDepth() == 0) {
                CommitWizard.collectShallowFiles(resources, roots);
            } else if (traversal.getDepth() == 1) {
                CommitWizard.collectShallowFiles(resources, roots);
                IResource[] iResourceArray = resources;
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource resource = iResourceArray[n4];
                    if (resource.getType() != 1) {
                        CommitWizard.collectShallowFiles(CommitWizard.members(resource), roots);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    private static IResource[] members(IResource resource) throws CoreException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().members(resource);
    }

    private static void collectShallowFiles(IResource[] resources, List<IResource> roots) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1) {
                roots.add(resource);
            }
            ++n2;
        }
    }

    public static class AddAndCommitOperation
    extends CVSOperation {
        private final IResource[] fAllResources;
        private final String fComment;
        private Map fModesForExtensionsForOneTime;
        private Map fModesForNamesForOneTime;
        private IResource[] fNewResources;
        private IJobChangeListener jobListener;

        public AddAndCommitOperation(IWorkbenchPart part, IResource[] allResources, IResource[] newResources, String comment) {
            super(part);
            this.fAllResources = allResources;
            this.fNewResources = newResources;
            this.fModesForExtensionsForOneTime = Collections.EMPTY_MAP;
            this.fModesForNamesForOneTime = Collections.EMPTY_MAP;
            this.fComment = comment;
        }

        public void setModesForExtensionsForOneTime(Map modes) {
            if (modes != null) {
                this.fModesForExtensionsForOneTime = modes;
            }
        }

        public void setModesForNamesForOneTime(Map modes) {
            if (modes != null) {
                this.fModesForNamesForOneTime = modes;
            }
        }

        @Override
        protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
            try {
                try {
                    monitor.beginTask(null, (this.fNewResources.length + this.fAllResources.length) * 100);
                    if (this.fNewResources.length > 0) {
                        AddOperation op = new AddOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(this.fNewResources));
                        op.addModesForExtensions(this.fModesForExtensionsForOneTime);
                        op.addModesForNames(this.fModesForNamesForOneTime);
                        op.run(Policy.subMonitorFor((IProgressMonitor)monitor, (int)(this.fNewResources.length * 100)));
                    }
                    if (this.fAllResources.length > 0) {
                        CommitOperation commitOperation = new CommitOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(this.fAllResources), new Command.LocalOption[0], this.fComment){

                            @Override
                            public boolean consultModelsForMappings() {
                                return false;
                            }
                        };
                        commitOperation.run(Policy.subMonitorFor((IProgressMonitor)monitor, (int)(this.fAllResources.length * 100)));
                    }
                }
                catch (InvocationTargetException e) {
                    throw CVSException.wrapException((Exception)e);
                }
            }
            finally {
                monitor.done();
            }
        }

        @Override
        protected String getJobName() {
            return CVSUIMessages.CommitWizard_0;
        }

        @Override
        protected String getTaskName() {
            return CVSUIMessages.CommitWizard_1;
        }

        protected void setJobChangeListener(IJobChangeListener jobListener) {
            this.jobListener = jobListener;
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            if (this.jobListener != null) {
                this.jobListener.done(event);
            }
        }

        public void scheduled(IJobChangeEvent event) {
            super.scheduled(event);
            if (this.jobListener != null) {
                this.jobListener.scheduled(event);
            }
        }
    }
}

