/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class ProjectClassLoader
extends URLClassLoader {
    private static Map<IJavaProject, ProjectClassLoader> loadersMap = new HashMap<IJavaProject, ProjectClassLoader>();

    ProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        this(JavaCore.create((IProject)project));
    }

    ProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        super(ProjectClassLoader.getProjectClassPath(javaProject), ProjectClassLoader.getParentClassLoader(javaProject));
        loadersMap.put(javaProject, this);
    }

    static synchronized boolean isProjectClassLoaderExisting(IJavaProject javaProject) {
        return loadersMap.containsKey(javaProject);
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        return ProjectClassLoader.getProjectClassLoader(JavaCore.create((IProject)project));
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader == null) {
            loader = new ProjectClassLoader(javaProject);
        }
        return loader;
    }

    static synchronized void resetProjectClassLoader(IJavaProject javaProject) {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader != null) {
            try {
                Method closeMethod = loader.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke((Object)loader, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof IOException) {
                    QvtPlugin.error((Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadersMap.remove(javaProject);
        }
    }

    static synchronized void resetAllProjectClassLoaders() {
        for (IJavaProject javaProject : loadersMap.keySet()) {
            ProjectClassLoader.resetProjectClassLoader(javaProject);
        }
    }

    private static List<String> getRequiredPluginLocations(IRuntimeClasspathEntry classPathEntry) throws CoreException {
        List<String> requiredPluginLocations;
        block3: {
            block2: {
                requiredPluginLocations = Collections.emptyList();
                IPath path = classPathEntry.getPath();
                if (path == null || !path.equals((Object)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH)) break block2;
                IRuntimeClasspathEntry[] resolvedEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)classPathEntry, (IJavaProject)classPathEntry.getJavaProject());
                requiredPluginLocations = new ArrayList<String>(resolvedEntries.length);
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolvedEntries;
                int n = resolvedEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray[n2];
                    String location = resolvedEntry.getLocation();
                    requiredPluginLocations.add(location);
                    ++n2;
                }
                break block3;
            }
            if (!(classPathEntry instanceof IRuntimeClasspathEntry2)) break block3;
            IRuntimeClasspathEntry2 compositeEntry = (IRuntimeClasspathEntry2)classPathEntry;
            IRuntimeClasspathEntry[] nestedEntries = compositeEntry.getRuntimeClasspathEntries(false);
            requiredPluginLocations = new ArrayList<String>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = nestedEntries;
            int n = nestedEntries.length;
            int n3 = 0;
            while (n3 < n) {
                IRuntimeClasspathEntry nestedEntry = iRuntimeClasspathEntryArray[n3];
                requiredPluginLocations.addAll(ProjectClassLoader.getRequiredPluginLocations(nestedEntry));
                ++n3;
            }
        }
        return requiredPluginLocations;
    }

    private static List<String> getRequiredPluginLocations(IJavaProject javaProject) throws CoreException {
        IRuntimeClasspathEntry[] entries;
        ArrayList<String> requiredPluginLocations = new ArrayList<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            requiredPluginLocations.addAll(ProjectClassLoader.getRequiredPluginLocations(entry));
            ++n2;
        }
        return requiredPluginLocations;
    }

    private static URL[] getProjectClassPath(IJavaProject javaProject) throws CoreException, MalformedURLException {
        ArrayList<String> classPathEntries = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)));
        List<String> requiredPluginLocations = ProjectClassLoader.getRequiredPluginLocations(javaProject);
        for (String pluginLocation : requiredPluginLocations) {
            URI uri = URIUtil.toURI((String)pluginLocation);
            if (ProjectClassLoader.isWorkspaceLocation(uri)) continue;
            classPathEntries.remove(pluginLocation);
        }
        ArrayList<URL> urlList = new ArrayList<URL>(classPathEntries.size());
        for (String entry : classPathEntries) {
            URL url = new File(entry).toURI().toURL();
            urlList.add(url);
        }
        return urlList.toArray(new URL[0]);
    }

    private static boolean isWorkspaceLocation(URI uri) throws CoreException {
        IContainer[] containers;
        IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            IProject project = container.getProject();
            if (project != null && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            try {
                result = this.findClass(name);
            }
            catch (Throwable e) {
                result = this.getParent().loadClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(result);
        }
        return result;
    }

    private static ClassLoader getParentClassLoader(IJavaProject javaProject) {
        ClassLoader root = ProjectClassLoader.class.getClassLoader();
        IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)javaProject.getProject());
        if (pluginModel == null) {
            return root;
        }
        IPluginImport[] imports = pluginModel.getPluginBase().getImports();
        final ArrayList<IPluginModelBase> importedPlugins = new ArrayList<IPluginModelBase>(imports.length);
        IPluginImport[] iPluginImportArray = imports;
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginImport i = iPluginImportArray[n2];
            IPluginModelBase importedPlugin = PluginRegistry.findModel((String)i.getId());
            if (importedPlugin != null) {
                importedPlugins.add(importedPlugin);
            }
            ++n2;
        }
        if (importedPlugins.isEmpty()) {
            return root;
        }
        return new ClassLoader(){
            private Map<String, Class<?>> loadedClasses = new HashMap();

            @Override
            protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                if (this.loadedClasses.containsKey(name)) {
                    Class<?> result = this.loadedClasses.get(name);
                    if (result == null) {
                        throw new ClassNotFoundException();
                    }
                    return result;
                }
                for (IPluginModelBase importedPlugin : importedPlugins) {
                    String pluginId = importedPlugin.getPluginBase().getId();
                    try {
                        Class result = CommonPlugin.loadClass((String)pluginId, (String)name);
                        if (resolve) {
                            this.resolveClass(result);
                        }
                        this.loadedClasses.put(name, result);
                        return result;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                this.loadedClasses.put(name, null);
                throw new ClassNotFoundException();
            }
        };
    }
}

