/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.refactoring.exclude;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.editing.AddDependencyOperation;
import org.eclipse.m2e.core.ui.internal.editing.AddExclusionOperation;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.eclipse.m2e.core.ui.internal.editing.RemoveDependencyOperation;
import org.eclipse.m2e.core.ui.internal.util.ParentHierarchyEntry;
import org.eclipse.m2e.refactoring.Messages;
import org.eclipse.osgi.util.NLS;

public class ExcludeArtifactRefactoring
extends Refactoring {
    private static final String PLUGIN_ID = "org.eclipse.m2e.refactoring";
    final ArtifactKey[] excludes;
    private ParentHierarchyEntry exclusionPoint;
    private List<ParentHierarchyEntry> hierarchy;
    private List<Change> changes;

    public ExcludeArtifactRefactoring(ArtifactKey[] keys) {
        this.excludes = keys;
    }

    public void setExclusionPoint(ParentHierarchyEntry exclusionPoint) {
        this.exclusionPoint = exclusionPoint;
    }

    public void setHierarchy(List<ParentHierarchyEntry> hierarchy) {
        this.hierarchy = hierarchy;
        this.exclusionPoint = hierarchy != null ? hierarchy.get(0) : null;
    }

    public String getName() {
        StringBuilder sb = new StringBuilder();
        ArtifactKey[] artifactKeyArray = this.excludes;
        int n = this.excludes.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactKey key = artifactKeyArray[n2];
            sb.append(key.toString()).append(',');
            ++n2;
        }
        sb.deleteCharAt(sb.length() - 1);
        return NLS.bind((String)Messages.MavenExcludeWizard_title, (Object)sb.toString());
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return (RefactoringStatus)MavenPlugin.getMaven().execute((context, monitor) -> this.checkFinalConditions0(monitor), pm);
    }

    RefactoringStatus checkFinalConditions0(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.hierarchy == null || this.exclusionPoint == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ExcludeArtifactRefactoring_unableToLocateProject);
        }
        this.changes = new ArrayList<Change>();
        HashSet locatedKeys = new HashSet();
        ArrayList<Status> statuses = new ArrayList<Status>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pm, (int)3);
        ArrayList<Object> exclusionOp = new ArrayList<Object>();
        for (Map.Entry<Dependency, Set<ArtifactKey>> entry : this.getDependencyExcludes(this.exclusionPoint, (IProgressMonitor)monitor.newChild(1)).entrySet()) {
            locatedKeys.addAll(entry.getValue());
            Dependency dependency = entry.getKey();
            if (ExcludeArtifactRefactoring.contains(entry.getValue(), dependency)) {
                exclusionOp.add(new RemoveDependencyOperation(dependency));
                continue;
            }
            for (ArtifactKey key : entry.getValue()) {
                if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, key)) continue;
                exclusionOp.add(new AddExclusionOperation(dependency, key));
            }
        }
        for (ParentHierarchyEntry project : this.getWorkspaceDescendants()) {
            ArrayList<RemoveDependencyOperation> operations = new ArrayList<RemoveDependencyOperation>();
            for (Map.Entry<Dependency, Set<ArtifactKey>> entry : this.getDependencyExcludes(project, (IProgressMonitor)monitor.newChild(1)).entrySet()) {
                locatedKeys.addAll(entry.getValue());
                Dependency dependency = entry.getKey();
                operations.add(new RemoveDependencyOperation(dependency));
                if (ExcludeArtifactRefactoring.contains(entry.getValue(), dependency)) continue;
                if (!this.hasDependency(this.exclusionPoint, dependency)) {
                    exclusionOp.add(new AddDependencyOperation(dependency));
                }
                for (ArtifactKey key : entry.getValue()) {
                    if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, key)) continue;
                    exclusionOp.add(new AddExclusionOperation(dependency, key));
                }
            }
            if (operations.size() <= 0) continue;
            IFile pom = project.getResource();
            this.changes.add((Change)PomHelper.createChange((IFile)pom, (PomEdits.Operation)new PomEdits.CompoundOperation(operations.toArray(new PomEdits.Operation[operations.size()])), (String)this.getName(pom)));
        }
        for (ParentHierarchyEntry project : this.getWorkspaceAncestors()) {
            for (Map.Entry<Dependency, Set<ArtifactKey>> entry : this.getDependencyExcludes(project, (IProgressMonitor)monitor.newChild(1)).entrySet()) {
                locatedKeys.addAll(entry.getValue());
                Dependency dependency = entry.getKey();
                if (ExcludeArtifactRefactoring.contains(entry.getValue(), dependency)) {
                    IFile pom = project.getResource();
                    if (pom == null) continue;
                    statuses.add(new Status(1, PLUGIN_ID, NLS.bind((String)Messages.ExcludeArtifactRefactoring_removeDependencyFrom, (Object)ExcludeArtifactRefactoring.toString(dependency), (Object)pom.getFullPath())));
                    this.changes.add((Change)PomHelper.createChange((IFile)pom, (PomEdits.Operation)new RemoveDependencyOperation(dependency), (String)this.getName(pom)));
                    continue;
                }
                exclusionOp.add(new AddDependencyOperation(dependency));
                for (ArtifactKey key : entry.getValue()) {
                    if (ExcludeArtifactRefactoring.hasExclusion(this.exclusionPoint, dependency, key)) continue;
                    exclusionOp.add(new AddExclusionOperation(dependency, key));
                }
            }
        }
        if (!exclusionOp.isEmpty()) {
            IFile pom = this.exclusionPoint.getResource();
            this.changes.add((Change)PomHelper.createChange((IFile)pom, (PomEdits.Operation)new PomEdits.CompoundOperation(exclusionOp.toArray(new PomEdits.Operation[exclusionOp.size()])), (String)this.getName(pom)));
        }
        if (statuses.size() == 1) {
            return RefactoringStatus.create((IStatus)((IStatus)statuses.get(0)));
        }
        if (statuses.size() > 1) {
            return RefactoringStatus.create((IStatus)new MultiStatus(PLUGIN_ID, 0, statuses.toArray(new IStatus[statuses.size()]), Messages.ExcludeArtifactRefactoring_errorCreatingRefactoring, null));
        }
        if (locatedKeys.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.ExcludeArtifactRefactoring_noTargets);
        }
        if (locatedKeys.size() != this.excludes.length) {
            StringBuilder sb = new StringBuilder();
            ArtifactKey[] artifactKeyArray = this.excludes;
            int n = this.excludes.length;
            int n2 = 0;
            while (n2 < n) {
                ArtifactKey key = artifactKeyArray[n2];
                if (!locatedKeys.contains(key)) {
                    sb.append(key.toString()).append(',');
                }
                ++n2;
            }
            sb.deleteCharAt(sb.length() - 1);
            return RefactoringStatus.createErrorStatus((String)NLS.bind((String)Messages.ExcludeArtifactRefactoring_failedToLocateArtifact, (Object)sb.toString()));
        }
        return new RefactoringStatus();
    }

    private String getName(IFile file) {
        return file.getName() + " - " + file.getProject().getName();
    }

    private Map<Dependency, Set<ArtifactKey>> getDependencyExcludes(ParentHierarchyEntry model, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade facade = model.getFacade();
        MavenProject project = model.getProject();
        DependencyNode root = MavenPlugin.getMavenModelManager().readDependencyTree(facade, project, "test", monitor);
        Visitor visitor = new Visitor(model);
        root.accept((DependencyVisitor)visitor);
        return visitor.getSourceMap();
    }

    public Change createChange(IProgressMonitor pm) throws OperationCanceledException {
        CompositeChange change = new CompositeChange(Messages.ExcludeArtifactRefactoring_changeTitle);
        change.addAll(this.changes.toArray(new Change[this.changes.size()]));
        return change;
    }

    private static boolean matches(Dependency d, ArtifactKey a) {
        return d.getArtifactId().equals(a.getArtifactId()) && d.getGroupId().equals(a.getGroupId());
    }

    private static boolean contains(Set<ArtifactKey> keys, Dependency d) {
        for (ArtifactKey key : keys) {
            if (!ExcludeArtifactRefactoring.matches(d, key)) continue;
            return true;
        }
        return false;
    }

    private Collection<ParentHierarchyEntry> getHierarchy() {
        return this.hierarchy;
    }

    private Collection<ParentHierarchyEntry> getWorkspaceDescendants() {
        ArrayList<ParentHierarchyEntry> descendants = new ArrayList<ParentHierarchyEntry>();
        for (ParentHierarchyEntry project : this.getHierarchy()) {
            if (project == this.exclusionPoint) break;
            if (project.getFacade() == null) continue;
            descendants.add(project);
        }
        return descendants;
    }

    private Collection<ParentHierarchyEntry> getWorkspaceAncestors() {
        ArrayList<ParentHierarchyEntry> ancestors = new ArrayList<ParentHierarchyEntry>();
        boolean add = false;
        for (ParentHierarchyEntry project : this.getHierarchy()) {
            if (project == this.exclusionPoint) {
                add = !add;
                continue;
            }
            if (!add || project.getFacade() == null) continue;
            ancestors.add(project);
        }
        return ancestors;
    }

    private static String toString(Dependency dependency) {
        return NLS.bind((String)"{0}:{1}:{2}", (Object[])new String[]{dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()});
    }

    private boolean hasDependency(ParentHierarchyEntry project, Dependency dependency) {
        List dependencies = project.getProject().getOriginalModel().getDependencies();
        if (dependencies == null) {
            return false;
        }
        for (Dependency dep : dependencies) {
            if (!dep.getArtifactId().equals(dependency.getArtifactId()) || !dep.getGroupId().equals(dependency.getGroupId()) || dep.getVersion() != null && !dep.getVersion().equals(dependency.getVersion())) continue;
            return true;
        }
        return false;
    }

    private static boolean hasExclusion(ParentHierarchyEntry project, Dependency d, ArtifactKey exclusion) {
        List dependencies = project.getProject().getOriginalModel().getDependencies();
        if (dependencies == null) {
            return false;
        }
        Dependency dependency = null;
        for (Dependency dep : dependencies) {
            if (!dep.getArtifactId().equals(d.getArtifactId()) || !dep.getGroupId().equals(d.getGroupId()) || dep.getVersion() != null && !dep.getVersion().equals(d.getVersion())) continue;
            dependency = dep;
            break;
        }
        if (dependency == null || dependency.getExclusions() == null) {
            return false;
        }
        for (Exclusion ex : dependency.getExclusions()) {
            if (!ex.getArtifactId().equals(exclusion.getArtifactId()) || !ex.getGroupId().equals(exclusion.getGroupId())) continue;
            return true;
        }
        return false;
    }

    private class Visitor
    implements DependencyVisitor {
        private final List<Dependency> dependencies;
        private final Map<Dependency, Set<ArtifactKey>> sourceMap = new HashMap<Dependency, Set<ArtifactKey>>();
        private int depth;
        private DependencyNode topLevel;

        Visitor(ParentHierarchyEntry project) {
            this.dependencies = new ArrayList<Dependency>();
            this.dependencies.addAll(project.getProject().getOriginalModel().getDependencies());
        }

        Map<Dependency, Set<ArtifactKey>> getSourceMap() {
            return this.sourceMap;
        }

        public boolean visitLeave(DependencyNode node) {
            --this.depth;
            return true;
        }

        public boolean visitEnter(DependencyNode node) {
            if (this.depth == 1) {
                this.topLevel = node;
            }
            ++this.depth;
            if (node.getDependency() != null) {
                Artifact a = node.getDependency().getArtifact();
                ArtifactKey[] artifactKeyArray = ExcludeArtifactRefactoring.this.excludes;
                int n = ExcludeArtifactRefactoring.this.excludes.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactKey exclude = artifactKeyArray[n2];
                    if (a.getGroupId().equals(exclude.getGroupId()) && a.getArtifactId().equals(exclude.getArtifactId())) {
                        Dependency dependency;
                        if (this.topLevel != null && (dependency = this.findDependency(this.topLevel)) != null) {
                            this.put(dependency, exclude);
                        }
                        return true;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private void put(Dependency dep, ArtifactKey key) {
            Set<ArtifactKey> keys = this.sourceMap.get(dep);
            if (keys == null) {
                keys = new HashSet<ArtifactKey>();
                this.sourceMap.put(dep, keys);
            }
            keys.add(key);
        }

        private Dependency findDependency(String groupId, String artifactId) {
            for (Dependency d : this.dependencies) {
                if (!d.getGroupId().equals(groupId) || !d.getArtifactId().equals(artifactId)) continue;
                return d;
            }
            return null;
        }

        private Dependency findDependency(DependencyNode node) {
            Artifact artifact = node.getRelocations().isEmpty() ? node.getDependency().getArtifact() : (Artifact)node.getRelocations().get(0);
            return this.findDependency(artifact.getGroupId(), artifact.getArtifactId());
        }
    }
}

