/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.sirius.internal;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.compare.diagram.ide.ui.internal.accessor.IDiagramNodeAccessor;
import org.eclipse.emf.compare.diagram.ide.ui.internal.contentmergeviewer.diagram.DiagramContentMergeViewer;
import org.eclipse.emf.compare.diagram.ide.ui.sirius.internal.tools.actions.SiriusComparisonAsImageFileAction;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramDescriptionMappingsRegistry;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Composite;

public class SiriusContentMergeViewer
extends DiagramContentMergeViewer {
    private Set<DiagramMappingsManager> siriusMappingManagers = new LinkedHashSet<DiagramMappingsManager>();
    private Set<DiagramDescriptionMappingsManager> siriusDescriptionMappingManagers = new LinkedHashSet<DiagramDescriptionMappingsManager>();

    public SiriusContentMergeViewer(Composite parent, EMFCompareConfiguration config) {
        super(parent, config);
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        super.updateContent(ancestor, left, right);
        this.getSiriusDiagram(ancestor).ifPresent(this::storeManagers);
        this.getSiriusDiagram(left).ifPresent(this::storeManagers);
        this.getSiriusDiagram(right).ifPresent(this::storeManagers);
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        for (DiagramMappingsManager diagramMappingsManager : this.siriusMappingManagers) {
            DiagramMappingsManagerRegistry.INSTANCE.removeDiagramMappingsManagers(diagramMappingsManager);
        }
        for (DiagramDescriptionMappingsManager diagramDescriptionMappingsManager : this.siriusDescriptionMappingManagers) {
            diagramDescriptionMappingsManager.dispose();
        }
        this.siriusMappingManagers.clear();
        this.siriusDescriptionMappingManagers.clear();
    }

    private Optional<DDiagram> getSiriusDiagram(Object accessor) {
        Diagram gmfDiagram;
        if (accessor instanceof IDiagramNodeAccessor && (gmfDiagram = ((IDiagramNodeAccessor)accessor).getOwnedDiagram()) != null) {
            return Optional.ofNullable((DDiagram)gmfDiagram.getElement());
        }
        return Optional.empty();
    }

    private void storeManagers(DDiagram diagram) {
        this.siriusMappingManagers.add(DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(null, diagram));
        this.siriusDescriptionMappingManagers.add(DiagramDescriptionMappingsRegistry.INSTANCE.getDiagramDescriptionMappingsManager(null, diagram.getDescription()));
    }

    protected void createToolItems(ToolBarManager toolBarManager) {
        super.createToolItems(toolBarManager);
        SiriusComparisonAsImageFileAction saveAsImageFileAction = new SiriusComparisonAsImageFileAction(this);
        toolBarManager.insert(0, (IContributionItem)new ActionContributionItem((IAction)saveAsImageFileAction));
    }
}

