/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core.parser.processors.tcl;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.ast.expressions.TclBlockExpression;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;
import org.eclipse.dltk.tcl.core.TclParseUtil;

public class TclNamespaceProcessor
extends AbstractTclCommandProcessor {
    private ASTNode findRealParent(ASTNode node) {
        List<ASTNode> levels = TclParseUtil.findLevelsTo(this.getModuleDeclaration(), node);
        int i = levels.size() - 1;
        while (i >= 0) {
            ASTNode n = levels.get(i);
            if (n instanceof MethodDeclaration || n instanceof TypeDeclaration || n instanceof ModuleDeclaration) {
                return n;
            }
            --i;
        }
        return null;
    }

    @Override
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        Expression nameSpaceArg = statement.getAt(1);
        if (nameSpaceArg == null || !(nameSpaceArg instanceof SimpleReference)) {
            this.report(parser, "Syntax error: a namespace name expected.", (ASTNode)statement, ProblemSeverities.Error);
            if (DLTKCore.DEBUG) {
                System.err.println("tcl: namespace argument is null or not simple reference");
            }
        }
        if (!(nameSpaceArg instanceof SimpleReference)) {
            return null;
        }
        String sNameSpaceArg = ((SimpleReference)nameSpaceArg).getName();
        if (sNameSpaceArg.equals("eval")) {
            Expression nameSpaceName = statement.getAt(2);
            if (!(nameSpaceName instanceof SimpleReference)) {
                return null;
            }
            String sNameSpaceName = ((SimpleReference)nameSpaceName).getName();
            if (nameSpaceName == null || !(nameSpaceName instanceof SimpleReference)) {
                this.report(parser, "Syntax error: namespace name expected", (ASTNode)statement, ProblemSeverities.Error);
                return null;
            }
            int FIRST_ARGUMENT_POSITION = 3;
            if (statement.getCount() < 4) {
                return null;
            }
            int start = statement.getAt(3).sourceStart();
            int end = statement.getAt(statement.getCount() - 1).sourceEnd();
            Block code = new Block(start, end);
            TypeDeclaration type = new TypeDeclaration(sNameSpaceName, nameSpaceName.sourceStart(), nameSpaceName.sourceEnd(), statement.sourceStart(), statement.sourceEnd());
            type.setModifiers(2048);
            ASTNode realParent = this.findRealParent(parent);
            if (realParent instanceof TypeDeclaration) {
                TypeDeclaration t = (TypeDeclaration)realParent;
                type.setEnclosingTypeName(String.valueOf(t.getEnclosingTypeName()) + "$" + t.getName());
            }
            this.addToParent(parent, (ASTNode)type);
            type.setBody(code);
            int i = 3;
            while (i < statement.getCount()) {
                Expression expr = statement.getAt(i);
                if (expr == null) {
                    return null;
                }
                if (expr instanceof Block) {
                    code.getStatements().addAll(((Block)expr).getStatements());
                } else if (expr instanceof TclBlockExpression) {
                    TclBlockExpression block = (TclBlockExpression)expr;
                    String blockContent = block.getBlock();
                    if (blockContent.length() > 2) {
                        blockContent = blockContent.substring(1, blockContent.length() - 1);
                        parser.parse(blockContent, block.sourceStart() + 1 - parser.getStartPos(), (ASTNode)code);
                    }
                } else {
                    code.getStatements().add(expr);
                }
                ++i;
            }
            return type;
        }
        return null;
    }
}

