/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime.annotation;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.AnnotationExpressionValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationValidator;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.types.ITypeInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.validation.IIssueCallback;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Expression;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ListValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.StringValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.ValueReference;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;

public class ConstraintAnnotationValidator
extends PatternAnnotationValidator
implements IPatternAnnotationAdditionalValidator {
    private static final String VALIDATOR_BASE_CODE = "org.eclipse.viatra.query.livevalidation.";
    public static final String SEVERITY_ISSUE_CODE = "org.eclipse.viatra.query.livevalidation.severity";
    public static final String INVALID_SYMMETRIC_PARAMETERS = "org.eclipse.viatra.query.livevalidation.symmetric";
    public static final String INVALID_KEY_PARAMETERS = "org.eclipse.viatra.query.livevalidation.key";
    private static final PatternAnnotationParameter KEY_PARAMETER = new PatternAnnotationParameter("key", "list", "The keys of a constraint represents the pattern parameter objects the constraint violation needs to be attached to. Keys are defined as a list of parameter names (e.g. keys = {param1, param2}", false, true);
    private static final PatternAnnotationParameter MESSAGE_PARAMETER = new PatternAnnotationParameter("message", "string", "The message to display when the constraint violation is found. The message may refer the parameter variables between $ symbols, or their EMF features, such as in $Param1.name$.", false, true);
    private static final PatternAnnotationParameter SEVERITY_PARAMETER = new PatternAnnotationParameter("severity", "string", "Possible values: &quot;error&quot;, &quot;warning&quot; and &quot;info&quot;.", false, true);
    private static final PatternAnnotationParameter EDITOR_PARAMETER = new PatternAnnotationParameter("targetEditorId", "string", "An Eclipse editor ID where the validation framework should register itself to the context menu. Use &quot;*&quot; as a wildcard if the constraint should be used always when validation is started.", true, false);
    private static final PatternAnnotationParameter SYMMETRIC_PARAMETER = new PatternAnnotationParameter("symmetric", "list", "Provide parameter a list, where permutations of the same values register as one match violation. Symmetries are defined as a list of parameter names (e.g. symmetric = {param1, param2}", true, false);
    @Inject
    private AnnotationExpressionValidator expressionValidator;
    @Inject
    private ITypeInferrer typeInferrer;

    public ConstraintAnnotationValidator() {
        super("Constraint", "This annotation is used to mark a pattern for use in the VIATRA Query validation framework.", new PatternAnnotationParameter[]{KEY_PARAMETER, MESSAGE_PARAMETER, SEVERITY_PARAMETER, EDITOR_PARAMETER, SYMMETRIC_PARAMETER});
    }

    public Optional<IPatternAnnotationAdditionalValidator> getAdditionalValidator() {
        return Optional.of(this);
    }

    public void executeAdditionalValidation(Annotation annotation, IIssueCallback validator) {
        Pattern pattern = (Pattern)annotation.eContainer();
        this.validateMessage(annotation, validator, pattern);
        this.validateSeverity(annotation, validator);
        List<Variable> keyList = this.validateKeys(annotation, validator, pattern);
        this.validateSymmetry(annotation, validator, pattern, keyList);
    }

    private void validateSymmetry(Annotation annotation, IIssueCallback validator, Pattern pattern, List<Variable> keyList) {
        Collection symmetricLists = PatternLanguageHelper.getAnnotationParameters((Annotation)annotation, (String)SYMMETRIC_PARAMETER.getName());
        for (ValueReference symmetry : symmetricLists) {
            List<Object> symmetryList = Lists.newArrayList();
            if (symmetry instanceof ListValue) {
                symmetryList = this.computeVariableListFromListValue(validator, pattern, symmetry, INVALID_SYMMETRIC_PARAMETERS);
            }
            ArrayList symmetricParameters = Lists.newArrayList();
            ArrayList symmetricKeys = Lists.newArrayList();
            ArrayList symmetricProperties = Lists.newArrayList();
            for (Variable variable : symmetryList) {
                String variableName = variable.getName();
                symmetricParameters.add(variableName);
                if (keyList.contains(variable)) {
                    symmetricKeys.add(variableName);
                    continue;
                }
                symmetricProperties.add(variableName);
            }
            if (!symmetricKeys.isEmpty() && !symmetricProperties.isEmpty()) {
                validator.error("Symmetric parameters " + ((Object)symmetricParameters).toString() + " contains both key and non-key parameters!", (EObject)symmetry, null, INVALID_SYMMETRIC_PARAMETERS, new String[0]);
            }
            if (symmetricParameters.size() >= 2) continue;
            validator.error("Symmetric parameters must have at least two values!", (EObject)symmetry, null, INVALID_SYMMETRIC_PARAMETERS, new String[0]);
        }
    }

    private List<Variable> validateKeys(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        List<Object> keyList = Lists.newArrayList();
        ValueReference keyRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)KEY_PARAMETER.getName());
        if (keyRef instanceof ListValue) {
            keyList = this.computeVariableListFromListValue(validator, pattern, keyRef, INVALID_KEY_PARAMETERS);
        }
        if (keyList.isEmpty()) {
            validator.error("No key defined!", (EObject)keyRef, null, INVALID_KEY_PARAMETERS, new String[0]);
        } else {
            boolean atLeastOneEClassKey = Iterables.any((Iterable)keyList, key -> this.typeInferrer.getType((Expression)key) instanceof EClassTransitiveInstancesKey);
            if (!atLeastOneEClassKey) {
                validator.warning("At least one key should be EClass to make location possible!", (EObject)keyRef, null, INVALID_KEY_PARAMETERS, new String[0]);
            }
        }
        return keyList;
    }

    private List<Variable> computeVariableListFromListValue(IIssueCallback validator, Pattern pattern, ValueReference listValue, String issueCode) {
        ArrayList variables = Lists.newArrayList();
        Iterable<VariableReference> variableReferenceList = this.transformVariableReferenceList(listValue);
        Iterable<StringValue> stringValueList = this.transformStringList(listValue);
        if (!Iterables.isEmpty(variableReferenceList) && !Iterables.isEmpty(stringValueList)) {
            validator.error("Must not mix string and variable values!", (EObject)listValue, null, issueCode, new String[0]);
        }
        for (StringValue stringValue : stringValueList) {
            Optional parameterByName = PatternLanguageHelper.getParameterByName((Pattern)pattern, (String)stringValue.getValue());
            if (parameterByName.isPresent()) {
                variables.add((Variable)parameterByName.get());
                validator.warning("Deprecated: remove quotes to use variable reference instead!", (EObject)stringValue, null, issueCode, new String[0]);
                continue;
            }
            validator.error(String.valueOf(stringValue.getValue()) + " is not a pattern parameter!", (EObject)stringValue, null, issueCode, new String[0]);
        }
        for (VariableReference variableReference : variableReferenceList) {
            if (variableReference.getVariable() == null) continue;
            variables.add(variableReference.getVariable());
        }
        return variables;
    }

    private Iterable<StringValue> transformStringList(ValueReference listParameter) {
        EList listValues = ((ListValue)listParameter).getValues();
        Iterable keyStringValues = Iterables.filter((Iterable)listValues, StringValue.class);
        return keyStringValues;
    }

    private Iterable<VariableReference> transformVariableReferenceList(ValueReference listParameter) {
        EList listValues = ((ListValue)listParameter).getValues();
        return Iterables.filter((Iterable)listValues, VariableReference.class);
    }

    private void validateSeverity(Annotation annotation, IIssueCallback validator) {
        String value;
        ValueReference severityRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)SEVERITY_PARAMETER.getName());
        if (severityRef instanceof StringValue && !(value = ((StringValue)severityRef).getValue()).equals("error") && !value.equals("warning") && !value.equals("info")) {
            validator.error("Severity must be either 'error','warning' or 'info'.", (EObject)severityRef, null, SEVERITY_ISSUE_CODE, new String[0]);
        }
    }

    private void validateMessage(Annotation annotation, IIssueCallback validator, Pattern pattern) {
        ValueReference messageRef = PatternLanguageHelper.getFirstAnnotationParameter((Annotation)annotation, (String)MESSAGE_PARAMETER.getName());
        if (messageRef instanceof StringValue) {
            String value = ((StringValue)messageRef).getValue();
            this.expressionValidator.validateStringExpression(value, pattern, messageRef, validator);
        }
    }
}

