/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridColumnGroup;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NebulaGridTab
extends ExampleTab {
    private static int COLUMN_COUNT = 5;
    private static int ROOT_ITEM_COUNT = 20;
    private static int SUB_ITEM_COUNT = 10;
    private Grid grid;
    private Image image;
    private boolean headerVisible = true;
    private boolean footerVisible = true;
    private boolean cellSelectionEnabled;

    public NebulaGridTab() {
        super("Nebula Grid");
        this.setDefaultStyle(802);
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("CHECK", 32, true);
        this.createStyleButton("MULTI", 2, true);
        this.createStyleButton("H_SCROLL", 256, true);
        this.createStyleButton("V_SCROLL", 512, true);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createAddRemoveItemButton(parent);
        this.createTopIndexButton(parent);
        this.createShowItemGroup(parent);
        this.createShowColumnGroup(parent);
        this.createTreeColumnButton(parent);
        this.createSetFooterSpanGroup(parent);
        this.createSetColumnSpanGroup(parent);
        this.createShowHeaderButton(parent);
        this.createShowFooterButton(parent);
        this.createAutoHeightButton(parent);
        this.createWordWrapButton(parent);
        this.createHeaderWordWrapButton(parent);
        this.createQueryFocusItem(parent);
        this.createQueryFocusColumn(parent);
        this.createEnableCellSelection(parent);
        this.createSetCellSelection(parent);
        this.createAddCellsToSelection(parent);
        this.createSelectCellsInColumn(parent);
        this.createSelectCellsInColumnGroup(parent);
        this.createDeselectAllCells(parent);
        this.createGetCellsSelection(parent);
        this.createSetColumnOrder(parent);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        this.initializeImages();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.createGrid(parent);
        this.registerControl((Control)this.grid);
    }

    private void initializeImages() {
        if (this.image == null) {
            this.image = this.loadImage("resources/shell.gif");
        }
    }

    private void createGrid(Composite parent) {
        this.grid = new Grid(parent, this.getStyle());
        this.grid.setLayoutData((Object)new GridData(4, 4, true, true, 1, 20));
        this.grid.setHeaderVisible(this.headerVisible);
        this.grid.setFooterVisible(this.footerVisible);
        this.grid.setCellSelectionEnabled(this.cellSelectionEnabled);
        this.addGridListeners();
        this.createGridColumns();
        this.createGridItems();
    }

    private void addGridListeners() {
        this.grid.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                NebulaGridTab.this.log("grid treeExpanded: " + event);
            }

            public void treeCollapsed(TreeEvent event) {
                NebulaGridTab.this.log("grid treeExpanded: " + event);
            }
        });
        this.grid.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NebulaGridTab.this.log("grid widgetSelected: " + event);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                NebulaGridTab.this.log("grid widgetDefaultSelected: " + event);
            }
        });
    }

    private void createGridColumns() {
        GridColumnGroup group = new GridColumnGroup(this.grid, 2);
        group.setText("Column Group");
        group.setImage(this.image);
        group.setHeaderFont(new Font((Device)group.getDisplay(), "Verdana", 16, 1));
        int i = 0;
        while (i < COLUMN_COUNT) {
            GridColumn column = i > 0 && i < 4 ? new GridColumn(group, i == 1 ? 32 : 0) : new GridColumn(this.grid, i == 4 ? 32 : 0);
            column.setData("org.eclipse.rap.rwt.tooltipMarkupEnabled", (Object)Boolean.TRUE);
            column.setText("Column " + i);
            column.setHeaderTooltip("<span style='font-weight:bold'><i>Column " + i + "</i></span>");
            column.setFooterText("Footer " + i);
            column.setWidth(200);
            column.setMoveable(true);
            column.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent event) {
                    NebulaGridTab.this.log("column widgetSelected: " + event);
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                    NebulaGridTab.this.log("column widgetDefaultSelected: " + event);
                }
            });
            switch (i) {
                case 0: {
                    column.setImage(this.image);
                    column.setSort(1024);
                    column.setFooterImage(this.image);
                    break;
                }
                case 1: {
                    column.setWidth(100);
                    column.setAlignment(0x1000000);
                    column.setImage(this.image);
                    column.setHeaderFont(new Font((Device)column.getDisplay(), "Comic Sans MS", 16, 0));
                    column.setFooterFont(new Font((Device)column.getDisplay(), "Segoe Script", 16, 0));
                    column.setSummary(false);
                    break;
                }
                case 2: {
                    column.setMinimumWidth(100);
                    column.setSummary(false);
                    break;
                }
                case 3: {
                    column.setAlignment(131072);
                    column.setDetail(false);
                }
            }
            ++i;
        }
    }

    private void createGridItems() {
        int i = 0;
        while (i < ROOT_ITEM_COUNT) {
            GridItem item = new GridItem(this.grid, 0);
            item.setImage(this.image);
            int gridItemIndex = this.grid.indexOf(item);
            int k = 0;
            while (k < COLUMN_COUNT) {
                if (k != 1) {
                    item.setText(k, "Item (" + gridItemIndex + "." + k + ")");
                }
                ++k;
            }
            if (gridItemIndex % 5 == 0) {
                this.grid.getItem(gridItemIndex).setHeight(2 * this.grid.getItemHeight());
            }
            int j = 0;
            while (j < SUB_ITEM_COUNT) {
                GridItem subitem = new GridItem(item, 0);
                gridItemIndex = this.grid.indexOf(subitem);
                subitem.setImage(2, this.image);
                int k2 = 0;
                while (k2 < COLUMN_COUNT) {
                    if (k2 != 1) {
                        subitem.setText(k2, "Subitem (" + gridItemIndex + "." + k2 + ")");
                    }
                    ++k2;
                }
                if (gridItemIndex % 5 == 0) {
                    this.grid.getItem(gridItemIndex).setHeight(2 * this.grid.getItemHeight());
                }
                ++j;
            }
            ++i;
        }
        this.grid.getItem(0).setExpanded(true);
    }

    private void createAddRemoveItemButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Button addButton = new Button(composite, 8);
        addButton.setLayoutData((Object)new GridData(100, -1));
        addButton.setText("Add item");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int gridItemIndex;
                GridItem selectedItem;
                GridItem gridItem = selectedItem = NebulaGridTab.this.grid.getSelectionCount() > 0 ? NebulaGridTab.this.grid.getSelection()[0] : null;
                if (selectedItem == null) {
                    GridItem item = new GridItem(NebulaGridTab.this.grid, 0);
                    item.setImage(NebulaGridTab.this.image);
                    gridItemIndex = NebulaGridTab.this.grid.indexOf(item);
                    int k = 0;
                    while (k < COLUMN_COUNT) {
                        item.setText(k, "Item (" + gridItemIndex + "." + k + ")");
                        ++k;
                    }
                } else {
                    GridItem item = new GridItem(selectedItem, 0);
                    item.setImage(1, NebulaGridTab.this.image);
                    gridItemIndex = NebulaGridTab.this.grid.indexOf(item);
                    int k = 0;
                    while (k < COLUMN_COUNT) {
                        item.setText(k, "Subitem (" + gridItemIndex + "." + k + ")");
                        ++k;
                    }
                }
                NebulaGridTab.this.updateItemsText(gridItemIndex + 1);
            }
        });
        Button removeButton = new Button(composite, 8);
        removeButton.setLayoutData((Object)new GridData(100, -1));
        removeButton.setText("Remove item");
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GridItem selectedItem;
                GridItem gridItem = selectedItem = NebulaGridTab.this.grid.getSelectionCount() > 0 ? NebulaGridTab.this.grid.getSelection()[0] : null;
                if (selectedItem != null) {
                    int selectedItemIndex = NebulaGridTab.this.grid.indexOf(selectedItem);
                    NebulaGridTab.this.grid.remove(selectedItemIndex);
                    NebulaGridTab.this.updateItemsText(selectedItemIndex);
                }
            }
        });
    }

    private void createTopIndexButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label topIndexLabel = new Label(composite, 0);
        topIndexLabel.setLayoutData((Object)new GridData(100, -1));
        topIndexLabel.setText("Top index");
        final Text topIndexText = new Text(composite, 2048);
        topIndexText.setLayoutData((Object)new GridData(50, -1));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(100, -1));
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int topIndex = -1;
                try {
                    topIndex = Integer.parseInt(topIndexText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                NebulaGridTab.this.grid.setTopIndex(topIndex);
            }
        });
    }

    private void createShowItemGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label showItemLabel = new Label(composite, 0);
        showItemLabel.setLayoutData((Object)new GridData(100, -1));
        showItemLabel.setText("Show item");
        final Text showItemText = new Text(composite, 2048);
        showItemText.setLayoutData((Object)new GridData(50, -1));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(100, -1));
        button.setText("Show");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = -1;
                try {
                    index = Integer.parseInt(showItemText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (index >= 0 && index < NebulaGridTab.this.grid.getItemCount()) {
                    NebulaGridTab.this.grid.showItem(NebulaGridTab.this.grid.getItem(index));
                }
            }
        });
    }

    private void createShowColumnGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label showColumnLabel = new Label(composite, 0);
        showColumnLabel.setLayoutData((Object)new GridData(100, -1));
        showColumnLabel.setText("Show column");
        final Text showColumnText = new Text(composite, 2048);
        showColumnText.setLayoutData((Object)new GridData(50, -1));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(100, -1));
        button.setText("Show");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = -1;
                try {
                    index = Integer.parseInt(showColumnText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (index >= 0 && index < NebulaGridTab.this.grid.getColumnCount()) {
                    NebulaGridTab.this.grid.showColumn(NebulaGridTab.this.grid.getColumn(index));
                }
            }
        });
    }

    private void createTreeColumnButton(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label treeColumnIndexLabel = new Label(composite, 0);
        treeColumnIndexLabel.setLayoutData((Object)new GridData(100, -1));
        treeColumnIndexLabel.setText("Tree column");
        final Text treeColumnIndexText = new Text(composite, 2048);
        treeColumnIndexText.setLayoutData((Object)new GridData(50, -1));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(100, -1));
        button.setText("Change");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int treeColumnIndex = -1;
                try {
                    treeColumnIndex = Integer.parseInt(treeColumnIndexText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (treeColumnIndex >= 0 && treeColumnIndex < NebulaGridTab.this.grid.getColumnCount()) {
                    NebulaGridTab.this.grid.getColumn(treeColumnIndex).setTree(true);
                }
            }
        });
    }

    private void createSetFooterSpanGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        final Text columnText = new Text(composite, 2048);
        columnText.setLayoutData((Object)new GridData(80, -1));
        columnText.setMessage("column");
        final Text spanText = new Text(composite, 2048);
        spanText.setLayoutData((Object)new GridData(80, -1));
        spanText.setMessage("footerSpan");
        Button set = new Button(composite, 8);
        set.setText("Set");
        set.setLayoutData((Object)new GridData(67, -1));
        set.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = -1;
                int span = -1;
                try {
                    index = Integer.parseInt(columnText.getText());
                    span = Integer.parseInt(spanText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                if (index >= 0 && index < NebulaGridTab.this.grid.getColumnCount() && span > 0) {
                    NebulaGridTab.this.grid.getColumn(index).setData("footerSpan", (Object)span);
                }
            }
        });
    }

    private void createSetColumnSpanGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
        label.setText("Column span on selected item");
        final Text columnText = new Text(composite, 2048);
        columnText.setLayoutData((Object)new GridData(80, -1));
        columnText.setMessage("column");
        final Text spanText = new Text(composite, 2048);
        spanText.setLayoutData((Object)new GridData(90, -1));
        spanText.setMessage("columnSpan");
        Button set = new Button(composite, 8);
        set.setText("Set");
        set.setLayoutData((Object)new GridData(67, -1));
        set.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = -1;
                int span = -1;
                try {
                    index = Integer.parseInt(columnText.getText());
                    span = Integer.parseInt(spanText.getText());
                }
                catch (NumberFormatException numberFormatException) {}
                GridItem[] selection = NebulaGridTab.this.grid.getSelection();
                if (selection.length > 0 && index >= 0 && index < NebulaGridTab.this.grid.getColumnCount() && span >= 0) {
                    selection[0].setColumnSpan(index, span);
                }
            }
        });
    }

    private void createShowHeaderButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show header");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NebulaGridTab.this.headerVisible = button.getSelection();
                NebulaGridTab.this.grid.setHeaderVisible(NebulaGridTab.this.headerVisible);
            }
        });
    }

    private void createShowFooterButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Show footer");
        button.setSelection(true);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NebulaGridTab.this.footerVisible = button.getSelection();
                NebulaGridTab.this.grid.setFooterVisible(NebulaGridTab.this.footerVisible);
            }
        });
    }

    private void createAutoHeightButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Item/Header/Footer auto height");
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NebulaGridTab.this.grid.setAutoHeight(button.getSelection());
            }
        });
    }

    private void createWordWrapButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Word wrap cells text");
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GridColumn[] gridColumnArray = NebulaGridTab.this.grid.getColumns();
                int n = gridColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GridColumn column = gridColumnArray[n2];
                    column.setWordWrap(button.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void createHeaderWordWrapButton(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Word wrap headers text");
        button.setSelection(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                GridColumn[] gridColumnArray = NebulaGridTab.this.grid.getColumns();
                int n = gridColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GridColumn column = gridColumnArray[n2];
                    column.setHeaderWordWrap(button.getSelection());
                    ++n2;
                }
                gridColumnArray = NebulaGridTab.this.grid.getColumnGroups();
                n = gridColumnArray.length;
                n2 = 0;
                while (n2 < n) {
                    GridColumn group = gridColumnArray[n2];
                    group.setHeaderWordWrap(button.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void createQueryFocusItem(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Query focusItem");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = NebulaGridTab.this.grid.getShell();
                String msg = "Current focusItem: " + NebulaGridTab.this.grid.getFocusItem();
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
            }
        });
    }

    private void createQueryFocusColumn(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Query focusColumn");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = NebulaGridTab.this.grid.getShell();
                String msg = "Current focusColumn: " + NebulaGridTab.this.grid.getFocusColumn();
                MessageDialog.openInformation((Shell)shell, (String)"Information", (String)msg);
            }
        });
    }

    private void createEnableCellSelection(Composite parent) {
        final Button button = new Button(parent, 32);
        button.setText("Enable cell selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NebulaGridTab.this.cellSelectionEnabled = button.getSelection();
                NebulaGridTab.this.grid.setCellSelectionEnabled(NebulaGridTab.this.cellSelectionEnabled);
            }
        });
    }

    private void createSetCellSelection(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Set cell selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.grid.setCellSelection(new Point[]{new Point(0, 3), new Point(1, 5), new Point(4, 0)});
            }
        });
    }

    private void createAddCellsToSelection(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Add to cell selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.grid.selectCells(new Point[]{new Point(0, 5), new Point(2, 7)});
            }
        });
    }

    private void createSelectCellsInColumn(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select all cells in column 4");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.grid.selectColumn(4);
            }
        });
    }

    private void createSelectCellsInColumnGroup(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Select all cells in column group");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.grid.selectColumnGroup(0);
            }
        });
    }

    private void createDeselectAllCells(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Deselect all cells");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.grid.deselectAllCells();
            }
        });
    }

    private void createGetCellsSelection(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Get cell selection");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NebulaGridTab.this.log("Selected cells: " + Arrays.toString(NebulaGridTab.this.grid.getCellSelection()));
            }
        });
    }

    private void createSetColumnOrder(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("Change column order");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] nArray = new int[5];
                nArray[0] = 4;
                nArray[1] = 2;
                nArray[2] = 1;
                nArray[3] = 3;
                NebulaGridTab.this.grid.setColumnOrder(nArray);
            }
        });
    }

    private void updateItemsText(int startIndex) {
        int index = startIndex;
        while (index < this.grid.getItemCount()) {
            GridItem item = this.grid.getItem(index);
            String text = item.getText();
            text = text.substring(0, text.indexOf("(") + 1);
            int k = 0;
            while (k < COLUMN_COUNT) {
                item.setText(k, String.valueOf(text) + this.grid.indexOf(item) + "." + k + ")");
                ++k;
            }
            ++index;
        }
    }
}

