/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.pde.api.tools.internal.comparator.Messages;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.util.Util;

public class Delta
implements IDelta {
    private static final IDelta[] EMPTY_CHILDREN = new IDelta[0];
    private static final int INITIAL_SIZE = 4;
    public static final int RESTRICTIONS_MASK = 65535;
    public static final int PREVIOUS_RESTRICTIONS_OFFSET = 16;
    private IDelta[] children;
    private String componentID;
    private String[] datas;
    private int deltasCounter;
    private int elementType;
    private int flags;
    private String key;
    private int kind;
    private int oldModifiers;
    private int newModifiers;
    private int restrictions;
    private String typeName;

    private static void print(IDelta delta, PrintWriter writer) {
        writer.print("delta (elementType: ");
        switch (delta.getElementType()) {
            case 7: {
                writer.print("field");
                break;
            }
            case 1: {
                writer.print("annotation type");
                break;
            }
            case 4: {
                writer.print("class type");
                break;
            }
            case 8: {
                writer.print("interface type");
                break;
            }
            case 6: {
                writer.print("enum type");
                break;
            }
            case 2: {
                writer.print("API component type");
                break;
            }
            case 9: {
                writer.print("method");
                break;
            }
            case 5: {
                writer.print("constructor");
                break;
            }
            case 3: {
                writer.print("API baseline");
                break;
            }
        }
        writer.print(", kind : ");
        writer.print(delta.getKind());
        writer.print(", flags : ");
        writer.print(delta.getFlags());
        writer.print(')');
        writer.print('-');
        writer.print(Util.getDetail(delta));
    }

    public Delta() {
    }

    public Delta(String componentID, int elementType, int kind, int flags, int restrictions, int oldModifiers, int newModifiers, String typeName, String key, String data) {
        this(componentID, elementType, kind, flags, restrictions, 0, oldModifiers, newModifiers, typeName, key, new String[]{data});
    }

    public Delta(String componentID, int elementType, int kind, int flags, int restrictions, int previousRestrictions, int oldModifiers, int newModifiers, String typeName, String key, String[] datas) {
        this.componentID = componentID;
        this.elementType = elementType;
        this.kind = kind;
        this.flags = flags;
        this.oldModifiers = oldModifiers;
        this.newModifiers = newModifiers;
        this.typeName = typeName == null ? "" : typeName;
        this.restrictions = (previousRestrictions & 0xFFFF) << 16 | restrictions & 0xFFFF;
        this.key = key;
        this.datas = datas;
    }

    public Delta(String componentID, int elementType, int kind, int flags, String typeName, String key, String data) {
        this(componentID, elementType, kind, flags, 0, 0, 0, typeName, key, data);
    }

    @Override
    public void accept(DeltaVisitor visitor) {
        if (visitor.visit(this) && this.children != null) {
            int i = 0;
            int max = this.deltasCounter;
            while (i < max) {
                IDelta delta = this.children[i];
                delta.accept(visitor);
                ++i;
            }
        }
        visitor.endVisit(this);
    }

    public void add(IDelta delta) {
        int length;
        if (delta == null) {
            return;
        }
        if (this.children == null) {
            this.children = new Delta[4];
            this.deltasCounter = 0;
        }
        if (this.deltasCounter == (length = this.children.length)) {
            this.children = new IDelta[length * 2];
            System.arraycopy(this.children, 0, this.children, 0, length);
        }
        this.children[this.deltasCounter++] = delta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Delta)) {
            return false;
        }
        Delta other = (Delta)obj;
        if (this.elementType != other.elementType) {
            return false;
        }
        if (this.flags != other.flags) {
            return false;
        }
        if (this.kind != other.kind) {
            return false;
        }
        if (this.oldModifiers != other.oldModifiers) {
            return false;
        }
        if (this.newModifiers != other.newModifiers) {
            return false;
        }
        if (this.restrictions != other.restrictions) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.datas == null) {
            if (other.datas != null) {
                return false;
            }
        } else {
            if (other.datas == null) {
                return false;
            }
            if (this.datas.length != other.datas.length) {
                return false;
            }
            int i = 0;
            int max = this.datas.length;
            while (i < max) {
                if (!this.datas[i].equals(other.datas[i])) {
                    return false;
                }
                ++i;
            }
        }
        return !(this.componentID == null ? other.componentID != null : !this.componentID.equals(other.componentID));
    }

    @Override
    public String getComponentVersionId() {
        return this.componentID;
    }

    @Override
    public String getComponentId() {
        if (this.componentID == null) {
            return null;
        }
        int index = this.componentID.indexOf(40);
        return this.componentID.substring(0, index);
    }

    @Override
    public String[] getArguments() {
        if (this.datas == null) {
            return new String[]{this.typeName};
        }
        return this.datas;
    }

    @Override
    public IDelta[] getChildren() {
        if (this.children == null) {
            return EMPTY_CHILDREN;
        }
        int resizeLength = this.deltasCounter;
        if (resizeLength != this.children.length) {
            this.children = new IDelta[resizeLength];
            System.arraycopy(this.children, 0, this.children, 0, resizeLength);
        }
        return this.children;
    }

    @Override
    public int getElementType() {
        return this.elementType;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public int getKind() {
        return this.kind;
    }

    @Override
    public String getMessage() {
        if (DeltaProcessor.isCompatible(this)) {
            return Messages.getCompatibleLocalizedMessage(this);
        }
        int id = ApiProblemFactory.getProblemMessageId(0x10000000, this.elementType, this.kind, this.flags);
        return ApiProblemFactory.getLocalizedMessage(id, this.datas != null ? this.datas : null);
    }

    @Override
    public int getNewModifiers() {
        return this.newModifiers;
    }

    @Override
    public int getOldModifiers() {
        return this.oldModifiers;
    }

    @Override
    public int getCurrentRestrictions() {
        return this.restrictions & 0xFFFF;
    }

    @Override
    public int getPreviousRestrictions() {
        return this.restrictions >>> 16;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.datas == null ? 0 : this.datas.hashCode());
        result = 31 * result + this.elementType;
        result = 31 * result + this.flags;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + this.kind;
        result = 31 * result + this.oldModifiers;
        result = 31 * result + this.newModifiers;
        result = 31 * result + this.restrictions;
        result = 31 * result + (this.componentID == null ? 0 : this.componentID.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.deltasCounter == 0;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        if (this.children == null) {
            Delta.print(this, printWriter);
        } else {
            printWriter.print('[');
            int i = 0;
            int max = this.deltasCounter;
            while (i < max) {
                if (i > 0) {
                    printWriter.println(',');
                }
                printWriter.print(this.children[i]);
                ++i;
            }
            printWriter.print(']');
        }
        return String.valueOf(writer.getBuffer());
    }
}

