/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.platform.base;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.ui.WidgetFactory;
import org.eclipse.jpt.common.ui.internal.swt.widgets.ControlTools;
import org.eclipse.jpt.common.ui.internal.swt.widgets.DisplayTools;
import org.eclipse.jpt.common.ui.jface.ItemTreeStateProviderFactoryProvider;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.JpaPlatformUiProvider;
import org.eclipse.jpt.jpa.ui.MappingResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.ResourceUiDefinition;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.JpaComposite;
import org.eclipse.jpt.jpa.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.jpt.jpa.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.jpa.ui.internal.plugin.JptJpaUiPlugin;
import org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java.JavaMetadataConversionWizard;
import org.eclipse.jpt.jpa.ui.internal.wizards.conversion.java.JavaMetadataConversionWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractJpaPlatformUi
implements JpaPlatformUi {
    private final ItemTreeStateProviderFactoryProvider navigatorFactoryProvider;
    private final JpaPlatformUiProvider platformUiProvider;

    protected AbstractJpaPlatformUi(ItemTreeStateProviderFactoryProvider navigatorFactoryProvider, JpaPlatformUiProvider platformUiProvider) {
        if (navigatorFactoryProvider == null || platformUiProvider == null) {
            throw new NullPointerException();
        }
        this.navigatorFactoryProvider = navigatorFactoryProvider;
        this.platformUiProvider = platformUiProvider;
    }

    @Override
    public ItemTreeStateProviderFactoryProvider getNavigatorFactoryProvider() {
        return this.navigatorFactoryProvider;
    }

    @Override
    public ItemTreeStateProviderFactoryProvider getStructureViewFactoryProvider(JpaFile jpaFile) {
        JptResourceType resourceType = jpaFile.getResourceModel().getResourceType();
        return resourceType == null ? null : this.getStructureViewFactoryProvider(resourceType);
    }

    protected ItemTreeStateProviderFactoryProvider getStructureViewFactoryProvider(JptResourceType resourceType) {
        try {
            return this.getResourceUiDefinition(resourceType).getStructureViewFactoryProvider();
        }
        catch (IllegalArgumentException iae) {
            JptJpaUiPlugin.instance().logError(iae);
            return null;
        }
    }

    @Override
    public JpaDetailsProvider getDetailsProvider(JpaStructureNode structureNode) {
        for (JpaDetailsProvider provider : this.getDetailsProviders(structureNode.getResourceType())) {
            if (structureNode.getStructureType() != provider.getStructureType()) continue;
            return provider;
        }
        return null;
    }

    protected Iterable<JpaDetailsProvider> getDetailsProviders(JptResourceType resourceType) {
        return this.getResourceUiDefinition(resourceType).getDetailsProviders();
    }

    @Override
    public JpaComposite buildTypeMappingComposite(JptResourceType resourceType, String mappingKey, PropertyValueModel<TypeMapping> mappingModel, PropertyValueModel<Boolean> enabledModel, Composite parentComposite, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        return this.getMappingResourceUiDefinition(resourceType).buildTypeMappingComposite(mappingKey, mappingModel, enabledModel, parentComposite, widgetFactory, resourceManager);
    }

    @Override
    public Iterable<MappingUiDefinition> getTypeMappingUiDefinitions(PersistentType persistentType) {
        return IterableTools.filter(this.getTypeMappingUiDefinitions(persistentType.getResourceType()), (Predicate)new MappingUiDefinition.IsEnabledFor((JpaContextModel)persistentType));
    }

    @Override
    public Iterable<MappingUiDefinition> getTypeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getTypeMappingUiDefinitions();
    }

    @Override
    public MappingUiDefinition getTypeMappingUiDefinition(JptResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getTypeMappingUiDefinition(mappingKey);
    }

    @Override
    public DefaultMappingUiDefinition getDefaultTypeMappingUiDefinition(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultTypeMappingUiDefinition();
    }

    @Override
    public JpaComposite buildAttributeMappingComposite(JptResourceType resourceType, String mappingKey, Composite parentComposite, PropertyValueModel<AttributeMapping> mappingModel, PropertyValueModel<Boolean> enabledModel, WidgetFactory widgetFactory, ResourceManager resourceManager) {
        return this.getMappingResourceUiDefinition(resourceType).buildAttributeMappingComposite(mappingKey, mappingModel, enabledModel, parentComposite, widgetFactory, resourceManager);
    }

    @Override
    public Iterable<MappingUiDefinition> getAttributeMappingUiDefinitions(PersistentAttribute persistentAttribute) {
        return IterableTools.filter(this.getAttributeMappingUiDefinitions(persistentAttribute.getResourceType()), (Predicate)new MappingUiDefinition.IsEnabledFor((JpaContextModel)persistentAttribute));
    }

    @Override
    public Iterable<MappingUiDefinition> getAttributeMappingUiDefinitions(JptResourceType resourceType) {
        return this.getMappingResourceUiDefinition(resourceType).getAttributeMappingUiDefinitions();
    }

    @Override
    public MappingUiDefinition getAttributeMappingUiDefinition(JptResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getAttributeMappingUiDefinition(mappingKey);
    }

    @Override
    public DefaultMappingUiDefinition getDefaultAttributeMappingUiDefinition(JptResourceType resourceType, String mappingKey) {
        return this.getMappingResourceUiDefinition(resourceType).getDefaultAttributeMappingUiDefinition(mappingKey);
    }

    protected Iterable<ResourceUiDefinition> getResourceUiDefinitions() {
        return this.platformUiProvider.getResourceUiDefinitions();
    }

    @Override
    public ResourceUiDefinition getResourceUiDefinition(JptResourceType resourceType) {
        for (ResourceUiDefinition definition : this.getResourceUiDefinitions()) {
            if (!definition.providesUi(resourceType)) continue;
            return definition;
        }
        throw new IllegalArgumentException("No resource UI definition for the resource type: " + resourceType);
    }

    protected MappingResourceUiDefinition getMappingResourceUiDefinition(JptResourceType resourceType) {
        ResourceUiDefinition def = this.getResourceUiDefinition(resourceType);
        try {
            return (MappingResourceUiDefinition)def;
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("No mapping resource UI definition for the resource type: " + resourceType, cce);
        }
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    protected void displayMessage(String title, String message) {
        MessageDialog.openInformation((Shell)DisplayTools.getShell(), (String)title, (String)message);
    }

    protected void openInDialog(JavaMetadataConversionWizardPage wizardPage) {
        this.openInDialog((IWizard)new JavaMetadataConversionWizard(wizardPage));
    }

    protected void openInDialog(IWizard wizard) {
        new SizedWizardDialog(wizard).open();
    }

    public class SizedWizardDialog
    extends WizardDialog {
        private final int width;
        private final int height;

        public SizedWizardDialog(IWizard wizard) {
            this(wizard, 520, 460);
        }

        public SizedWizardDialog(IWizard wizard, int width, int height) {
            this(DisplayTools.getShell(), wizard, width, height);
        }

        public SizedWizardDialog(Shell shell, IWizard wizard, int width, int height) {
            super(shell, wizard);
            this.width = width;
            this.height = height;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setSize(this.width, this.height);
            ControlTools.center((Control)shell, (Control)this.getParentShell());
        }
    }
}

