/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public class TutorialUtil {
    public static Collection<Diagram> getDiagrams(IProject p) {
        List<IFile> files = TutorialUtil.getDiagramFiles((IContainer)p);
        ArrayList<Diagram> diagramList = new ArrayList<Diagram>();
        ResourceSetImpl rSet = new ResourceSetImpl();
        for (IFile file : files) {
            Diagram diagram = TutorialUtil.getDiagramFromFile(file, (ResourceSet)rSet);
            if (diagram == null) continue;
            diagramList.add(diagram);
        }
        return diagramList;
    }

    public static void saveToModelFile(EObject obj, Diagram d) throws CoreException, IOException {
        URI uri = d.eResource().getURI();
        uri = uri.trimFragment();
        uri = uri.trimFileExtension();
        uri = uri.appendFileExtension("model");
        ResourceSet rSet = d.eResource().getResourceSet();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource file = workspaceRoot.findMember(uri.toPlatformString(true));
        if (file == null || !file.exists()) {
            Resource createResource = rSet.createResource(uri);
            createResource.save(Collections.emptyMap());
            createResource.setTrackingModification(true);
        }
        Resource resource = rSet.getResource(uri, true);
        resource.getContents().add((Object)obj);
    }

    private static List<IFile> getDiagramFiles(IContainer folder) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] members;
            IResource[] iResourceArray = members = folder.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IContainer) {
                    ret.addAll(TutorialUtil.getDiagramFiles((IContainer)resource));
                } else if (resource instanceof IFile && (file = (IFile)resource).getName().endsWith(".diagram")) {
                    ret.add(file);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private static Diagram getDiagramFromFile(IFile file, ResourceSet resourceSet) {
        URI resourceURI = TutorialUtil.getFileURI(file, resourceSet);
        try {
            Resource resource = resourceSet.getResource(resourceURI, true);
            if (resource != null) {
                EList contents = resource.getContents();
                for (EObject object : contents) {
                    if (!(object instanceof Diagram)) continue;
                    return (Diagram)object;
                }
            }
        }
        catch (WrappedException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static URI getFileURI(IFile file, ResourceSet resourceSet) {
        String pathName = file.getFullPath().toString();
        URI resourceURI = URI.createFileURI((String)pathName);
        resourceURI = resourceSet.getURIConverter().normalize(resourceURI);
        return resourceURI;
    }
}

