/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j.protocol;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientRequest;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class UnlockObjectsRequest
extends CDOClientRequest<CDOSessionProtocol.UnlockObjectsResult> {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, UnlockObjectsRequest.class);
    private int viewID;
    private Collection<CDOID> objectIDs;
    private IRWLockManager.LockType lockType;
    private boolean recursive;

    public UnlockObjectsRequest(CDOClientProtocol protocol, int viewID, Collection<CDOID> objects, IRWLockManager.LockType lockType, boolean recursive) {
        this(protocol, 25, viewID, objects, lockType, recursive);
    }

    protected UnlockObjectsRequest(CDOClientProtocol protocol, short signalID, int viewID, Collection<CDOID> objectIDs, IRWLockManager.LockType lockType, boolean recursive) {
        super(protocol, signalID);
        this.viewID = viewID;
        this.objectIDs = objectIDs;
        this.lockType = lockType;
        this.recursive = recursive;
    }

    @Override
    protected void requesting(CDODataOutput out) throws IOException {
        out.writeXInt(this.viewID);
        out.writeCDOLockType(this.lockType);
        out.writeBoolean(this.recursive);
        if (this.objectIDs == null) {
            if (TRACER.isEnabled()) {
                TRACER.format("Unlocking all objects for view {0}", new Object[]{this.viewID});
            }
            out.writeXInt(-1);
        } else {
            if (TRACER.isEnabled()) {
                TRACER.format("Unlocking of type {0} requested for view {1}", new Object[]{this.lockType == IRWLockManager.LockType.READ ? "read" : "write", this.viewID});
            }
            out.writeXInt(this.objectIDs.size());
            for (CDOID id : this.objectIDs) {
                if (TRACER.isEnabled()) {
                    TRACER.format("Unlocking requested for object {0}", new Object[]{id});
                }
                out.writeCDOID(id);
            }
        }
    }

    @Override
    protected CDOSessionProtocol.UnlockObjectsResult confirming(CDODataInput in) throws IOException {
        long timestamp = in.readXLong();
        int n = in.readXInt();
        CDOLockState[] newLockStates = new CDOLockState[n];
        int i = 0;
        while (i < n) {
            newLockStates[i] = in.readCDOLockState();
            ++i;
        }
        return new CDOSessionProtocol.UnlockObjectsResult(newLockStates, timestamp);
    }
}

