/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.validators.checks;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.tcl.ast.Node;
import org.eclipse.dltk.tcl.ast.Script;
import org.eclipse.dltk.tcl.ast.Substitution;
import org.eclipse.dltk.tcl.ast.TclCommand;
import org.eclipse.dltk.tcl.parser.ITclErrorReporter;
import org.eclipse.dltk.tcl.parser.TclVisitor;
import org.eclipse.dltk.tcl.validators.ITclCheck;

public class UnreachableCodeCheck
implements ITclCheck {
    @Override
    public void checkCommands(List<TclCommand> tclCommands, final ITclErrorReporter reporter, Map<String, String> options, IScriptProject project, ISourceLineTracker sourceLineTracker) {
        this.traverse(tclCommands, new TclVisitor(){
            private boolean check = true;
            private boolean error = false;

            public boolean visit(TclCommand tclCommand) {
                Assert.isNotNull((Object)tclCommand);
                if (!this.check) {
                    return false;
                }
                if (this.error) {
                    reporter.report(8, "Unreachable code", null, tclCommand.getStart(), tclCommand.getEnd(), ITclErrorReporter.WARNING);
                    this.check = false;
                    this.error = false;
                    return false;
                }
                if (tclCommand == null || tclCommand.getDefinition() == null) {
                    return true;
                }
                if ("return".equals(tclCommand.getDefinition().getName())) {
                    this.error = true;
                    return false;
                }
                return true;
            }

            public void endVisit(TclCommand tclCommand) {
                Assert.isNotNull((Object)tclCommand);
                if (tclCommand != null && tclCommand.getDefinition() != null && "return".equals(tclCommand.getDefinition().getName())) {
                    this.error = false;
                }
                this.check = true;
            }
        });
    }

    public <T> void traverse(List<T> nodes, TclVisitor visitor) {
        int i = 0;
        while (i < nodes.size()) {
            TclCommand command;
            int size;
            Node nde = (Node)nodes.get(i);
            if (nde instanceof Script) {
                Script script = (Script)nde;
                if (visitor.visit(script)) {
                    this.traverse((List<T>)script.getCommands(), visitor);
                    size = script.getCommands().size();
                    if (size != 0) {
                        visitor.endVisit((TclCommand)script.getCommands().get(size - 1));
                    }
                }
            } else if (nde instanceof Substitution) {
                Substitution substitution = (Substitution)nde;
                if (visitor.visit(substitution)) {
                    this.traverse((List<T>)substitution.getCommands(), visitor);
                    size = substitution.getCommands().size();
                    if (size != 0) {
                        visitor.endVisit((TclCommand)substitution.getCommands().get(size - 1));
                    }
                }
            } else if (nde instanceof TclCommand && visitor.visit(command = (TclCommand)nde)) {
                this.traverse((List<T>)command.getArguments(), visitor);
            }
            ++i;
        }
    }
}

