/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.popup.series;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.component.Dial;
import org.eclipse.birt.chart.model.type.DialSeries;
import org.eclipse.birt.chart.model.util.ChartElementUtil;
import org.eclipse.birt.chart.model.util.DefaultValueProvider;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.AbstractChartIntSpinner;
import org.eclipse.birt.chart.ui.swt.composites.GridAttributesComposite;
import org.eclipse.birt.chart.ui.swt.composites.IntegerSpinControl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.AbstractPopupSheet;
import org.eclipse.birt.chart.ui.util.ChartUIExtensionUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DialTickSheet
extends AbstractPopupSheet
implements Listener {
    private transient GridAttributesComposite gacMajor = null;
    private transient GridAttributesComposite gacMinor = null;
    private transient Label lblGridCount = null;
    private transient AbstractChartIntSpinner iscGridCount = null;
    private transient DialSeries series;
    private DialSeries defSeries = DefaultValueProvider.defDialSeries();

    public DialTickSheet(String title, ChartWizardContext context, DialSeries series) {
        super(title, context, false);
        this.series = series;
    }

    @Override
    protected Composite getComponent(Composite parent) {
        GridLayout glContent = new GridLayout();
        glContent.numColumns = 2;
        glContent.marginHeight = 7;
        glContent.marginWidth = 7;
        glContent.verticalSpacing = 5;
        Composite cmpContent = new Composite(parent, 0);
        cmpContent.setLayout((Layout)glContent);
        FillLayout flMajor = new FillLayout();
        FillLayout flMinor = new FillLayout();
        Group grpMajor = new Group(cmpContent, 0);
        GridData gdGRPMajor = new GridData(768);
        grpMajor.setLayoutData((Object)gdGRPMajor);
        grpMajor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MajorGrid"));
        grpMajor.setLayout((Layout)flMajor);
        int gridOptionalStyles = this.useFullMode() ? 14 : 8;
        this.gacMajor = new GridAttributesComposite((Composite)grpMajor, 0, gridOptionalStyles, this.getContext(), this.getDialForProcessing().getMajorGrid(), false, this.defSeries.getDial().getMajorGrid());
        this.gacMajor.addListener(this);
        Group grpMinor = new Group(cmpContent, 0);
        GridData gdGRPMinor = new GridData(768);
        grpMinor.setLayoutData((Object)gdGRPMinor);
        grpMinor.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGrid"));
        grpMinor.setLayout((Layout)flMinor);
        this.gacMinor = new GridAttributesComposite((Composite)grpMinor, 0, gridOptionalStyles, this.getContext(), this.getDialForProcessing().getMinorGrid(), false, this.defSeries.getDial().getMinorGrid());
        this.gacMinor.addListener(this);
        if (this.useFullMode()) {
            Composite cmpGridCount = new Composite(cmpContent, 0);
            GridData gdCMPGridCount = new GridData(768);
            gdCMPGridCount.horizontalSpan = 2;
            cmpGridCount.setLayoutData((Object)gdCMPGridCount);
            cmpGridCount.setLayout((Layout)new GridLayout(3, false));
            this.lblGridCount = new Label(cmpGridCount, 0);
            this.lblGridCount.setText(Messages.getString("OrthogonalSeriesDataSheetImpl.Lbl.MinorGridCount"));
            this.iscGridCount = this.getContext().getUIFactory().createChartIntSpinner(cmpGridCount, 0, this.getDialForProcessing().getScale().getMinorGridsPerUnit(), (EObject)this.getDialForProcessing().getScale(), "minorGridsPerUnit", true);
            GridData gdISCGridCount = new GridData(768);
            this.iscGridCount.setLayoutData((Object)gdISCGridCount);
            this.iscGridCount.addListener((Listener)this);
            if (this.iscGridCount instanceof IntegerSpinControl) {
                ((IntegerSpinControl)this.iscGridCount).addScreenreaderAccessbility(this.lblGridCount.getText());
            }
        }
        this.setState(!this.getContext().getUIFactory().isSetInvisible((EObject)this.getDialForProcessing().getMinorGrid().getTickAttributes()));
        return cmpContent;
    }

    protected boolean useFullMode() {
        return true;
    }

    public void handleEvent(Event event) {
        boolean isUnset;
        boolean bl = isUnset = event.detail == ChartUIExtensionUtil.PROPERTY_UNSET;
        if (((Object)((Object)this.gacMajor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMajorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getDialForProcessing().getMajorGrid(), (String)"tickStyle", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 7: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getDialForProcessing().getMajorGrid().getTickAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                }
            }
        } else if (((Object)((Object)this.gacMinor)).equals(event.widget)) {
            switch (event.type) {
                case 6: {
                    this.getDialForProcessing().getMinorGrid().getTickAttributes().setColor((ColorDefinition)event.data);
                    break;
                }
                case 5: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getDialForProcessing().getMinorGrid(), (String)"tickStyle", (Object)event.data, (boolean)isUnset);
                    break;
                }
                case 7: {
                    ChartElementUtil.setEObjectAttribute((EObject)this.getDialForProcessing().getMinorGrid().getTickAttributes(), (String)"visible", (Object)((Boolean)event.data), (boolean)isUnset);
                    this.setState(!this.getContext().getUIFactory().isSetInvisible((EObject)this.getDialForProcessing().getMinorGrid().getTickAttributes()));
                }
            }
        } else if (event.widget.equals(this.iscGridCount)) {
            ChartElementUtil.setEObjectAttribute((EObject)this.getDialForProcessing().getScale(), (String)"minorGridsPerUnit", (Object)this.iscGridCount.getValue(), (event.detail == ChartUIExtensionUtil.PROPERTY_UNSET ? 1 : 0) != 0);
        }
    }

    public Dial getDialForProcessing() {
        return this.series.getDial();
    }

    private void setState(boolean enabled) {
        if (this.useFullMode()) {
            this.lblGridCount.setEnabled(enabled);
            this.iscGridCount.setEnabled(enabled);
            this.iscGridCount.setEnabled(enabled);
        }
    }
}

