/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.string;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.nls.edit.IEditableSupport;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.LocaleUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TableFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

final class StringPropertyKeyDialog
extends ResizableTitleAreaDialog {
    private final IEditableSupport m_editableSupport;
    private final LocaleInfo m_locale;
    private IEditableSource m_selectedSource;
    private String m_selectedKey;
    private ListViewer m_sourcesViewer;
    private TableViewer m_valuesViewer;
    private SearchPattern m_searchPattern;
    private Text m_filterPatternText;
    private Button m_filterKeyButton;
    private Button m_filterValueButton;
    private Button m_filterBothButton;

    public StringPropertyKeyDialog(Shell parentShell, IEditableSupport editableSupport, IEditableSource source, String key, LocaleInfo locale) {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_editableSupport = editableSupport;
        this.m_selectedSource = source;
        this.m_selectedKey = key;
        this.m_locale = locale;
    }

    public IEditableSource getSelectedSource() {
        return this.m_selectedSource;
    }

    public String getSelectedKey() {
        return this.m_selectedKey;
    }

    public void create() {
        super.create();
        this.setTitle(ModelMessages.StringPropertyKeyDialog_title);
        this.setMessage(ModelMessages.StringPropertyKeyDialog_message);
        Button okButton = this.getButton(0);
        if (this.m_selectedKey != null) {
            this.m_valuesViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_selectedKey));
            okButton.setEnabled(true);
        } else {
            okButton.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container);
        this.createSourcesGroup(container);
        this.createValuesGroup(container);
        if (this.m_selectedSource == null) {
            this.m_selectedSource = (IEditableSource)this.m_sourcesViewer.getElementAt(0);
        }
        this.m_sourcesViewer.setSelection((ISelection)new StructuredSelection((Object)this.m_selectedSource));
        return area;
    }

    private void createSourcesGroup(Composite parent) {
        Group sourcesGroup = new Group(parent, 0);
        GridDataFactory.create((Control)sourcesGroup).hintC(105, 5).grabH().fill();
        GridLayoutFactory.create((Composite)sourcesGroup);
        sourcesGroup.setText(ModelMessages.StringPropertyKeyDialog_sourcesGroup);
        this.m_sourcesViewer = new ListViewer((Composite)sourcesGroup, 2048);
        GridDataFactory.create((Control)this.m_sourcesViewer.getList()).grab().fill();
        this.m_sourcesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IEditableSource source = (IEditableSource)element;
                return source.getLongTitle();
            }
        });
        this.m_sourcesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_sourcesViewer.setSorter(new ViewerSorter());
        this.m_sourcesViewer.setInput(this.m_editableSupport.getEditableSources());
        this.m_sourcesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    StringPropertyKeyDialog.this.m_selectedSource = (IEditableSource)selection.getFirstElement();
                    StringPropertyKeyDialog.this.m_valuesViewer.setInput(StringPropertyKeyDialog.this.m_selectedSource.getKeys());
                } else {
                    StringPropertyKeyDialog.this.m_valuesViewer.setInput(null);
                }
                StringPropertyKeyDialog.this.updateOkButton();
            }
        });
    }

    private void createValuesGroup(Composite parent) {
        Group valuesGroup = new Group(parent, 0);
        GridDataFactory.create((Control)valuesGroup).hintC(105, 20).grab().fill();
        GridLayoutFactory.create((Composite)valuesGroup);
        valuesGroup.setText(ModelMessages.StringPropertyKeyDialog_valuesGroup);
        new Label((Composite)valuesGroup, 0).setText(ModelMessages.StringPropertyKeyDialog_valuesFilterLabel);
        this.m_filterPatternText = new Text((Composite)valuesGroup, 2048);
        GridDataFactory.create((Control)this.m_filterPatternText).grabH().fill();
        this.m_filterPatternText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                StringPropertyKeyDialog.this.refreshValuesViewer();
            }
        });
        new Label((Composite)valuesGroup, 0).setText(ModelMessages.StringPropertyKeyDialog_matchedGroup);
        this.m_valuesViewer = new TableViewer((Composite)valuesGroup, 67584);
        GridDataFactory.create((Control)this.m_valuesViewer.getTable()).grab().fill();
        TableFactory tableFactory = TableFactory.modify((TableViewer)this.m_valuesViewer).standard();
        tableFactory.newColumn().widthC(40).text(ModelMessages.StringPropertyKeyDialog_keyColumn);
        tableFactory.newColumn().widthC(57).image(LocaleUtils.getImage(this.m_locale)).text(ModelMessages.StringPropertyKeyDialog_valueColumn);
        this.setValuesFilter();
        this.m_valuesViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_valuesViewer.setLabelProvider((IBaseLabelProvider)new ValuesLabelProvider());
        this.m_valuesViewer.setSorter(new ViewerSorter());
        this.m_valuesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                StringPropertyKeyDialog.this.m_selectedKey = (String)selection.getFirstElement();
                StringPropertyKeyDialog.this.getButton(0).setEnabled(true);
            }
        });
        this.m_valuesViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StringPropertyKeyDialog.this.okPressed();
            }
        });
        Composite optionsComposite = new Composite((Composite)valuesGroup, 0);
        GridDataFactory.create((Control)optionsComposite).fill();
        GridLayoutFactory.create((Composite)optionsComposite).noMargins().columns(4);
        new Label(optionsComposite, 0).setText(ModelMessages.StringPropertyKeyDialog_filterLabel);
        this.m_filterKeyButton = this.createFilterOptionButton(optionsComposite, ModelMessages.StringPropertyKeyDialog_filterKeyButton);
        this.m_filterValueButton = this.createFilterOptionButton(optionsComposite, ModelMessages.StringPropertyKeyDialog_filterValueButton);
        this.m_filterBothButton = this.createFilterOptionButton(optionsComposite, ModelMessages.StringPropertyKeyDialog_filterBothButton);
        if (!(this.m_filterKeyButton.getSelection() || this.m_filterValueButton.getSelection() || this.m_filterBothButton.getSelection())) {
            this.m_filterKeyButton.setSelection(true);
        }
    }

    private Button createFilterOptionButton(Composite parent, final String text) {
        final Button button = new Button(parent, 16);
        button.setText(text);
        button.setSelection(this.getDialogSettings().getBoolean(text));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                StringPropertyKeyDialog.this.getDialogSettings().put(text, button.getSelection());
                StringPropertyKeyDialog.this.refreshValuesViewer();
            }
        });
        return button;
    }

    private void setValuesFilter() {
        this.m_valuesViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (StringPropertyKeyDialog.this.m_searchPattern == null) {
                    return true;
                }
                String key = (String)element;
                String value = StringPropertyKeyDialog.this.m_selectedSource.getValue(StringPropertyKeyDialog.this.m_locale, key);
                if (StringPropertyKeyDialog.this.m_filterKeyButton.getSelection()) {
                    return StringPropertyKeyDialog.this.m_searchPattern.matches(key);
                }
                if (StringPropertyKeyDialog.this.m_filterValueButton.getSelection()) {
                    return StringPropertyKeyDialog.this.m_searchPattern.matches(value);
                }
                if (StringPropertyKeyDialog.this.m_filterBothButton.getSelection()) {
                    return StringPropertyKeyDialog.this.m_searchPattern.matches(key) || StringPropertyKeyDialog.this.m_searchPattern.matches(value);
                }
                return false;
            }
        });
    }

    private void refreshValuesViewer() {
        this.m_searchPattern = new SearchPattern();
        this.m_searchPattern.setPattern("*" + this.m_filterPatternText.getText());
        this.m_valuesViewer.refresh();
        this.updateOkButton();
    }

    private void updateOkButton() {
        ISelection keySelection = this.m_valuesViewer.getSelection();
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(!keySelection.isEmpty());
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ModelMessages.StringPropertyKeyDialog_shellTitle);
    }

    private class ValuesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ValuesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String key = (String)element;
            if (columnIndex == 0) {
                return key;
            }
            return StringPropertyKeyDialog.this.m_selectedSource.getValue(StringPropertyKeyDialog.this.m_locale, key);
        }
    }
}

