/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.text.html.HTML;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.commons.core.HtmlTag;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.commons.net.SslCertificateException;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.trac.core.client.AbstractTracClient;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.client.Messages;
import org.eclipse.mylyn.internal.trac.core.client.TracClientData;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.WebSearchResultParser;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracRepositoryInfo;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.core.util.TracHttpClientTransportFactory;

public class TracWebClient
extends AbstractTracClient {
    private final HttpClient httpClient = this.createHttpClient();
    private boolean authenticated;

    public TracWebClient(AbstractWebLocation location, ITracClient.Version version) {
        super(location, version);
    }

    private synchronized GetMethod connect(String requestUrl, IProgressMonitor monitor) throws TracException {
        monitor = Policy.monitorFor((IProgressMonitor)monitor);
        try {
            Request request = new Request(requestUrl);
            return request.execute(monitor);
        }
        catch (TracException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TracException(e);
        }
    }

    @Override
    public TracTicket getTicket(int id, IProgressMonitor monitor) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/ticket/" + id, monitor);
        try {
            TracTicket ticket = new TracTicket(id);
            try (InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                        HtmlTag tag = (HtmlTag)token.getValue();
                        if (tag.getTagType() == HTML.Tag.TD) {
                            String headers = tag.getAttribute("headers");
                            if ("h_component".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.COMPONENT, this.getText(tokenizer));
                            } else if ("h_milestone".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.MILESTONE, this.getText(tokenizer));
                            } else if ("h_priority".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.PRIORITY, this.getText(tokenizer));
                            } else if ("h_severity".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.SEVERITY, this.getText(tokenizer));
                            } else if ("h_version".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.VERSION, this.getText(tokenizer));
                            } else if ("h_keywords".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.KEYWORDS, this.getText(tokenizer));
                            } else if ("h_cc".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.CC, this.getText(tokenizer));
                            } else if ("h_owner".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.OWNER, this.getText(tokenizer));
                            } else if ("h_reporter".equals(headers)) {
                                ticket.putBuiltinValue(TracTicket.Key.REPORTER, this.getText(tokenizer));
                            }
                        } else if (tag.getTagType() == HTML.Tag.H2 && ("summary".equals(tag.getAttribute("class")) || "summary searchable".equals(tag.getAttribute("class"))) || tag.getTagType() == HTML.Tag.SPAN && "summary".equals(tag.getAttribute("class"))) {
                            ticket.putBuiltinValue(TracTicket.Key.SUMMARY, this.getText(tokenizer));
                        } else if (tag.getTagType() == HTML.Tag.H3 && "status".equals(tag.getAttribute("class"))) {
                            String text = this.getStrongText(tokenizer);
                            if (text.length() > 0) {
                                int i = text.indexOf(" (");
                                if (i != -1) {
                                    ticket.putBuiltinValue(TracTicket.Key.STATUS, text.substring(0, i));
                                    ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, text.substring(i + 2, text.length() - 1));
                                } else {
                                    ticket.putBuiltinValue(TracTicket.Key.STATUS, text);
                                }
                            }
                        } else if (tag.getTagType() == HTML.Tag.SPAN) {
                            String clazz = tag.getAttribute("class");
                            if ("status".equals(clazz)) {
                                String text = this.getText(tokenizer);
                                if (text.startsWith("(") && text.endsWith(")")) {
                                    StringTokenizer t = new StringTokenizer(text.substring(1, text.length() - 1), " :");
                                    if (t.hasMoreTokens()) {
                                        ticket.putBuiltinValue(TracTicket.Key.STATUS, t.nextToken());
                                    }
                                    if (t.hasMoreTokens()) {
                                        ticket.putBuiltinValue(TracTicket.Key.TYPE, t.nextToken());
                                    }
                                    if (t.hasMoreTokens()) {
                                        ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, t.nextToken());
                                    }
                                }
                            } else if ("trac-status".equals(clazz)) {
                                ticket.putBuiltinValue(TracTicket.Key.STATUS, this.getText(tokenizer));
                            } else if ("trac-type".equals(clazz)) {
                                ticket.putBuiltinValue(TracTicket.Key.TYPE, this.getText(tokenizer));
                            } else if ("trac-resolution".equals(clazz)) {
                                String text = this.getText(tokenizer);
                                if (text.startsWith("(") && text.endsWith(")")) {
                                    ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, text.substring(1, text.length() - 1).trim());
                                } else {
                                    ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, text);
                                }
                            }
                        }
                    }
                    token = tokenizer.nextToken();
                }
            }
            if (ticket.isValid() && ticket.getValue(TracTicket.Key.SUMMARY) != null) {
                TracTicket tracTicket = ticket;
                return tracTicket;
            }
            try {
                throw new InvalidTicketException();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    @Override
    public void searchForTicketIds(TracSearch query, List<Integer> result, IProgressMonitor monitor) throws TracException {
        ArrayList<TracTicket> ticketResult = new ArrayList<TracTicket>();
        this.search(query, ticketResult, monitor);
        for (TracTicket tracTicket : ticketResult) {
            result.add(tracTicket.getId());
        }
    }

    @Override
    public void search(TracSearch query, List<TracTicket> result, IProgressMonitor monitor) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/query?format=tab" + query.toUrl(), monitor);
        try {
            try (InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                WebSearchResultParser parser = new WebSearchResultParser();
                parser.parse(reader);
                Map<String, String> constantValues = this.getExactMatchValues(query);
                for (TracTicket ticket : parser.getTickets()) {
                    if (!ticket.isValid()) continue;
                    for (String key : constantValues.keySet()) {
                        ticket.putValue(key, WebSearchResultParser.parseTicketValue(constantValues.get(key)));
                    }
                    result.add(ticket);
                }
            }
            catch (IOException e) {
                throw new TracException(e);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private Map<String, String> getExactMatchValues(TracSearch query) {
        HashMap<String, String> values = new HashMap<String, String>();
        List<TracSearchFilter> filters = query.getFilters();
        for (TracSearchFilter filter : filters) {
            if (filter.getOperator() != TracSearchFilter.CompareOperator.IS || filter.getValues().size() != 1) continue;
            values.put(filter.getFieldName(), filter.getValues().get(0));
        }
        return values;
    }

    @Override
    public TracRepositoryInfo validate(IProgressMonitor monitor) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/", monitor);
        try {
            TracRepositoryInfo tracRepositoryInfo = new TracRepositoryInfo();
            return tracRepositoryInfo;
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    @Override
    public void updateAttributes(IProgressMonitor monitor) throws TracException {
        monitor.beginTask(Messages.TracWebClient_Updating_attributes, -1);
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/query", monitor);
        try {
            try (InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    String text;
                    int i;
                    HtmlTag tag;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SCRIPT && (i = (text = this.getText(tokenizer).trim()).indexOf("var properties=")) != -1 && !this.parseAttributesJSon(text.substring(i))) {
                        this.parseAttributesTokenizer(text.substring(i));
                    }
                    token = tokenizer.nextToken();
                }
                this.addResolutionAndStatus();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private boolean parseAttributesJSon(String text) {
        Map fieldByName;
        int i;
        if (text.startsWith("var properties=")) {
            text = text.substring("var properties=".length());
        }
        if ((i = text.indexOf("};")) != -1) {
            text = text.substring(0, i + 1);
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        TypeToken<Map<String, TracConfigurationField>> type = new TypeToken<Map<String, TracConfigurationField>>(){};
        try {
            fieldByName = (Map)gson.fromJson(text, type.getType());
            if (fieldByName == null) {
                return false;
            }
        }
        catch (JsonSyntaxException e) {
            return false;
        }
        TracConfiguration configuration = new TracConfiguration(this.data);
        for (Map.Entry entry : fieldByName.entrySet()) {
            AttributeFactory factory = configuration.getFactoryByField((String)entry.getKey());
            if (factory == null) continue;
            factory.initialize();
            TracConfigurationField field = (TracConfigurationField)entry.getValue();
            if (field.options != null && field.options.size() > 0) {
                for (String option : field.options) {
                    factory.addAttribute(option);
                }
                continue;
            }
            if (field.optgroups == null || field.optgroups.size() <= 0) continue;
            for (TracConfigurationOptGroup group : field.optgroups) {
                if (group.options == null) continue;
                for (String option : group.options) {
                    factory.addAttribute(option);
                }
            }
        }
        return true;
    }

    private void parseAttributesTokenizer(String text) throws IOException {
        int tokenType;
        StreamTokenizer t = new StreamTokenizer(new StringReader(text));
        t.quoteChar(34);
        TracConfiguration configuration = new TracConfiguration(this.data);
        AttributeFactory attributeFactory = null;
        String attributeType = null;
        AttributeState state = AttributeState.INIT;
        block9: while ((tokenType = t.nextToken()) != -1) {
            switch (tokenType) {
                case -3: 
                case 34: {
                    if (state == AttributeState.IN_LIST) {
                        attributeFactory = configuration.getFactoryByField(t.sval);
                        if (attributeFactory == null) break;
                        attributeFactory.initialize();
                        break;
                    }
                    if (state == AttributeState.IN_ATTRIBUTE_KEY) {
                        attributeType = t.sval;
                        break;
                    }
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE_LIST || !"options".equals(attributeType) || attributeFactory == null) continue block9;
                    attributeFactory.addAttribute(t.sval);
                    break;
                }
                case 58: {
                    if (state != AttributeState.IN_ATTRIBUTE_KEY) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case 44: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE) break;
                    state = AttributeState.IN_ATTRIBUTE_KEY;
                    break;
                }
                case 91: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE_LIST;
                    break;
                }
                case 93: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE_LIST) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case 123: {
                    if (state == AttributeState.INIT) {
                        state = AttributeState.IN_LIST;
                        break;
                    }
                    if (state == AttributeState.IN_LIST) {
                        state = AttributeState.IN_ATTRIBUTE_KEY;
                        break;
                    }
                    throw new IOException("Error parsing attributes: unexpected token '{'");
                }
                case 125: {
                    if (state == AttributeState.IN_ATTRIBUTE_KEY || state == AttributeState.IN_ATTRIBUTE_VALUE) {
                        state = AttributeState.IN_LIST;
                        break;
                    }
                    if (state == AttributeState.IN_LIST) {
                        state = AttributeState.INIT;
                        break;
                    }
                    throw new IOException("Error parsing attributes: unexpected token '}'");
                }
            }
        }
    }

    public void updateAttributesNewTicketPage(IProgressMonitor monitor) throws TracException {
        monitor.beginTask(Messages.TracWebClient_Updating_attributes, -1);
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/newticket", monitor);
        try {
            try (InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(in, method.getResponseCharSet()));
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    HtmlTag tag;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HTML.Tag.SELECT) {
                        List<String> values;
                        String name = tag.getAttribute("id");
                        if ("component".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.components = new ArrayList<TracComponent>(values.size());
                            for (String value : values) {
                                this.data.components.add(new TracComponent(value));
                            }
                        } else if ("milestone".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.milestones = new ArrayList<TracMilestone>(values.size());
                            for (String value : values) {
                                this.data.milestones.add(new TracMilestone(value));
                            }
                        } else if ("priority".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.priorities = new ArrayList<TracPriority>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.priorities.add(new TracPriority(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("severity".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.severities = new ArrayList<TracSeverity>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.severities.add(new TracSeverity(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("type".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.ticketTypes = new ArrayList<TracTicketType>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.ticketTypes.add(new TracTicketType(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("version".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.versions = new ArrayList<TracVersion>(values.size());
                            for (String value : values) {
                                this.data.versions.add(new TracVersion(value));
                            }
                        }
                    }
                    token = tokenizer.nextToken();
                }
                this.addResolutionAndStatus();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private void addResolutionAndStatus() {
        if (this.data.ticketResolutions == null || this.data.ticketResolutions.isEmpty()) {
            this.data.ticketResolutions = new ArrayList<TracTicketResolution>(5);
            this.data.ticketResolutions.add(new TracTicketResolution("fixed", 1));
            this.data.ticketResolutions.add(new TracTicketResolution("invalid", 2));
            this.data.ticketResolutions.add(new TracTicketResolution("wontfix", 3));
            this.data.ticketResolutions.add(new TracTicketResolution("duplicate", 4));
            this.data.ticketResolutions.add(new TracTicketResolution("worksforme", 5));
        }
        if (this.data.ticketStatus == null || this.data.ticketStatus.isEmpty()) {
            this.data.ticketStatus = new ArrayList<TracTicketStatus>(4);
            this.data.ticketStatus.add(new TracTicketStatus("new", 1));
            this.data.ticketStatus.add(new TracTicketStatus("assigned", 2));
            this.data.ticketStatus.add(new TracTicketStatus("reopened", 3));
            this.data.ticketStatus.add(new TracTicketStatus("closed", 4));
        }
    }

    private List<String> getOptionValues(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        ArrayList<String> values = new ArrayList<String>();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                HtmlTag tag = (HtmlTag)token.getValue();
                if (tag.getTagType() == HTML.Tag.OPTION && !tag.isEndTag()) {
                    String value = this.getText(tokenizer).trim();
                    if (value.length() > 0) {
                        values.add(value);
                    }
                } else {
                    return values;
                }
            }
            token = tokenizer.nextToken();
        }
        return values;
    }

    private String getText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString().trim());
                sb.append(" ");
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT && (token.getType() != HtmlStreamTokenizer.Token.TAG || ((HtmlTag)token.getValue()).getTagType() != HTML.Tag.A)) break;
            token = tokenizer.nextToken();
        }
        return StringEscapeUtils.unescapeHtml((String)sb.toString().trim());
    }

    private String getStrongText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HTML.Tag.STRONG) {
                return this.getText(tokenizer);
            }
            if (token.getType() != HtmlStreamTokenizer.Token.COMMENT && token.getType() != HtmlStreamTokenizer.Token.TEXT) break;
            token = tokenizer.nextToken();
        }
        return "";
    }

    @Override
    public InputStream getAttachmentData(int id, String filename, IProgressMonitor monitor) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/attachment/ticket/" + id + "/" + filename + "?format=raw", monitor);
        try {
            return method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw new TracException(e);
        }
    }

    @Override
    public void putAttachmentData(int id, String name, String description, InputStream in, IProgressMonitor monitor, boolean replace) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public void deleteAttachment(int ticketId, String filename, IProgressMonitor monitor) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public int createTicket(TracTicket ticket, IProgressMonitor monitor) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public void updateTicket(TracTicket ticket, String comment, IProgressMonitor monitor) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public Set<Integer> getChangedTickets(Date since, IProgressMonitor monitor) throws TracException {
        return null;
    }

    @Override
    public Date getTicketLastChanged(Integer id, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteTicket(int ticketId, IProgressMonitor monitor) throws TracException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<TracComment> getComments(int id, IProgressMonitor monitor) throws TracException {
        throw new UnsupportedOperationException();
    }

    private static interface AttributeFactory {
        public void initialize();

        public void addAttribute(String var1);
    }

    static enum AttributeState {
        INIT,
        IN_LIST,
        IN_ATTRIBUTE_KEY,
        IN_ATTRIBUTE_VALUE,
        IN_ATTRIBUTE_VALUE_LIST;

    }

    private class Request {
        private final String url;
        private HostConfiguration hostConfiguration;

        public Request(String url) {
            this.url = url;
        }

        public GetMethod execute(IProgressMonitor monitor) throws TracLoginException, IOException, TracHttpClientTransportFactory.TracHttpException {
            this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)TracWebClient.this.httpClient, (AbstractWebLocation)TracWebClient.this.location, (IProgressMonitor)monitor);
            int attempt = 0;
            while (attempt < 2) {
                int code;
                AuthenticationCredentials credentials;
                if (!TracWebClient.this.authenticated && TracWebClient.this.credentialsValid(credentials = TracWebClient.this.location.getCredentials(AuthenticationType.REPOSITORY))) {
                    try {
                        this.authenticate(monitor);
                    }
                    catch (TracLoginException e) {
                        this.authenticate(monitor);
                    }
                }
                GetMethod method = new GetMethod(WebUtil.getRequestPath((String)this.url));
                try {
                    code = WebUtil.execute((HttpClient)TracWebClient.this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                }
                catch (IOException e) {
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                    throw e;
                }
                catch (RuntimeException e) {
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                    throw e;
                }
                if (code == 200) {
                    return method;
                }
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                if (code != 401 && code != 403) {
                    throw new TracHttpClientTransportFactory.TracHttpException(code);
                }
                TracWebClient.this.authenticated = false;
                this.authenticate(monitor);
                ++attempt;
            }
            throw new TracLoginException();
        }

        private void authenticate(IProgressMonitor monitor) throws TracLoginException, IOException {
            int code;
            AuthenticationCredentials credentials;
            while (true) {
                if (!TracWebClient.this.credentialsValid(credentials = TracWebClient.this.location.getCredentials(AuthenticationType.REPOSITORY))) {
                    throw new TracLoginException();
                }
                AuthScope authScope = new AuthScope(WebUtil.getHost((String)TracWebClient.this.repositoryUrl), WebUtil.getPort((String)TracWebClient.this.repositoryUrl), null, AuthScope.ANY_SCHEME);
                Credentials httpCredentials = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)TracWebClient.this.repositoryUrl));
                TracWebClient.this.httpClient.getState().setCredentials(authScope, httpCredentials);
                GetMethod method = new GetMethod(WebUtil.getRequestPath((String)(String.valueOf(TracWebClient.this.repositoryUrl) + "/login")));
                method.setFollowRedirects(false);
                try {
                    code = WebUtil.execute((HttpClient)TracWebClient.this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                    if (!this.needsReauthentication(code, monitor)) break;
                    continue;
                }
                catch (SslCertificateException e) {
                    if (this.needsReauthentication(499, monitor)) continue;
                    throw e;
                }
                finally {
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                    continue;
                }
                break;
            }
            if (code == 200) {
                TracWebClient.this.authenticateAccountManager(TracWebClient.this.httpClient, this.hostConfiguration, credentials, monitor);
            }
            TracWebClient.this.validateAuthenticationState(TracWebClient.this.httpClient);
            TracWebClient.this.authenticated = true;
        }

        private boolean needsReauthentication(int code, IProgressMonitor monitor) throws IOException, TracLoginException {
            AuthenticationType authenticationType;
            if (code == 401 || code == 403) {
                authenticationType = AuthenticationType.REPOSITORY;
            } else if (code == 407) {
                authenticationType = AuthenticationType.PROXY;
            } else if (code == 499) {
                authenticationType = AuthenticationType.CERTIFICATE;
            } else {
                return false;
            }
            try {
                TracWebClient.this.location.requestCredentials(authenticationType, null, monitor);
            }
            catch (UnsupportedRequestException e) {
                throw new TracLoginException();
            }
            this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)TracWebClient.this.httpClient, (AbstractWebLocation)TracWebClient.this.location, (IProgressMonitor)monitor);
            return true;
        }
    }

    private static class TracConfiguration {
        private final Map<String, AttributeFactory> factoryByField = new HashMap<String, AttributeFactory>();

        public TracConfiguration(final TracClientData data) {
            AttributeFactory attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.components.add(new TracComponent(value));
                }

                @Override
                public void initialize() {
                    data.components = new ArrayList<TracComponent>();
                }
            };
            this.factoryByField.put("component", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.milestones.add(new TracMilestone(value));
                }

                @Override
                public void initialize() {
                    data.milestones = new ArrayList<TracMilestone>();
                }
            };
            this.factoryByField.put("milestone", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.priorities.add(new TracPriority(value, data.priorities.size() + 1));
                }

                @Override
                public void initialize() {
                    data.priorities = new ArrayList<TracPriority>();
                }
            };
            this.factoryByField.put("priority", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.ticketResolutions.add(new TracTicketResolution(value, data.ticketResolutions.size() + 1));
                }

                @Override
                public void initialize() {
                    data.ticketResolutions = new ArrayList<TracTicketResolution>();
                }
            };
            this.factoryByField.put("resolution", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.severities.add(new TracSeverity(value, data.severities.size() + 1));
                }

                @Override
                public void initialize() {
                    data.severities = new ArrayList<TracSeverity>();
                }
            };
            this.factoryByField.put("severity", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.ticketStatus.add(new TracTicketStatus(value, data.ticketStatus.size() + 1));
                }

                @Override
                public void initialize() {
                    data.ticketStatus = new ArrayList<TracTicketStatus>();
                }
            };
            this.factoryByField.put("status", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.ticketTypes.add(new TracTicketType(value, data.ticketTypes.size() + 1));
                }

                @Override
                public void initialize() {
                    data.ticketTypes = new ArrayList<TracTicketType>();
                }
            };
            this.factoryByField.put("type", attributeFactory);
            attributeFactory = new AttributeFactory(){

                @Override
                public void addAttribute(String value) {
                    data.versions.add(new TracVersion(value));
                }

                @Override
                public void initialize() {
                    data.versions = new ArrayList<TracVersion>();
                }
            };
            this.factoryByField.put("version", attributeFactory);
        }

        public AttributeFactory getFactoryByField(String field) {
            return this.factoryByField.get(field);
        }
    }

    private static class TracConfigurationField {
        String label;
        String type;
        List<String> options;
        List<TracConfigurationOptGroup> optgroups;

        private TracConfigurationField() {
        }
    }

    private static class TracConfigurationOptGroup {
        String label;
        List<String> options;

        private TracConfigurationOptGroup() {
        }
    }
}

