/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.OMEditorBP;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.rename.AbstractRenameTreeItemHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameCategoryHandlerOMEditor
extends AbstractRenameTreeItemHandler {
    public Object executeImpl(ExecutionEvent event) {
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (editor instanceof ObjectMappingMultiPageEditor) {
            this.dialogPopUp((ObjectMappingMultiPageEditor)editor, this.getSelection());
        }
        return null;
    }

    protected void dialogPopUp(final ObjectMappingMultiPageEditor editor, final IStructuredSelection sel) {
        editor.getEditorHelper().doEditorOperation(new IEditorOperation(){

            @Override
            public void run(IPersistentObject workingPo) {
                IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)sel.getFirstElement();
                InputDialog dialog = RenameCategoryHandlerOMEditor.this.createDialog(category, editor.getOmEditorBP());
                dialog.setHelpAvailable(true);
                dialog.create();
                DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogRenameContextId");
                if (dialog.open() == 0 && !category.getName().equals(dialog.getName())) {
                    category.setName(dialog.getName());
                    editor.getEditorHelper().setDirty(true);
                    DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.Renamed, DataEventDispatcher.UpdateState.onlyInEditor);
                }
            }
        });
    }

    private InputDialog createDialog(final IObjectMappingCategoryPO category, final OMEditorBP editorBp) {
        return new InputDialog(this.getActiveShell(), Messages.RenameCategoryActionOMEditorTitle, category.getName(), Messages.RenameCategoryActionOMEditorMessage, Messages.RenameCategoryActionOMEditorLabel, Messages.RenameCategoryActionOMEditorError1, Messages.RenameCategoryActionOMEditorDoubleCatName, "category_big.gif", Messages.RenameCategoryActionOMEditorShell, false){

            @Override
            protected boolean isInputAllowed() {
                return !editorBp.existCategory(category.getParent(), this.getInputFieldText()) || category.getName().equals(this.getInputFieldText());
            }
        };
    }
}

