/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMDirtyVersionException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMReadException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.NodeEditorInput;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;

public class TJEditorDndSupport
extends AbstractEditorDndSupport {
    private TJEditorDndSupport() {
    }

    public static boolean copyPaste(AbstractJBEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget) {
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        ITestJobPO targetNode = dropTarget instanceof ITestJobPO ? (ITestJobPO)dropTarget : (ITestJobPO)dropTarget.getParentNode();
        int position = targetNode.indexOf(dropTarget);
        INodePO last = null;
        Object[] objectArray = selectedElements.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            ++position;
            if (obj instanceof IRefTestSuitePO) {
                last = TJEditorDndSupport.copyPasteTestSuite(targetEditor, (IRefTestSuitePO)obj, targetNode, position, project);
            } else if (obj instanceof ICommentPO) {
                ICommentPO comm = NodeMaker.createCommentPO((String)((ICommentPO)obj).getName());
                TJEditorDndSupport.fillNode((INodePO)obj, (INodePO)comm);
                targetNode.addNode(position, (INodePO)comm);
                last = comm;
            } else {
                return false;
            }
            ++n2;
        }
        TJEditorDndSupport.postDropAction(last, targetEditor);
        return true;
    }

    public static INodePO copyPasteTestSuite(AbstractJBEditor targetEditor, IRefTestSuitePO refTestSuit, ITestJobPO targetNode, int dropPosition, IProjectPO project) {
        IRefTestSuitePO newRefTestSuite = NodeMaker.createRefTestSuitePO((ITestSuitePO)refTestSuit.getTestSuite());
        TJEditorDndSupport.fillRefTestSuit(refTestSuit, newRefTestSuite);
        targetEditor.getEditorHelper().getEditSupport().getParamMapper();
        targetNode.addNode(dropPosition, (INodePO)newRefTestSuite);
        targetEditor.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)newRefTestSuite, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        return newRefTestSuite;
    }

    public static boolean performDrop(TestJobEditor targetEditor, IStructuredSelection toDrop, INodePO dropTarget, int dropPosition) {
        if (targetEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK) {
            return false;
        }
        List selectedElements = toDrop.toList();
        Collections.reverse(selectedElements);
        for (Object objectToDrop : selectedElements) {
            INodePO target;
            ITestSuitePO testSuite;
            if (objectToDrop instanceof ITestSuitePO && dropTarget != (testSuite = (ITestSuitePO)objectToDrop)) {
                try {
                    if (dropTarget instanceof IRefTestSuitePO) {
                        TJEditorDndSupport.dropOnRefTS(testSuite, dropTarget, dropPosition);
                    } else if (dropTarget instanceof ITestJobPO) {
                        TJEditorDndSupport.dropOnTJ(testSuite, dropTarget);
                    }
                }
                catch (PMException e) {
                    NodeEditorInput inp = (NodeEditorInput)targetEditor.getAdapter(NodeEditorInput.class);
                    INodePO inpNode = inp.getNode();
                    PMExceptionHandler.handlePMExceptionForMasterSession(e);
                    if (!(e instanceof PMAlreadyLockedException) || ((PMAlreadyLockedException)e).getLockedObject() == null || ((PMAlreadyLockedException)e).getLockedObject().equals(inpNode) || !targetEditor.isDirty()) {
                        try {
                            targetEditor.reOpenEditor((IPersistentObject)inpNode);
                        }
                        catch (PMException pMException) {
                            PMExceptionHandler.handlePMExceptionForEditor(e, targetEditor);
                        }
                    }
                    return false;
                }
            }
            if (!(objectToDrop instanceof INodePO)) continue;
            INodePO nodeToDrop = (INodePO)objectToDrop;
            if ((nodeToDrop instanceof IRefTestSuitePO || nodeToDrop instanceof ICommentPO) && (target = dropTarget) != nodeToDrop && (target instanceof IRefTestSuitePO || target instanceof ICommentPO)) {
                TJEditorDndSupport.moveNode(nodeToDrop, target, target.getParentNode().indexOf(target));
            }
            TJEditorDndSupport.postDropAction(nodeToDrop, targetEditor);
        }
        return true;
    }

    public static boolean validateCopy(IStructuredSelection toDrop, INodePO dropTarget) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        for (Object next : toDrop) {
            if (next instanceof IRefTestSuitePO || next instanceof ICommentPO) continue;
            return false;
        }
        return true;
    }

    public static boolean validateDrop(Viewer sourceViewer, Viewer targetViewer, IStructuredSelection toDrop, INodePO dropTarget, boolean allowFromBrowser) {
        if (toDrop == null || toDrop.isEmpty() || dropTarget == null) {
            return false;
        }
        if (sourceViewer != null && !sourceViewer.equals(targetViewer)) {
            TestSuiteBrowser tsb = TestSuiteBrowser.getInstance();
            if (tsb != null) {
                if (!allowFromBrowser || !sourceViewer.equals(tsb.getTreeViewer())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        Object[] objectArray = toDrop.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object toDropElement = objectArray[n2];
            if (!(toDropElement instanceof ITestSuitePO || toDropElement instanceof IRefTestSuitePO || toDropElement instanceof ICommentPO)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static void dropOnTJ(ITestSuitePO node, INodePO target) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestSuiteBrowser tsb = TestSuiteBrowser.getInstance();
        if (tsb != null) {
            tsb.addReferencedTestSuite(node, target, 0);
        }
    }

    private static void dropOnRefTS(ITestSuitePO node, INodePO target, int location) throws PMReadException, PMAlreadyLockedException, PMDirtyVersionException, PMException {
        TestSuiteBrowser tsb;
        INodePO parentGUI = target.getParentNode();
        int position = parentGUI.indexOf(target);
        if (location != 1) {
            ++position;
        }
        if ((tsb = TestSuiteBrowser.getInstance()) != null) {
            tsb.addReferencedTestSuite(node, parentGUI, position);
        }
    }
}

