/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.eclipse.build.transformation.chain2job;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.model.pattern.Node;
import org.eclipse.egf.model.pattern.PatternContext;
import org.eclipse.egf.pattern.execution.InternalPatternContext;
import org.eclipse.egf.pattern.execution.OutputManager;
import org.eclipse.egf.portfolio.eclipse.build.GenerationHelper;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Chain;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Job;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.SCM;
import org.eclipse.egf.portfolio.eclipse.build.buildcore.Step;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.BuildscmFactory;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.BuildscmPackage;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.GIT;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVN;
import org.eclipse.egf.portfolio.eclipse.build.buildscm.SVNLocation;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.CLEAN_TYPE;
import org.eclipse.egf.portfolio.eclipse.build.buildstep.CleanStep;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class job {
    protected Job job;
    protected Job newJob;

    public void generate(Object argument) throws Exception {
        InternalPatternContext ctx = (InternalPatternContext)argument;
        Object paramDesc = null;
        Object queryCtx = null;
        Node.Container currentNode = ctx.getNode();
        List jobList = null;
        for (Object jobParameter : jobList) {
            this.job = (Job)jobParameter;
            if (!this.preCondition((PatternContext)ctx)) continue;
            ctx.setNode(new Node.Container(currentNode, this.getClass()));
            this.orchestration((PatternContext)argument);
        }
        if (ctx.useReporter()) {
            ctx.getReporter().executionFinished(OutputManager.computeExecutionOutput((PatternContext)ctx), (PatternContext)ctx);
        }
    }

    public String orchestration(PatternContext ctx) throws Exception {
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        Node.Container currentNode = ictx.getNode();
        this.method_getNewJob(new StringBuffer(), (PatternContext)ictx);
        this.method_movePropertiesToNewJob(new StringBuffer(), (PatternContext)ictx);
        this.method_moveScmToNewJob(new StringBuffer(), (PatternContext)ictx);
        this.method_moveStepsToNewJob(new StringBuffer(), (PatternContext)ictx);
        this.method_moveDeploymentToNewJob(new StringBuffer(), (PatternContext)ictx);
        this.method_removeJobFromChain(new StringBuffer(), (PatternContext)ictx);
        this.method_handleCleanStep(new StringBuffer(), (PatternContext)ictx);
        ictx.setNode(currentNode);
        if (ictx.useReporter()) {
            HashMap<String, Job> parameterValues = new HashMap<String, Job>();
            parameterValues.put("job", this.job);
            String outputWithCallBack = OutputManager.computeLoopOutput((PatternContext)ictx);
            String loop = OutputManager.computeLoopOutputWithoutCallback((PatternContext)ictx);
            ictx.getReporter().loopFinished(loop, outputWithCallBack, (PatternContext)ictx, parameterValues);
        }
        return null;
    }

    protected void method_getNewJob(StringBuffer out, PatternContext ctx) throws Exception {
        this.newJob = (Job)ctx.getValue("newJob");
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "getNewJob", out.toString());
    }

    protected void method_movePropertiesToNewJob(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.job.equals(this.newJob)) {
            return;
        }
        this.newJob.getProperties().addAll(this.job.getProperties());
        this.newJob.getPropertyPackages().addAll(this.job.getPropertyPackages());
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "movePropertiesToNewJob", out.toString());
    }

    protected void method_moveScmToNewJob(StringBuffer out, PatternContext ctx) throws Exception {
        SCM scm;
        SCM newScm;
        if (this.job.equals(this.newJob)) {
            return;
        }
        if (this.job.getScms() != null && this.job.getScms().eClass().equals(BuildscmPackage.eINSTANCE.getSVN())) {
            if (this.newJob.getScms() == null) {
                this.newJob.setScms(BuildscmFactory.eINSTANCE.createSVN());
            }
            newScm = (SVN)this.newJob.getScms();
            scm = (SVN)this.job.getScms();
            for (SVNLocation svnLocation : scm.getLocations()) {
                svnLocation.setLocalPath(String.valueOf(this.job.getName()) + "_" + svnLocation.getLocalPath());
            }
            newScm.getLocations().addAll(scm.getLocations());
        }
        if (this.job.getScms() != null && this.job.getScms().eClass().equals(BuildscmPackage.eINSTANCE.getGIT())) {
            if (this.newJob.getScms() == null) {
                this.newJob.setScms(BuildscmFactory.eINSTANCE.createGIT());
            }
            newScm = (GIT)this.newJob.getScms();
            scm = (GIT)this.job.getScms();
            newScm.setLocations(scm.getLocations());
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "moveScmToNewJob", out.toString());
    }

    protected void method_moveStepsToNewJob(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.job.equals(this.newJob)) {
            return;
        }
        this.newJob.getSteps().addAll(this.job.getSteps());
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "moveStepsToNewJob", out.toString());
    }

    protected void method_moveDeploymentToNewJob(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.job.equals(this.newJob)) {
            return;
        }
        if (this.job.getDeployment() != null) {
            if (this.newJob.getDeployment() != null) {
                throw new IllegalStateException("Cannot merge several deployments into one.");
            }
            this.newJob.setDeployment(this.job.getDeployment());
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "moveDeploymentToNewJob", out.toString());
    }

    protected void method_removeJobFromChain(StringBuffer out, PatternContext ctx) throws Exception {
        if (this.job.equals(this.newJob)) {
            return;
        }
        Chain chain2 = (Chain)this.job.eContainer();
        chain2.getJobs().remove((Object)this.job);
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "removeJobFromChain", out.toString());
    }

    protected void method_handleCleanStep(StringBuffer out, PatternContext ctx) throws Exception {
        boolean firstOne = true;
        for (Step step : new GenerationHelper().getAllSteps(this.newJob)) {
            if (!(step instanceof CleanStep)) continue;
            CleanStep cleanStep = (CleanStep)step;
            if (!firstOne && CLEAN_TYPE.RESULT == cleanStep.getType()) {
                cleanStep.setType(CLEAN_TYPE.WORKSPACE);
            }
            firstOne = false;
        }
        InternalPatternContext ictx = (InternalPatternContext)ctx;
        new Node.DataLeaf(ictx.getNode(), this.getClass(), "handleCleanStep", out.toString());
    }

    public boolean preCondition(PatternContext ctx) throws Exception {
        return this.job.eResource() != null;
    }

    public void set_job(Job job2) {
        this.job = job2;
    }

    public void set_newJob(Job newJob) {
        this.newJob = newJob;
    }

    public Map<String, Object> getParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("job", this.job);
        return parameters;
    }
}

