/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.common.ui.tray;

import java.util.List;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.tray.SelectionBorderFigure;
import org.eclipse.bpel.common.ui.tray.TrayCategoryEntryEditPart;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class TrayCategoryEntryFigure
extends SelectionBorderFigure {
    public static final int BORDER = 3;
    protected Label nameLabel;
    protected IFigure labelPositionReference;
    protected TrayCategoryEntryEditPart part;

    public TrayCategoryEntryFigure(IFigure labelPositionReference, TrayCategoryEntryEditPart part) {
        this.labelPositionReference = labelPositionReference;
        this.part = part;
        this.setLayoutManager((LayoutManager)new EntryLayout());
        this.setBorder((Border)new MarginBorder(3){

            public void paint(IFigure figure, Graphics graphics, Insets in) {
                Rectangle rect = figure.getBounds().getCopy();
                Color color = CommonUIPlugin.getDefault().getColorRegistry().get("light_background");
                graphics.setForegroundColor(color);
                graphics.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
            }
        });
        this.nameLabel = new Label();
        this.nameLabel.setLabelAlignment(1);
        this.add((IFigure)this.nameLabel);
    }

    public void setText(String text) {
        this.nameLabel.setText(text);
    }

    public String getText() {
        return this.nameLabel.getText();
    }

    protected Rectangle getCategoryTitleLabelBounds() {
        return this.labelPositionReference.getBounds();
    }

    public Label getLabel() {
        return this.nameLabel;
    }

    public TrayCategoryEntryEditPart getEditPart() {
        return this.part;
    }

    protected class EntryLayout
    extends AbstractLayout {
        protected EntryLayout() {
        }

        public void layout(IFigure container) {
            List elements = container.getChildren();
            Label text = (Label)elements.get(0);
            Rectangle containerBounds = container.getBounds();
            Rectangle constraint = TrayCategoryEntryFigure.this.getCategoryTitleLabelBounds();
            int width = containerBounds.width - constraint.x;
            text.setBounds(new Rectangle(constraint.x, containerBounds.y, width, containerBounds.height));
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension result = new Dimension();
            result.width = TrayCategoryEntryFigure.this.nameLabel.getMinimumSize((int)wHint, (int)hHint).width;
            result.height = TrayCategoryEntryFigure.this.nameLabel.getPreferredSize((int)wHint, (int)hHint).height;
            result.height += 6;
            return result;
        }
    }
}

