/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.datatypes;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.rio.DatatypeHandler;

public class GeoSPARQLDatatypeHandler
implements DatatypeHandler {
    @Override
    public boolean isRecognizedDatatype(IRI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return datatypeUri.stringValue().startsWith("http://www.opengis.net/ont/geosparql#");
    }

    @Override
    public boolean verifyDatatype(String literalValue, IRI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return true;
        }
        throw new LiteralUtilException("Could not verify DBPedia literal");
    }

    @Override
    public Literal normalizeDatatype(String literalValue, IRI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return valueFactory.createLiteral(literalValue, datatypeUri);
        }
        throw new LiteralUtilException("Could not normalise DBPedia literal");
    }

    @Override
    public String getKey() {
        return "org.eclipse.rdf4j.rio.datatypes.geosparql";
    }
}

