/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents;

import java.util.IdentityHashMap;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.ValidationSettings;
import org.eclipse.rdf4j.sail.shacl.ast.CanProduceValidationReport;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.AbstractConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToPropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TrimToTarget;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.ast.targets.EffectiveTarget;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.wrapper.data.ConnectionsGroup;

abstract class AbstractPairwiseConstraintComponent
extends AbstractConstraintComponent
implements CanProduceValidationReport {
    final Shape shape;
    final IRI predicate;
    boolean producesValidationReport;

    public AbstractPairwiseConstraintComponent(IRI predicate, Shape shape) {
        this.predicate = predicate;
        this.shape = shape;
    }

    abstract IRI getConstraintIri();

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        model.add(subject, this.getConstraintIri(), this.predicate, new Resource[0]);
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        PlanNode allTargetsBasedOnPredicate;
        PlanNode allTargets;
        StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider = new StatementMatcher.StableRandomVariableProvider();
        TargetChain targetChain = this.getTargetChain();
        EffectiveTarget effectiveTarget = targetChain.getEffectiveTarget(scope, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider);
        Optional<Path> path = targetChain.getPath();
        if (overrideTargetNode != null) {
            allTargets = effectiveTarget.extend(overrideTargetNode.getPlanNode(), connectionsGroup, validationSettings.getDataGraph(), scope, EffectiveTarget.Extend.right, false, null);
        } else if (scope == ConstraintComponent.Scope.propertyShape) {
            allTargets = AbstractPairwiseConstraintComponent.getAllTargetsIncludingThoseAddedByPath(connectionsGroup, validationSettings, scope, effectiveTarget, path.get(), true);
            allTargetsBasedOnPredicate = this.getAllTargetsBasedOnPredicate(connectionsGroup, validationSettings, effectiveTarget);
            allTargets = Unique.getInstance(UnionNode.getInstance(connectionsGroup, allTargets, allTargetsBasedOnPredicate), false, connectionsGroup);
        } else {
            allTargets = effectiveTarget.getPlanNode(connectionsGroup, validationSettings.getDataGraph(), scope, false, null);
            allTargetsBasedOnPredicate = this.getAllTargetsBasedOnPredicate(connectionsGroup, validationSettings, effectiveTarget);
            allTargets = Unique.getInstance(UnionNode.getInstance(connectionsGroup, allTargets, allTargetsBasedOnPredicate), false, connectionsGroup);
        }
        StatementMatcher.Variable<String> subject = new StatementMatcher.Variable<String>("a");
        StatementMatcher.Variable<String> object = new StatementMatcher.Variable<String>("c");
        SparqlFragment targetQueryFragment = null;
        if (path.isPresent()) {
            targetQueryFragment = path.get().getTargetQueryFragment(subject, object, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider, Set.of());
        }
        return this.getPairwiseCheck(connectionsGroup, validationSettings, allTargets, subject, object, targetQueryFragment);
    }

    abstract PlanNode getPairwiseCheck(ConnectionsGroup var1, ValidationSettings var2, PlanNode var3, StatementMatcher.Variable<Resource> var4, StatementMatcher.Variable<Value> var5, SparqlFragment var6);

    private PlanNode getAllTargetsBasedOnPredicate(ConnectionsGroup connectionsGroup, ValidationSettings validationSettings, EffectiveTarget effectiveTarget) {
        UnorderedSelect addedByPredicate = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, this.predicate, null, validationSettings.getDataGraph(), (s, d) -> new ValidationTuple(s.getSubject(), ConstraintComponent.Scope.propertyShape, false, (Resource[])d), null);
        UnorderedSelect removedByPredicate = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, this.predicate, null, validationSettings.getDataGraph(), (s, d) -> new ValidationTuple(s.getSubject(), ConstraintComponent.Scope.propertyShape, false, (Resource[])d), null);
        PlanNode targetFilter1 = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), addedByPredicate);
        PlanNode targetFilter2 = effectiveTarget.getTargetFilter(connectionsGroup, validationSettings.getDataGraph(), removedByPredicate);
        return Unique.getInstance(UnionNode.getInstance(connectionsGroup, targetFilter1, targetFilter2), false, connectionsGroup);
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, Resource[] dataGraph, ConstraintComponent.Scope scope, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider, ValidationSettings validationSettings) {
        if (scope == ConstraintComponent.Scope.propertyShape) {
            PlanNode allTargetsPlan = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getPlanNode(connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, true, null);
            allTargetsPlan = new ShiftToPropertyShape(allTargetsPlan, connectionsGroup);
            if (connectionsGroup.getStats().hasRemoved()) {
                PlanNode deletedPredicates = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, this.predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.propertyShape), null);
                deletedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, deletedPredicates);
                deletedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedPredicates, connectionsGroup, dataGraph, ConstraintComponent.Scope.propertyShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(connectionsGroup, allTargetsPlan, deletedPredicates);
            }
            if (connectionsGroup.getStats().hasAdded()) {
                PlanNode addedPredicates = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, this.predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.propertyShape), null);
                addedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, addedPredicates);
                addedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedPredicates, connectionsGroup, dataGraph, ConstraintComponent.Scope.propertyShape, EffectiveTarget.Extend.left, false, null);
                allTargetsPlan = UnionNode.getInstanceDedupe(connectionsGroup, allTargetsPlan, addedPredicates);
            }
            return Unique.getInstance(new TrimToTarget(allTargetsPlan, connectionsGroup), false, connectionsGroup);
        }
        assert (scope == ConstraintComponent.Scope.nodeShape);
        PlanNode allTargetsPlan = EmptyNode.getInstance();
        if (connectionsGroup.getStats().hasRemoved()) {
            PlanNode deletedPredicates = new UnorderedSelect(connectionsGroup.getRemovedStatements(), null, this.predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
            deletedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, deletedPredicates);
            deletedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(deletedPredicates, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(connectionsGroup, allTargetsPlan, deletedPredicates);
        }
        if (connectionsGroup.getStats().hasAdded()) {
            PlanNode addedPredicates = new UnorderedSelect(connectionsGroup.getAddedStatements(), null, this.predicate, null, dataGraph, UnorderedSelect.Mapper.SubjectScopedMapper.getFunction(ConstraintComponent.Scope.nodeShape), null);
            addedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).getTargetFilter(connectionsGroup, dataGraph, addedPredicates);
            addedPredicates = this.getTargetChain().getEffectiveTarget(ConstraintComponent.Scope.nodeShape, connectionsGroup.getRdfsSubClassOfReasoner(), stableRandomVariableProvider).extend(addedPredicates, connectionsGroup, dataGraph, ConstraintComponent.Scope.nodeShape, EffectiveTarget.Extend.left, false, null);
            allTargetsPlan = UnionNode.getInstanceDedupe(connectionsGroup, allTargetsPlan, addedPredicates);
        }
        return Unique.getInstance(new TrimToTarget(allTargetsPlan, connectionsGroup), false, connectionsGroup);
    }

    @Override
    public boolean requiresEvaluation(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, Resource[] dataGraph, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        return super.requiresEvaluation(connectionsGroup, scope, dataGraph, stableRandomVariableProvider) || connectionsGroup.getRemovedStatements().hasStatement(null, this.predicate, null, true, dataGraph) || connectionsGroup.getAddedStatements().hasStatement(null, this.predicate, null, true, dataGraph);
    }

    @Override
    public boolean equals(ConstraintComponent o, IdentityHashMap<Shape, Shape> kvIdentityHashMap) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractPairwiseConstraintComponent that = (AbstractPairwiseConstraintComponent)o;
        return this.predicate.equals(that.predicate);
    }

    @Override
    public int hashCode(IdentityHashMap<Shape, Boolean> identityHashMap) {
        return this.predicate.hashCode() + "AbstractPairwiseConstraintComponent".hashCode();
    }

    @Override
    public void setProducesValidationReport(boolean producesValidationReport) {
        this.producesValidationReport = producesValidationReport;
    }

    @Override
    public boolean producesValidationReport() {
        return this.producesValidationReport;
    }
}

