/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableFloatCollection;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedFloatSet;

public class UnmodifiableFloatSet
extends AbstractUnmodifiableFloatCollection
implements MutableFloatSet {
    private static final long serialVersionUID = 1L;

    public UnmodifiableFloatSet(MutableFloatSet set) {
        super((MutableFloatCollection)set);
    }

    public static UnmodifiableFloatSet of(MutableFloatSet set) {
        if (set == null) {
            throw new IllegalArgumentException("cannot create an UnmodifiableFloatSet for null");
        }
        return new UnmodifiableFloatSet(set);
    }

    private MutableFloatSet getMutableFloatSet() {
        return (MutableFloatSet)this.getFloatCollection();
    }

    @Override
    public UnmodifiableFloatSet with(float element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet without(float element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet withAll(FloatIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet withoutAll(FloatIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public MutableFloatSet select(FloatPredicate predicate) {
        return this.getMutableFloatSet().select(predicate);
    }

    public MutableFloatSet reject(FloatPredicate predicate) {
        return this.getMutableFloatSet().reject(predicate);
    }

    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        return this.getMutableFloatSet().collect(function);
    }

    public boolean equals(Object otherSet) {
        return this.getMutableFloatSet().equals(otherSet);
    }

    public int hashCode() {
        return this.getMutableFloatSet().hashCode();
    }

    public MutableFloatSet asUnmodifiable() {
        return this;
    }

    public MutableFloatSet asSynchronized() {
        return new SynchronizedFloatSet(this);
    }

    public FloatSet freeze() {
        return this.getMutableFloatSet().freeze();
    }

    public ImmutableFloatSet toImmutable() {
        return this.getMutableFloatSet().toImmutable();
    }

    public MutableFloatSet newEmpty() {
        return this.getMutableFloatSet().newEmpty();
    }
}

