/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.exports;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.osgi.framework.Bundle;

public class ExecutionEnvironmentProfileManager {
    private static final IPath PROFILE_PATH = PDECore.getDefault().getStateLocation().append(".profiles");
    private static int fgCustomCount = -1;
    private static final String[] LOCATIONS = new String[]{PROFILE_PATH.toOSString()};

    public static String[] getCustomProfileLocations() {
        ExecutionEnvironmentProfileManager.initialize();
        if (fgCustomCount > 0) {
            return LOCATIONS;
        }
        return null;
    }

    private static synchronized void initialize() {
        if (fgCustomCount == -1) {
            IExecutionEnvironment[] environments;
            File[] files;
            fgCustomCount = 0;
            File dir = PROFILE_PATH.toFile();
            if (!dir.exists()) {
                dir.mkdir();
            }
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
            Bundle bundle = Platform.getBundle((String)"org.eclipse.osgi");
            IExecutionEnvironment[] iExecutionEnvironmentArray = environments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            int n3 = environments.length;
            int n4 = 0;
            while (n4 < n3) {
                Properties properties;
                IExecutionEnvironment env = iExecutionEnvironmentArray[n4];
                String path = env.getId().replace('/', '_') + ".profile";
                URL entry = bundle.getEntry(path);
                if (entry == null && (properties = env.getProfileProperties()) != null) {
                    File profile = new File(dir, path);
                    try {
                        Throwable throwable = null;
                        Object var13_18 = null;
                        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(profile));){
                            ++fgCustomCount;
                            properties.store(stream, null);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        PDECore.log(Status.error((String)NLS.bind((String)PDECoreMessages.ExecutionEnvironmentProfileManager_0, (Object)env.getId()), (Throwable)e));
                    }
                }
                ++n4;
            }
        }
    }
}

