/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.apache.lucene.codecs.lucene101.Lucene101PostingsFormat;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.PriorityQueue;

class ScorerUtil {
    private static final Class<?> DEFAULT_IMPACTS_ENUM_CLASS = Lucene101PostingsFormat.getImpactsEnumImpl();
    private static final Class<?> DEFAULT_ACCEPT_DOCS_CLASS = new FixedBitSet(1).asReadOnlyBits().getClass();

    ScorerUtil() {
    }

    static long costWithMinShouldMatch(LongStream costs, int numScorers, int minShouldMatch) {
        PriorityQueue<Long> pq = new PriorityQueue<Long>(numScorers - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Long a, Long b) {
                return a > b;
            }
        };
        costs.forEach(pq::insertWithOverflow);
        return StreamSupport.stream(pq.spliterator(), false).mapToLong(Number::longValue).sum();
    }

    static DocIdSetIterator likelyImpactsEnum(DocIdSetIterator it) {
        if (it.getClass() != DEFAULT_IMPACTS_ENUM_CLASS && it.getClass() != FilterDocIdSetIterator.class) {
            it = new FilterDocIdSetIterator(it);
        }
        return it;
    }

    static Scorable likelyTermScorer(Scorable scorable) {
        if (scorable.getClass() != TermScorer.class && scorable.getClass() != FilterScorable.class) {
            scorable = new FilterScorable(scorable);
        }
        return scorable;
    }

    static Bits likelyLiveDocs(Bits acceptDocs) {
        if (acceptDocs == null) {
            return acceptDocs;
        }
        if (acceptDocs.getClass() == DEFAULT_ACCEPT_DOCS_CLASS) {
            return acceptDocs;
        }
        return new FilterBits(acceptDocs);
    }

    private static class FilterBits
    implements Bits {
        private final Bits in;

        FilterBits(Bits in) {
            this.in = in;
        }

        @Override
        public boolean get(int index) {
            return this.in.get(index);
        }

        @Override
        public int length() {
            return this.in.length();
        }
    }
}

