/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IResource;
import org.eclipse.jgit.lib.Repository;

public class HistoryPageInput {
    private final List<IResource> list;
    private final List<File> files;
    private final Repository repo;
    private final Object singleFile;
    private final Object singleItem;

    public HistoryPageInput(Repository repository, IResource[] resourceItems) {
        this.repo = repository;
        this.list = Arrays.asList(resourceItems);
        if (resourceItems.length == 1) {
            this.singleItem = resourceItems[0];
            this.singleFile = resourceItems[0].getType() == 1 ? resourceItems[0] : null;
        } else {
            this.singleItem = null;
            this.singleFile = null;
        }
        this.files = null;
    }

    public HistoryPageInput(Repository repository, File[] fileItems) {
        this.repo = repository;
        this.list = null;
        if (fileItems.length == 1 && fileItems[0].isFile() && !this.inGitDir(repository, fileItems[0])) {
            this.singleItem = fileItems[0];
            this.singleFile = fileItems[0];
            this.files = Arrays.asList(fileItems);
        } else {
            this.singleItem = null;
            this.singleFile = null;
            this.files = this.filterFilesInGitDir(repository, fileItems);
        }
    }

    public HistoryPageInput(Repository repository) {
        this.repo = repository;
        this.list = null;
        this.singleFile = null;
        this.singleItem = null;
        this.files = null;
    }

    public Repository getRepository() {
        return this.repo;
    }

    public IResource[] getItems() {
        return this.list == null ? null : this.list.toArray(new IResource[0]);
    }

    public File[] getFileList() {
        return this.files == null ? null : this.files.toArray(new File[0]);
    }

    public Object getSingleFile() {
        return this.singleFile;
    }

    public Object getSingleItem() {
        return this.singleItem;
    }

    public boolean isSingleFile() {
        return this.singleFile != null;
    }

    private boolean inGitDir(Repository repository, File file) {
        return file.getAbsoluteFile().toPath().startsWith(repository.getDirectory().getAbsoluteFile().toPath());
    }

    private List<File> filterFilesInGitDir(Repository repository, File[] fileItems) {
        ArrayList<File> result = new ArrayList<File>(fileItems.length);
        Path gitDirPath = repository.getDirectory().getAbsoluteFile().toPath();
        File[] fileArray = fileItems;
        int n = fileItems.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.getAbsoluteFile().toPath().startsWith(gitDirPath)) {
                result.add(f);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.fieldsEqual((HistoryPageInput)obj);
    }

    public boolean baseEquals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HistoryPageInput)) {
            return false;
        }
        return this.fieldsEqual((HistoryPageInput)obj);
    }

    protected boolean fieldsEqual(HistoryPageInput other) {
        return this.repo == other.repo && Objects.equals(this.singleFile, other.singleFile) && Objects.equals(this.singleItem, other.singleItem) && this.listEquals(this.files, other.files) && this.listEquals(this.list, other.list);
    }

    private <T> boolean listEquals(List<? extends T> a, List<? extends T> b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return Arrays.equals(a.toArray(), b.toArray());
    }

    public int hashCode() {
        int result = Objects.hash(this.repo, this.singleFile, this.singleItem);
        if (this.files != null) {
            result = 31 * result + Arrays.hashCode(this.files.toArray());
        }
        if (this.list != null) {
            result = 31 * result + Arrays.hashCode(this.list.toArray());
        }
        return result;
    }
}

