/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.testrail;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.rcptt.internal.testrail.APIClient;
import org.eclipse.rcptt.internal.testrail.Messages;
import org.eclipse.rcptt.internal.testrail.TestRailPlugin;
import org.eclipse.rcptt.testrail.domain.TestRailTestCase;
import org.eclipse.rcptt.testrail.domain.TestRailTestResult;
import org.eclipse.rcptt.testrail.domain.TestRailTestRun;

public class TestRailAPIClient {
    private static final String ENDPOINT = "index.php?/api/v2";
    private APIClient client;
    private String projectId;

    public TestRailAPIClient(String address, String username, String password, String projectId) {
        String url = address + ENDPOINT;
        this.client = new APIClient(url, username, password);
        this.projectId = projectId.substring(1);
    }

    public void setUseUnicode(boolean useUnicode) {
        this.client.setUseUnicode(useUnicode);
    }

    public boolean isAvailable() {
        String method = MessageFormat.format("/get_cases/{0}", this.projectId);
        String response = this.client.sendGetRequest(method);
        return response != null;
    }

    public String getTestCasesString() {
        String method = MessageFormat.format("/get_cases/{0}", this.projectId);
        String response = this.client.sendGetRequest(method);
        if (response == null) {
            TestRailPlugin.log(Messages.TestRailAPIClient_FailedToGetTestCases);
            return null;
        }
        return response;
    }

    public static JsonArray getTestCasesJsonArray(String response) {
        JsonArray testCases = (JsonArray)new JsonParser().parse(response);
        return testCases;
    }

    public static List<TestRailTestCase> getTestCasesList(String response) {
        TypeToken<List<TestRailTestCase>> token = new TypeToken<List<TestRailTestCase>>(){};
        List testCases = (List)new Gson().fromJson(response, token.getType());
        return testCases;
    }

    public TestRailTestRun addRun(TestRailTestRun testRunDraft) {
        Gson gson;
        String params;
        String method = MessageFormat.format("/add_run/{0}", this.projectId);
        String response = this.client.sendPostRequest(method, params = (gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create()).toJson((Object)testRunDraft).toString());
        if (response == null) {
            TestRailPlugin.log(Messages.TestRailAPIClient_FailedToAddTestRun);
            return null;
        }
        TypeToken<TestRailTestRun> token = new TypeToken<TestRailTestRun>(){};
        TestRailTestRun testRun = (TestRailTestRun)new Gson().fromJson(response, token.getType());
        return testRun;
    }

    public void addResultForTestCase(TestRailTestResult testCaseResult) {
        Gson gson;
        String params;
        String method = MessageFormat.format("/add_result_for_case/{0}/{1}", testCaseResult.getRunId(), testCaseResult.getCaseId());
        String response = this.client.sendPostRequest(method, params = (gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create()).toJson((Object)testCaseResult).toString());
        if (response == null) {
            TestRailPlugin.log(Messages.TestRailAPIClient_FailedToAddTestResult);
        }
    }
}

