/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.text.AbstractEditingModel;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLEditingModel
extends AbstractEditingModel {
    private IStatus status;

    public XMLEditingModel(IDocument document, boolean isReconciling) {
        super(document, isReconciling);
    }

    @Override
    public void load(InputStream source, boolean outOfSync) {
        try {
            this.fLoaded = true;
            this.status = Status.OK_STATUS;
            XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE().parse(source, this.createDocumentHandler(this, true));
        }
        catch (SAXException e) {
            this.fLoaded = false;
            this.status = Status.error((String)e.getMessage(), (Throwable)e);
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException e) {
            this.fLoaded = false;
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    protected abstract DefaultHandler createDocumentHandler(IModel var1, boolean var2);

    @Override
    public void adjustOffsets(IDocument document) {
        try {
            XmlProcessorFactory.createSAXParserWithErrorOnDOCTYPE().parse(this.getInputStream(document), this.createDocumentHandler(this, false));
        }
        catch (IOException | FactoryConfigurationError | ParserConfigurationException | SAXException throwable) {
            // empty catch block
        }
    }

    private boolean isResourceFile() {
        if (this.getUnderlyingResource() == null) {
            return false;
        }
        return this.getUnderlyingResource() instanceof IFile;
    }

    public void save() {
        if (!this.isResourceFile()) {
            return;
        }
        IFile file = (IFile)this.getUnderlyingResource();
        String contents = this.getContents();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));){
                if (file.exists()) {
                    file.setContents((InputStream)stream, false, false, null);
                } else {
                    file.create((InputStream)stream, false, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reload() {
        if (!this.isResourceFile()) {
            return;
        }
        IFile file = (IFile)this.getUnderlyingResource();
        if (file.exists()) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(file.getContents(true));
                this.reload(stream, false);
                this.setDirty(false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void reload(IDocument document) {
        String text = document.get();
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8));
            this.reload(stream, false);
            this.setDirty(false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.setLoaded(true);
        this.save(writer);
        return swriter.toString();
    }

    @Override
    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.getRoot().write("", writer);
        }
        this.setDirty(false);
    }

    @Override
    protected NLResourceHelper createNLResourceHelper() {
        return null;
    }

    protected abstract IWritable getRoot();
}

