/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.rcptt.core.ecl.model.ArgDecl;
import org.eclipse.rcptt.core.ecl.model.BuiltinProcDecl;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.Q7ElementContainer;
import org.eclipse.rcptt.core.ecl.model.VarDecl;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.Completer;
import org.eclipse.rcptt.core.ecl.parser.model.Proposal;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.rcptt.ui.editors.ecl.EclCompletionProposal;
import org.eclipse.rcptt.ui.editors.ecl.EclSourceViewer;
import org.eclipse.swt.graphics.Image;

public class EclContentAssistProcessor
implements IContentAssistProcessor {
    private Image commandImage;
    private Image parameterImage;
    private Image inputParameterImage;
    private Image procImage;
    private Image localImage;
    private Image globalImage;

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        Q7ElementContainer container = ((EclSourceViewer)viewer).getElementContainer();
        container.includeBuildins(true);
        container.setOffset(offset);
        List result = Completer.proposals((Script)container.script, (int)offset, (IDeclContainer)container);
        ArrayList<EclCompletionProposal> toReturn = new ArrayList<EclCompletionProposal>();
        for (Proposal proposal : result) {
            String fullText = proposal.fullText();
            toReturn.add(new EclCompletionProposal(fullText, offset - proposal.prefixLength, proposal.prefixLength, fullText.length(), this.getImage(proposal), fullText, null, proposal.decl.doc()));
        }
        return toReturn.toArray(new ICompletionProposal[toReturn.size()]);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ECLEditorPlugin.getECLScriptContentAssistTriggers().toCharArray();
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private Image getImage(Proposal proposal) {
        if (proposal instanceof Proposal.ArgNameProposal) {
            return ((ArgDecl)proposal.decl).isInput ? this.getInputArgImage() : this.getArgImage();
        }
        if (proposal instanceof Proposal.ProcNameProposal) {
            return proposal.decl instanceof BuiltinProcDecl ? this.getCommandImage() : this.getProcImage();
        }
        if (proposal instanceof Proposal.VarValueProposal) {
            return ((VarDecl)proposal.decl).isGlobal ? this.getGlobalImage() : this.getLocalImage();
        }
        return null;
    }

    private Image getProcImage() {
        if (this.procImage == null) {
            this.procImage = Images.getImage("icons/ecl/proc.gif");
        }
        return this.procImage;
    }

    private Image getLocalImage() {
        if (this.localImage == null) {
            this.localImage = Images.getImage("icons/ecl/local.gif");
        }
        return this.localImage;
    }

    private Image getGlobalImage() {
        if (this.globalImage == null) {
            this.globalImage = Images.getImage("icons/ecl/global.gif");
        }
        return this.globalImage;
    }

    private Image getCommandImage() {
        if (this.commandImage == null) {
            this.commandImage = Images.getImage("icons/ecl/cmd.gif");
        }
        return this.commandImage;
    }

    private Image getArgImage() {
        if (this.parameterImage == null) {
            this.parameterImage = Images.getImage("icons/ecl/attr.gif");
        }
        return this.parameterImage;
    }

    private Image getInputArgImage() {
        if (this.inputParameterImage == null) {
            this.inputParameterImage = Images.getImage("icons/ecl/input_attr.gif");
        }
        return this.inputParameterImage;
    }
}

