/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.internal.filesystem.FileStoreUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;

public interface IFileStore
extends IAdaptable {
    public IFileInfo[] childInfos(int var1, IProgressMonitor var2) throws CoreException;

    public String[] childNames(int var1, IProgressMonitor var2) throws CoreException;

    public IFileStore[] childStores(int var1, IProgressMonitor var2) throws CoreException;

    public void copy(IFileStore var1, int var2, IProgressMonitor var3) throws CoreException;

    public void delete(int var1, IProgressMonitor var2) throws CoreException;

    public IFileInfo fetchInfo();

    public IFileInfo fetchInfo(int var1, IProgressMonitor var2) throws CoreException;

    @Deprecated
    public IFileStore getChild(IPath var1);

    public IFileStore getFileStore(IPath var1);

    public IFileStore getChild(String var1);

    public IFileSystem getFileSystem();

    public String getName();

    public IFileStore getParent();

    public boolean isParentOf(IFileStore var1);

    public IFileStore mkdir(int var1, IProgressMonitor var2) throws CoreException;

    public void move(IFileStore var1, int var2, IProgressMonitor var3) throws CoreException;

    public InputStream openInputStream(int var1, IProgressMonitor var2) throws CoreException;

    default public byte[] readAllBytes(int options, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream stream = this.openInputStream(options, monitor);){
                return stream.readAllBytes();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)("Error reading " + this.getName()), (Throwable)e));
        }
    }

    public OutputStream openOutputStream(int var1, IProgressMonitor var2) throws CoreException;

    default public void write(byte[] content, int options, IProgressMonitor monitor) throws CoreException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (OutputStream out = this.openOutputStream(options, monitor);){
                out.write(content);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    public void putInfo(IFileInfo var1, int var2, IProgressMonitor var3) throws CoreException;

    public File toLocalFile(int var1, IProgressMonitor var2) throws CoreException;

    public String toString();

    public URI toURI();

    default public int compareTo(IFileStore other) {
        if (other == null) {
            return 1;
        }
        return FileStoreUtil.compareFileStore(this, other);
    }
}

