/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.TransportTimeoutException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdi.TimeoutException;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.LaunchingPlugin;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.util.NLS;

public class SocketListenConnectorProcess
implements IProcess {
    private boolean fTerminated = false;
    private final ILaunch fLaunch;
    private final String fPort;
    private int fConnectionLimit;
    private int fAccepted = 0;
    private WaitForConnectionJob fWaitForConnectionJob;
    private long fStartTime;

    public SocketListenConnectorProcess(ILaunch launch, String port, int connectionLimit) {
        this.fLaunch = launch;
        this.fPort = port;
        this.fConnectionLimit = connectionLimit;
    }

    public void waitForConnection(ListeningConnector connector, Map<String, Connector.Argument> arguments) throws CoreException {
        if (this.isTerminated()) {
            throw new CoreException(SocketListenConnectorProcess.getStatus(LaunchingMessages.SocketListenConnectorProcess_0, null, 113));
        }
        this.fStartTime = System.currentTimeMillis();
        this.fAccepted = 0;
        if (!connector.supportsMultipleConnections()) {
            this.fConnectionLimit = 1;
        }
        this.fLaunch.addProcess((IProcess)this);
        this.fWaitForConnectionJob = new WaitForConnectionJob(connector, arguments);
        this.fWaitForConnectionJob.setPriority(20);
        this.fWaitForConnectionJob.setSystem(true);
        this.fWaitForConnectionJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void running(IJobChangeEvent event) {
                SocketListenConnectorProcess.this.fireReadyToAcceptEvent();
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK() && SocketListenConnectorProcess.this.continueListening()) {
                    SocketListenConnectorProcess.this.fWaitForConnectionJob.schedule();
                } else {
                    try {
                        SocketListenConnectorProcess.this.terminate();
                    }
                    catch (DebugException debugException) {
                        // empty catch block
                    }
                }
            }
        });
        this.fWaitForConnectionJob.schedule();
    }

    protected boolean continueListening() {
        return !this.isTerminated() && this.fWaitForConnectionJob != null && !this.fWaitForConnectionJob.fListeningStopped && (this.fConnectionLimit <= 0 || this.fConnectionLimit - this.fAccepted > 0);
    }

    protected static IStatus getStatus(String message, Throwable exception, int code) {
        return new Status(4, LaunchingPlugin.getUniqueIdentifier(), code, message, exception);
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    public String getLabel() {
        return NLS.bind((String)LaunchingMessages.SocketListenConnectorProcess_1, (Object[])new String[]{this.fPort});
    }

    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return !this.fTerminated;
    }

    public boolean isTerminated() {
        return this.fTerminated;
    }

    public void terminate() throws DebugException {
        if (!this.fTerminated) {
            this.fTerminated = true;
            this.fLaunch.removeProcess((IProcess)this);
            if (this.fWaitForConnectionJob != null) {
                this.fWaitForConnectionJob.cancel();
                this.fWaitForConnectionJob.stopListening();
                this.fWaitForConnectionJob = null;
            }
            this.fireTerminateEvent();
        }
    }

    protected void fireTerminateEvent() {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }

    protected void fireReadyToAcceptEvent() {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 32, 1001)});
        }
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public String getAttribute(String key) {
        return null;
    }

    public void setAttribute(String key, String value) {
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    private String getRunningTime() {
        long total = System.currentTimeMillis() - this.fStartTime;
        StringWriter result = new StringWriter();
        PrintWriter writer = new PrintWriter(result);
        int minutes = (int)(total / 60L / 1000L);
        int seconds = (int)(total / 1000L) % 60;
        int milliseconds = (int)(total / 1000L) % 1000;
        writer.printf("%02d:%02d.%03d", minutes, seconds, milliseconds).close();
        return result.toString();
    }

    class WaitForConnectionJob
    extends Job {
        private final ListeningConnector fConnector;
        private final Map<String, Connector.Argument> fArguments;
        private boolean fListeningStopped;

        public WaitForConnectionJob(ListeningConnector connector, Map<String, Connector.Argument> arguments) {
            super(SocketListenConnectorProcess.this.getLabel());
            this.fListeningStopped = false;
            this.fConnector = connector;
            this.fArguments = arguments;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Connector.Argument timeout = this.fArguments.get("timeout");
                if (timeout != null) {
                    timeout.setValue("3000");
                }
                VirtualMachine vm = null;
                while (vm == null && !monitor.isCanceled()) {
                    try {
                        vm = this.fConnector.accept(this.fArguments);
                    }
                    catch (TransportTimeoutException transportTimeoutException) {
                        // empty catch block
                    }
                }
                if (monitor.isCanceled()) {
                    this.fConnector.stopListening(this.fArguments);
                    return Status.CANCEL_STATUS;
                }
                ILaunchConfiguration configuration = SocketListenConnectorProcess.this.fLaunch.getLaunchConfiguration();
                boolean allowTerminate = false;
                if (configuration != null) {
                    try {
                        allowTerminate = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
                    }
                    catch (CoreException e) {
                        LaunchingPlugin.log(e);
                    }
                }
                Connector.Argument portArg = this.fArguments.get("port");
                String vmLabel = this.constructVMLabel(vm, portArg.value(), SocketListenConnectorProcess.this.fLaunch.getLaunchConfiguration());
                IDebugTarget debugTarget = JDIDebugModel.newDebugTarget((ILaunch)SocketListenConnectorProcess.this.fLaunch, (VirtualMachine)vm, (String)vmLabel, null, (boolean)allowTerminate, (boolean)true);
                SocketListenConnectorProcess.this.fLaunch.addDebugTarget(debugTarget);
                ++SocketListenConnectorProcess.this.fAccepted;
                return Status.OK_STATUS;
            }
            catch (IOException e) {
                if (this.fListeningStopped) {
                    return Status.CANCEL_STATUS;
                }
                return SocketListenConnectorProcess.getStatus(LaunchingMessages.SocketListenConnectorProcess_4, e, 113);
            }
            catch (IllegalConnectorArgumentsException e) {
                return SocketListenConnectorProcess.getStatus(LaunchingMessages.SocketListenConnectorProcess_4, e, 113);
            }
        }

        protected void canceling() {
            this.stopListening();
        }

        protected void stopListening() {
            if (!this.fListeningStopped) {
                try {
                    this.fListeningStopped = true;
                    this.fConnector.stopListening(this.fArguments);
                }
                catch (IOException e) {
                    this.done(SocketListenConnectorProcess.getStatus(LaunchingMessages.SocketListenConnectorProcess_5, e, 113));
                }
                catch (IllegalConnectorArgumentsException e) {
                    this.done(SocketListenConnectorProcess.getStatus(LaunchingMessages.SocketListenConnectorProcess_5, e, 113));
                }
            }
        }

        protected String constructVMLabel(VirtualMachine vm, String port, ILaunchConfiguration configuration) {
            String name = null;
            try {
                name = vm.name();
            }
            catch (TimeoutException timeoutException) {
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
            if (name == null) {
                name = configuration == null ? "" : configuration.getName();
            }
            StringBuilder buffer = new StringBuilder(name);
            if (SocketListenConnectorProcess.this.fConnectionLimit != 1) {
                buffer.append('<').append(SocketListenConnectorProcess.this.getRunningTime()).append('>');
            }
            buffer.append('[');
            buffer.append(port);
            buffer.append(']');
            return buffer.toString();
        }
    }
}

