/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TableRenderingPreferencePage
extends PreferencePage
implements IPropertyChangeListener,
SelectionListener {
    private Button fAuto;
    private Button fManual;
    private IntegerFieldEditor fPreBufferSize;
    private IntegerFieldEditor fPostBufferSize;
    private IntegerFieldEditor fPageSize;
    private Group fGroup;
    private Composite fComposite;

    public TableRenderingPreferencePage(String title) {
        super(title);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.debug.ui.table_renderings_preference_page_context");
        this.fComposite = new Composite(parent, 0);
        this.fComposite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, false);
        this.fComposite.setLayoutData((Object)data);
        GridData hspanData = new GridData(4, 4, true, false);
        hspanData.horizontalSpan = 2;
        SWTFactory.createWrapLabel(this.fComposite, DebugUIMessages.TableRenderingPreferencePage_10, 2, 300);
        this.fAuto = new Button(this.fComposite, 16);
        this.fAuto.setText(DebugUIMessages.TableRenderingPreferencePage_0);
        this.fAuto.setLayoutData((Object)hspanData);
        this.fGroup = new Group(this.fComposite, 0);
        this.fGroup.setText(DebugUIMessages.TableRenderingPreferencePage_5);
        GridData groupData = new GridData(4, 4, true, false);
        groupData.horizontalSpan = 2;
        this.fGroup.setLayoutData((Object)groupData);
        this.fPreBufferSize = new IntegerFieldEditor("org.eclispe.debug.ui.memory.preBufferSize", DebugUIMessages.TableRenderingPreferencePage_6, (Composite)this.fGroup);
        this.fPreBufferSize.setPreferenceStore(this.getPreferenceStore());
        this.fPreBufferSize.load();
        this.fPostBufferSize = new IntegerFieldEditor("org.eclispe.debug.ui.memory.postBufferSize", DebugUIMessages.TableRenderingPreferencePage_7, (Composite)this.fGroup);
        this.fPostBufferSize.setPreferenceStore(this.getPreferenceStore());
        this.fPostBufferSize.load();
        this.fManual = new Button(this.fComposite, 16);
        this.fManual.setText(DebugUIMessages.TableRenderingPreferencePage_8);
        this.fManual.setLayoutData((Object)hspanData);
        this.fPageSize = new IntegerFieldEditor("org.eclispe.debug.ui.memory.pageSize", DebugUIMessages.TableRenderingPreferencePage_2, this.fComposite);
        this.fPageSize.setPreferenceStore(this.getPreferenceStore());
        this.fPageSize.load();
        this.fPreBufferSize.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPostBufferSize.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPageSize.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fAuto.addSelectionListener((SelectionListener)this);
        this.fManual.addSelectionListener((SelectionListener)this);
        this.loadLoadingModeFromPreference();
        this.updateTextEditorsEnablement();
        return this.fComposite;
    }

    private void loadLoadingModeFromPreference() {
        boolean isAuto = this.getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        this.fAuto.setSelection(isAuto);
        this.fManual.setSelection(!isAuto);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value") && (event.getSource().equals(this.fPageSize) || event.getSource().equals(this.fPostBufferSize) || event.getSource().equals(this.fPreBufferSize))) {
            this.validatePageSize();
        }
    }

    private void validatePageSize() {
        boolean autoLoad = this.fAuto.getSelection();
        try {
            int bufferSize = this.fPageSize.getIntValue();
            int preBuffer = this.fPreBufferSize.getIntValue();
            int postBuffer = this.fPostBufferSize.getIntValue();
            if (!autoLoad && bufferSize < 1) {
                this.setValid(false);
                this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_3);
            } else if (autoLoad) {
                if (preBuffer < 1 || postBuffer < 1) {
                    this.setValid(false);
                    this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_9);
                } else {
                    this.setValid(true);
                    this.setErrorMessage(null);
                }
            } else {
                this.setValid(true);
                this.setErrorMessage(null);
            }
        }
        catch (NumberFormatException e) {
            this.setValid(false);
            this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_4);
        }
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    public void dispose() {
        this.fAuto.removeSelectionListener((SelectionListener)this);
        this.fManual.removeSelectionListener((SelectionListener)this);
        this.fPageSize.setPropertyChangeListener(null);
        this.fPreBufferSize.setPropertyChangeListener(null);
        this.fPostBufferSize.setPropertyChangeListener(null);
        super.dispose();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateTextEditorsEnablement();
    }

    public boolean performOk() {
        boolean currentValue;
        boolean auto = this.fAuto.getSelection();
        if (auto != (currentValue = this.getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad"))) {
            this.getPreferenceStore().setValue("org.eclpise.debug.ui.memory.dynamicLoad", auto);
        }
        this.fPageSize.store();
        this.fPreBufferSize.store();
        this.fPostBufferSize.store();
        return super.performOk();
    }

    protected void performDefaults() {
        boolean auto = this.getPreferenceStore().getDefaultBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        this.fAuto.setSelection(auto);
        this.fManual.setSelection(!auto);
        this.updateTextEditorsEnablement();
        this.fPageSize.loadDefault();
        this.fPreBufferSize.loadDefault();
        this.fPostBufferSize.loadDefault();
        super.performDefaults();
    }

    private void updateTextEditorsEnablement() {
        boolean auto = this.fAuto.getSelection();
        this.fPreBufferSize.setEnabled(auto, (Composite)this.fGroup);
        this.fPostBufferSize.setEnabled(auto, (Composite)this.fGroup);
        this.fPageSize.setEnabled(!auto, this.fComposite);
    }
}

