/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.ImpactsEnum;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterDocIdSetIterator;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

class ScorerUtil {
    private static final Class<?> DEFAULT_IMPACTS_ENUM_CLASS;

    ScorerUtil() {
    }

    static long costWithMinShouldMatch(LongStream costs, int numScorers, int minShouldMatch) {
        PriorityQueue<Long> pq = new PriorityQueue<Long>(numScorers - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Long a, Long b) {
                return a > b;
            }
        };
        costs.forEach(pq::insertWithOverflow);
        return StreamSupport.stream(pq.spliterator(), false).mapToLong(Number::longValue).sum();
    }

    static DocIdSetIterator likelyImpactsEnum(DocIdSetIterator it) {
        if (it.getClass() != DEFAULT_IMPACTS_ENUM_CLASS && it.getClass() != FilterDocIdSetIterator.class) {
            it = new FilterDocIdSetIterator(it);
        }
        return it;
    }

    static Scorable likelyTermScorer(Scorable scorable) {
        if (scorable.getClass() != TermScorer.class && scorable.getClass() != FilterScorable.class) {
            scorable = new FilterScorable(scorable);
        }
        return scorable;
    }

    static {
        try (ByteBuffersDirectory dir = new ByteBuffersDirectory();
             IndexWriter w = new IndexWriter(dir, new IndexWriterConfig());){
            Document doc = new Document();
            doc.add(new FeatureField("field", "value", 1.0f));
            w.addDocument(doc);
            try (DirectoryReader reader = DirectoryReader.open(w);){
                LeafReader leafReader = reader.leaves().get(0).reader();
                TermsEnum te = leafReader.terms("field").iterator();
                if (!te.seekExact(new BytesRef("value"))) {
                    throw new Error();
                }
                ImpactsEnum ie = te.impacts(8);
                DEFAULT_IMPACTS_ENUM_CLASS = ie.getClass();
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }
}

