/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ArchiveFileFilter
extends ViewerFilter {
    private static final String[] fgArchiveExtensions = new String[]{"jar", "zip"};
    private List<IFile> fExcludes;

    public ArchiveFileFilter(IFile[] excludedFiles) {
        this.fExcludes = excludedFiles != null ? Arrays.asList(excludedFiles) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (this.fExcludes == null) return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath());
            if (!this.fExcludes.contains(element)) return ArchiveFileFilter.isArchivePath(((IFile)element).getFullPath());
            return false;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            IResource[] iResourceArray = ((IContainer)element).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, parent, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e.getStatus());
        }
        return false;
    }

    public static boolean isArchivePath(IPath path) {
        String ext = path.getFileExtension();
        if (ext != null && ext.length() != 0) {
            String[] stringArray = fgArchiveExtensions;
            int n = fgArchiveExtensions.length;
            int n2 = 0;
            while (n2 < n) {
                String archiveExtension = stringArray[n2];
                if (ext.equalsIgnoreCase(archiveExtension)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

