/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.core.model.ModelManager;
import org.eclipse.rcptt.internal.core.model.Q7NamedElement;
import org.eclipse.rcptt.internal.core.model.Q7Operation;
import org.eclipse.rcptt.internal.core.model.deltas.Q7ElementDelta;

public class BecomeWorkingCopyOperation
extends Q7Operation {
    private boolean indexing = false;

    public BecomeWorkingCopyOperation(Q7NamedElement workingCopy, boolean indexing) {
        super(new IQ7Element[]{workingCopy});
        this.indexing = indexing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeOperation() throws ModelException {
        Q7NamedElement workingCopy = this.getWorkingCopy();
        workingCopy.workingCopyMode = true;
        ModelManager.PerWorkingCopyInfo copyInfo = ModelManager.getModelManager().getPerWorkingCopyInfo(workingCopy, true, true);
        try {
            try {
                copyInfo.resourceInfo = workingCopy.createElementInfo();
                workingCopy.setIndexing(this.indexing);
                workingCopy.generateInfos(copyInfo.resourceInfo, this.progressMonitor);
                if (workingCopy.getResource().isAccessible()) {
                    if (!this.indexing) {
                        Q7ElementDelta delta = new Q7ElementDelta(this.getModel());
                        delta.changed(workingCopy, 65536);
                        this.addDelta(delta);
                    }
                } else if (!this.indexing) {
                    Q7ElementDelta delta = new Q7ElementDelta(this.getModel());
                    delta.added(workingCopy, 65536);
                    this.addDelta(delta);
                }
                this.resultElements = new IQ7Element[]{workingCopy};
            }
            catch (ModelException e) {
                workingCopy.discardWorkingCopy();
                throw e;
            }
            catch (Throwable e) {
                workingCopy.discardWorkingCopy();
                throw e;
            }
        }
        catch (Throwable throwable) {
            ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = copyInfo;
            synchronized (perWorkingCopyInfo) {
                copyInfo.complete = true;
                copyInfo.notifyAll();
            }
            throw throwable;
        }
        ModelManager.PerWorkingCopyInfo perWorkingCopyInfo = copyInfo;
        synchronized (perWorkingCopyInfo) {
            copyInfo.complete = true;
            copyInfo.notifyAll();
        }
    }

    protected Q7NamedElement getWorkingCopy() {
        return (Q7NamedElement)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

