/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.internal.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rcptt.core.IQ7Extension;
import org.eclipse.rcptt.core.internal.builder.MigrateProjectsJob;
import org.eclipse.rcptt.internal.core.RcpttPlugin;

public class Q7BuilderExtension
implements IQ7Extension {
    public void initialize() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent e) {
                IResourceDelta delta = e.getDelta();
                if (delta != null) {
                    try {
                        delta.accept((IResourceDeltaVisitor)new Q7DeltaVisitor());
                    }
                    catch (CoreException e1) {
                        RcpttPlugin.log((Throwable)e1);
                    }
                }
            }
        });
        new MigrateProjectsJob((IContainer)ResourcesPlugin.getWorkspace().getRoot()).schedule();
    }

    public boolean isBuilder() {
        return true;
    }

    class Q7DeltaVisitor
    implements IResourceDeltaVisitor {
        Q7DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 8) {
                return true;
            }
            if (resource.getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x80000) != 0)) {
                new MigrateProjectsJob((IContainer)((IProject)resource)).schedule();
            }
            return false;
        }
    }
}

