/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.e4x;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.AreaImpl;
import org.eclipse.e4.ui.model.application.ui.advanced.impl.PlaceholderImpl;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartImpl;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.swt.workbench.IEclipseWorkbenchProvider;
import org.eclipse.rcptt.util.ReflectionUtil;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.ViewSite;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.e4.compatibility.ActionBars;
import org.eclipse.ui.internal.e4.compatibility.SelectionService;
import org.eclipse.ui.internal.quickaccess.SearchField;
import org.osgi.framework.Version;

public class E4WorkbenchProvider
implements IEclipseWorkbenchProvider {
    private static final String JUNO_TEXT_FIELD = "getFilterText";
    private static final String KEPLER_TEXT_FIELD = "getQuickAccessSearchText";

    private static <T> T as(Class<T> class_, Object object) {
        if (class_.isInstance(object)) {
            return class_.cast(object);
        }
        return null;
    }

    public Menu getViewMenu(IWorkbenchPart workbenchPart, IWorkbenchPartReference reference, boolean create) {
        ViewSite site = E4WorkbenchProvider.as(ViewSite.class, workbenchPart.getSite());
        if (site == null) {
            return null;
        }
        ActionBars bars = E4WorkbenchProvider.as(ActionBars.class, site.getActionBars());
        if (bars == null) {
            return null;
        }
        MenuManager man = E4WorkbenchProvider.as(MenuManager.class, bars.getMenuManager());
        if (man == null) {
            return null;
        }
        Menu menu = man.getMenu();
        if ((menu == null || menu.isDisposed()) && create) {
            man.createContextMenu((Control)site.getShell());
        }
        return man.getMenu();
    }

    public List<?> getPaneFolderButtonListeners(Object paneFolder) {
        return new ArrayList();
    }

    public Control getToolbar(IWorkbenchPartReference reference) {
        try {
            return ((ToolBarManager)((PartSite)((WorkbenchPartReference)reference).getPart(false).getSite()).getActionBars().getToolBarManager()).getControl();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean canClickView(IWorkbenchPartReference reference) {
        return true;
    }

    public Map<Control, SWTUIElement> getWorkbenchReference(SWTUIPlayer player) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (!Display.getCurrent().equals(PlatformUI.getWorkbench().getDisplay())) {
            return new HashMap<Control, SWTUIElement>();
        }
        HashMap<Control, SWTUIElement> references = new HashMap<Control, SWTUIElement>();
        IWorkbenchWindow[] iWorkbenchWindowArray = windows;
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            Control control;
            IWorkbenchPart refPart;
            WorkbenchPartReference ref;
            IViewReference[] views;
            IWorkbenchWindow iWorkbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = iWorkbenchWindow.getActivePage();
            IEditorReference[] editors = page.getEditorReferences();
            IViewReference[] iViewReferenceArray = views = page.getViewReferences();
            int n3 = views.length;
            int n4 = 0;
            while (n4 < n3) {
                IViewReference iViewReference = iViewReferenceArray[n4];
                ref = (WorkbenchPartReference)iViewReference;
                refPart = ref.getPart(false);
                if (refPart != null && ref.getPane().getControl() != null) {
                    control = ref.getPane().getControl();
                    references.put(control, player.wrap((Object)ref));
                    Control toolbar = this.getToolbar((IWorkbenchPartReference)ref);
                    if (toolbar != null) {
                        references.put(toolbar, player.wrap((Object)ref));
                    }
                }
                ++n4;
            }
            iViewReferenceArray = editors;
            n3 = editors.length;
            n4 = 0;
            while (n4 < n3) {
                IViewReference iEditorReference = iViewReferenceArray[n4];
                ref = (WorkbenchPartReference)iEditorReference;
                refPart = ref.getPart(false);
                if (refPart != null && ref.getPane().getControl() != null) {
                    control = ref.getPane().getControl();
                    references.put(control, player.wrap((Object)ref));
                }
                ++n4;
            }
            ++n2;
        }
        return references;
    }

    public void processTabFolderButton(Widget widget, int buttonId) {
        if (!(widget instanceof CTabFolder) && widget.getData("modelElement") != null && widget instanceof Control) {
            Composite parent = ((Control)widget).getParent();
            if (!(parent instanceof CTabFolder) && !((parent = parent.getParent()) instanceof CTabFolder)) {
                return;
            }
            widget = parent;
        }
        if (!(widget instanceof CTabFolder)) {
            return;
        }
        CTabFolder tabFolder = (CTabFolder)widget;
        ToolItem maxItem = null;
        ToolItem minItem = null;
        try {
            Field field = CTabFolder.class.getDeclaredField("maxItem");
            field.setAccessible(true);
            maxItem = (ToolItem)field.get(tabFolder);
            field = CTabFolder.class.getDeclaredField("minItem");
            field.setAccessible(true);
            minItem = (ToolItem)field.get(tabFolder);
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
        if (maxItem == null || minItem == null && buttonId == 0) {
            return;
        }
        Event e = new Event();
        switch (buttonId) {
            case 1: {
                if (tabFolder.getMaximized()) {
                    return;
                }
                e.widget = maxItem;
                e.type = 13;
                maxItem.notifyListeners(13, e);
                break;
            }
            case 0: {
                if (tabFolder.getMinimized()) {
                    return;
                }
                e.widget = minItem;
                e.type = 13;
                minItem.notifyListeners(13, e);
                break;
            }
            case 2: {
                if (!tabFolder.getMinimized() && !tabFolder.getMaximized()) {
                    return;
                }
                e.widget = maxItem;
                e.type = 13;
                maxItem.notifyListeners(13, e);
            }
        }
    }

    public void processTabShowList(Widget widget) {
        if (!(widget instanceof CTabFolder) && widget.getData("modelElement") != null && widget instanceof Control) {
            Composite parent = ((Control)widget).getParent();
            if (!(parent instanceof CTabFolder) && !((parent = parent.getParent()) instanceof CTabFolder)) {
                return;
            }
            widget = parent;
        }
        if (!(widget instanceof CTabFolder)) {
            return;
        }
        CTabFolder tabFolder = (CTabFolder)widget;
        ToolItem chevronItem = null;
        try {
            Field field = CTabFolder.class.getDeclaredField("chevronItem");
            field.setAccessible(true);
            chevronItem = (ToolItem)field.get(tabFolder);
        }
        catch (Exception e) {
            TeslaCore.log((Throwable)e);
        }
        if (chevronItem == null) {
            return;
        }
        if (!chevronItem.getParent().isVisible()) {
            return;
        }
        Event e = new Event();
        e.widget = chevronItem;
        e.type = 13;
        chevronItem.notifyListeners(13, e);
    }

    public boolean isVisible(IWorkbenchPartReference reference) {
        IWorkbenchPart part = reference.getPart(false);
        if (part != null) {
            return ((WorkbenchPartReference)reference).getPane().getControl().isVisible();
        }
        return false;
    }

    public boolean isActiveContainsView(IWorkbenchPage page, IWorkbenchPartReference reference) {
        return true;
    }

    public boolean isViewOrEditorButton(Widget widget) {
        if (!(widget instanceof ToolItem)) {
            return false;
        }
        ToolItem item = (ToolItem)widget;
        String tooltip = item.getToolTipText();
        if (!(tooltip == null || tooltip.equals("View Menu") || tooltip.equals("Maximize") || tooltip.equals("Minimize") || tooltip.equals("Restore") || tooltip.equals("Show List"))) {
            return false;
        }
        if (item.getData("theMenu") != null) {
            return true;
        }
        if (item.getParent() instanceof ToolBar && TeslaSWTAccess.getThis(TrimStack.class, (Widget)item, (int)13) != null) {
            return true;
        }
        Composite parent = item.getParent().getParent();
        if (!(parent instanceof CTabFolder)) {
            return false;
        }
        Widget control = this.extractViewOrEditorControl((CTabFolder)parent);
        return control != null;
    }

    public boolean isSupported() {
        Version version = TeslaCore.getPlatformVersion();
        return version.getMajor() == 3 && version.getMinor() >= 103;
    }

    public Widget extractViewOrEditorControl(CTabFolder tabFolder) {
        if (tabFolder.getSelection() == null) {
            return null;
        }
        Control selection = tabFolder.getSelection().getControl();
        if (selection instanceof Composite) {
            Control[] children;
            Object data = selection.getData("modelElement");
            if (data instanceof PartImpl) {
                return selection;
            }
            Control[] controlArray = children = ((Composite)selection).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c instanceof Composite && (data = c.getData("modelElement")) instanceof PartImpl) {
                    return c;
                }
                ++n2;
            }
            return null;
        }
        return null;
    }

    public CTabFolder getTabFolderFromButton(ToolItem button) {
        Composite parent = button.getParent().getParent();
        if (parent instanceof CTabFolder) {
            return (CTabFolder)parent;
        }
        if (parent != null && button.getData("theMenu") != null && (parent = parent.getParent()) instanceof CTabFolder) {
            return (CTabFolder)parent;
        }
        TrimStack trimStack = (TrimStack)TeslaSWTAccess.getThis(TrimStack.class, (Widget)button, (int)13);
        if (trimStack != null) {
            try {
                Object widget;
                MUIElement selected;
                MUIElement ref;
                Field field = TrimStack.class.getDeclaredField("minimizedElement");
                field.setAccessible(true);
                Object minimizedElement = field.get(trimStack);
                if (minimizedElement instanceof PartStackImpl) {
                    Object widget2 = ((PartStackImpl)minimizedElement).getWidget();
                    if (widget2 instanceof CTabFolder) {
                        return (CTabFolder)widget2;
                    }
                } else if (minimizedElement instanceof PlaceholderImpl && (ref = ((PlaceholderImpl)minimizedElement).getRef()) instanceof AreaImpl && (selected = ((AreaImpl)ref).getSelectedElement()) instanceof PartStackImpl && (widget = ((PartStackImpl)selected).getWidget()) instanceof CTabFolder) {
                    return (CTabFolder)widget;
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public Text getQuickAccess() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        MWindow mWindow = ((WorkbenchWindow)window).getModel();
        if (mWindow == null) {
            return null;
        }
        EModelService modelService = (EModelService)mWindow.getContext().get(EModelService.class);
        if (modelService == null) {
            return null;
        }
        MToolControl searchField = (MToolControl)modelService.find("SearchField", (MUIElement)mWindow);
        if (searchField == null) {
            return null;
        }
        if (!(searchField.getObject() instanceof SearchField)) {
            return null;
        }
        SearchField field = (SearchField)searchField.getObject();
        if (field == null) {
            return null;
        }
        Object result = ReflectionUtil.callMethod((Object)field, (String)JUNO_TEXT_FIELD);
        if (result == null) {
            result = ReflectionUtil.callMethod((Object)field, (String)KEPLER_TEXT_FIELD);
        }
        return result == null ? null : (Text)result;
    }

    public void updateActiveSelection(List<Object> selectionData, SWTUIElement parent) {
        List parentsList = parent.getPlayer().getParentsList(parent);
        parentsList.add(parent);
        for (SWTUIElement e : parentsList) {
            GenericElementKind kind = e.getKind();
            if (!kind.is(ElementKind.View) && !kind.is(ElementKind.Editor) || !(e instanceof WorkbenchUIElement)) continue;
            IWorkbenchPartReference reference = ((WorkbenchUIElement)e).getReference();
            IWorkbenchWindow window = reference.getPage().getWorkbenchWindow();
            IWorkbenchPart part = reference.getPart(true);
            ISelectionService selectionService = window.getSelectionService();
            ((SelectionService)selectionService).updateSelection(part);
        }
    }

    public String getViewId(Widget widget) {
        return null;
    }
}

