/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.dnd;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rcptt.util.ListUtil;
import org.eclipse.rcptt.util.Predicate;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNDManager {
    private static DNDManager manager;
    private List<WeakReference<DropTarget>> targets = new ArrayList<WeakReference<DropTarget>>();
    private List<WeakReference<DragSource>> sources = new ArrayList<WeakReference<DragSource>>();

    public static synchronized DNDManager getInstance() {
        if (manager == null) {
            manager = new DNDManager();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTarget(DropTarget target) {
        List<WeakReference<DropTarget>> list = this.targets;
        synchronized (list) {
            this.targets.add(new WeakReference<DropTarget>(target));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DropTarget> getTargets() {
        List<WeakReference<DropTarget>> list = this.targets;
        synchronized (list) {
            final ArrayList<DropTarget> result = new ArrayList<DropTarget>();
            ListUtil.excludeInPlace(this.targets, (Predicate)new Predicate<WeakReference<DropTarget>>(){

                public boolean apply(WeakReference<DropTarget> input) {
                    DropTarget dropTarget = (DropTarget)input.get();
                    if (dropTarget != null && dropTarget.getControl() != null) {
                        result.add(dropTarget);
                        return false;
                    }
                    return true;
                }
            });
            return result;
        }
    }

    public List<DragSource> getSources() {
        final ArrayList<DragSource> result = new ArrayList<DragSource>();
        ListUtil.excludeInPlace(this.sources, (Predicate)new Predicate<WeakReference<DragSource>>(){

            public boolean apply(WeakReference<DragSource> input) {
                DragSource dragSource = (DragSource)input.get();
                if (dragSource != null && dragSource.getControl() != null) {
                    result.add(dragSource);
                    return false;
                }
                return true;
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSource(DragSource source) {
        List<WeakReference<DragSource>> list = this.sources;
        synchronized (list) {
            this.sources.add(new WeakReference<DragSource>(source));
        }
    }
}

