/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.utils.ResourceUtils;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IReviewInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReview;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewExtended;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRootElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIRuleSet;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.general.ReviewGroupProperties;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.reviews.r4e.upgrade.ui.R4EUpgradeController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class R4EUIReviewGroup
extends R4EUIModelElement {
    public static final String REVIEW_GROUP_ICON_FILE = "icons/obj16/revgrp_obj.gif";
    public static final String REVIEW_GROUP_CLOSED_ICON_FILE = "icons/obj16/revgrpclsd_obj.gif";
    private static final String NEW_CHILD_ELEMENT_COMMAND_NAME = "New Review...";
    private static final String NEW_CHILD_ELEMENT_COMMAND_TOOLTIP = "Add a New Review to the Current Review Group";
    private static final String OPEN_ELEMENT_COMMAND_NAME = "Open Review Group";
    private static final String OPEN_ELEMENT_COMMAND_TOOLTIP = "Open and Load Data for this Review Group";
    private static final String CLOSE_ELEMENT_COMMAND_NAME = "Close Review Group";
    private static final String CLOSE_ELEMENT_COMMAND_TOOLTIP = "Close and Unload Data for this Review Group";
    private static final String REMOVE_ELEMENT_COMMAND_NAME = "Disable Review Group";
    private static final String REMOVE_ELEMENT_COMMAND_TOOLTIP = "Disable this Review Group";
    private static final String RESTORE_ELEMENT_COMMAND_NAME = "Restore Review Group";
    private static final String RESTORE_ELEMENT_COMMAND_TOOLTIP = "Restore this disabled Review Group";
    private static final String UNKNOWN_REVIEW_GROUP_TYPE_TOOLTIP = "Review Group Version Data is not Compatible with the current R4E Version." + R4EUIConstants.LINE_FEED + "Open Group to Upgrade.";
    protected R4EReviewGroup fGroup;
    private URI fGroupFileURI = null;
    private final List<R4EUIReview> fReviews;
    private final List<R4EUIRuleSet> fRuleSets;

    public R4EUIReviewGroup(IR4EUIModelElement aParent, String aGroupPath, R4EReviewGroup aGroup, boolean aOpen) {
        super(aParent, R4EUIReviewGroup.extractGroupName(aGroupPath));
        this.fReadOnly = false;
        this.fGroup = aGroup;
        this.fGroupFileURI = URI.createFileURI((String)aGroupPath);
        if (this.fGroup == null) {
            this.fResolved = false;
        }
        this.fReviews = new ArrayList<R4EUIReview>();
        this.fRuleSets = new ArrayList<R4EUIRuleSet>();
        this.fOpen = aOpen;
    }

    @Override
    public String getImageLocation() {
        if (this.isOpen()) {
            return REVIEW_GROUP_ICON_FILE;
        }
        return REVIEW_GROUP_CLOSED_ICON_FILE;
    }

    @Override
    public String getToolTip() {
        if (this.fResolved) {
            return "File Location: " + URI.decode((String)this.fGroupFileURI.devicePath());
        }
        return UNKNOWN_REVIEW_GROUP_TYPE_TOOLTIP;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IR4EUIModelElement.class.equals((Object)adapter)) {
            return this;
        }
        if (IPropertySource.class.equals((Object)adapter) && this.fResolved) {
            return new ReviewGroupProperties(this);
        }
        return null;
    }

    private static String extractGroupName(String aGroupPath) {
        String separator = System.getProperty("file.separator");
        String[] tokens = aGroupPath.split(separator.equals("\\") ? "\\" + separator : separator);
        return tokens[tokens.length - 1].replaceFirst("_group_root.xrer", "");
    }

    public R4EReviewGroup getReviewGroup() {
        return this.fGroup;
    }

    public String getGroupFile() {
        return this.fGroupFileURI.toFileString();
    }

    public List<R4EUIRuleSet> getRuleSets() {
        return this.fRuleSets;
    }

    @Override
    public void setModelData(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fGroup, R4EUIModelController.getReviewer());
        this.fGroup.setDescription(((R4EReviewGroup)aModelComponent).getDescription());
        this.fGroup.getAvailableProjects().addAll((Collection)((R4EReviewGroup)aModelComponent).getAvailableProjects());
        this.fGroup.getAvailableComponents().addAll((Collection)((R4EReviewGroup)aModelComponent).getAvailableComponents());
        this.fGroup.setDefaultEntryCriteria(((R4EReviewGroup)aModelComponent).getDefaultEntryCriteria());
        this.fGroup.getDesignRuleLocations().addAll((Collection)((R4EReviewGroup)aModelComponent).getDesignRuleLocations());
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
    }

    @Override
    public List<ReviewComponent> createChildModelDataElement() {
        ArrayList<ReviewComponent> tempReviews = new ArrayList<ReviewComponent>();
        IReviewInputDialog dialog = R4EUIDialogFactory.getInstance().getReviewInputDialog(this);
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            R4EReviewType type = dialog.getReviewTypeValue();
            Object tempReview = type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL) ? RModelFactory.eINSTANCE.createR4EFormalReview() : RModelFactory.eINSTANCE.createR4EReview();
            tempReview.setType(type);
            tempReview.setName(dialog.getReviewNameValue());
            tempReview.setExtraNotes(dialog.getReviewDescriptionValue());
            tempReview.setDueDate(dialog.getDueDate());
            tempReview.setProject(dialog.getProjectValue());
            String[] stringArray = dialog.getComponentsValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String component = stringArray[n2];
                tempReview.getComponents().add((Object)component);
                ++n2;
            }
            tempReview.setEntryCriteria(dialog.getEntryCriteriaValue());
            tempReview.setObjectives(dialog.getObjectivesValue());
            tempReview.setReferenceMaterial(dialog.getReferenceMaterialValue());
            R4EReviewDecision reviewDecision = Persistence.RModelFactoryExt.eINSTANCE.createR4EReviewDecision();
            if (type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_INFORMAL)) {
                reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_ACCEPTED);
            } else {
                reviewDecision.setValue(R4EDecision.R4E_REVIEW_DECISION_NONE);
            }
            tempReview.setDecision(reviewDecision);
            tempReviews.add((ReviewComponent)tempReview);
        }
        return tempReviews;
    }

    @Override
    public void close() {
        R4EUIReview review = null;
        int reviewsSize = this.fReviews.size();
        int i = 0;
        while (i < reviewsSize) {
            review = this.fReviews.get(i);
            if (review.isOpen()) {
                review.close();
            }
            ++i;
        }
        this.fReviews.clear();
        this.fRuleSets.clear();
        this.fOpen = false;
        this.fReadOnly = false;
        if (this.fGroup != null) {
            R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
        }
        this.fImage = UIUtils.loadIcon(REVIEW_GROUP_CLOSED_ICON_FILE);
    }

    @Override
    public void open() throws ResourceHandlingException, CompatibilityException {
        String oldVersion;
        String newVersion = Persistence.Roots.GROUP.getVersion();
        try {
            oldVersion = R4EUpgradeController.getVersionFromResourceFile((URI)this.fGroupFileURI);
        }
        catch (IOException e1) {
            throw new ResourceHandlingException("Cannot find Review Group resource file " + this.fGroupFileURI, (Throwable)e1);
        }
        if (this.checkCompatibility(this.fGroupFileURI, "Review Group " + R4EUIReviewGroup.extractGroupName(this.getGroupFile()), oldVersion, newVersion, false)) {
            EList reviews;
            this.fGroup = R4EUIModelController.FModelExt.openR4EReviewGroup(this.fGroupFileURI);
            this.fResolved = true;
            if (!this.fReadOnly) {
                try {
                    R4EUIModelController.stampVersion((ReviewComponent)this.fGroup, R4EUIModelController.getReviewer(), newVersion);
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
                    return;
                }
            }
            if ((reviews = this.fGroup.getReviews()) != null) {
                int reviewsSize = reviews.size();
                R4EReview review = null;
                R4EUIReview uiReview = null;
                int i = 0;
                while (i < reviewsSize) {
                    review = (R4EReview)reviews.get(i);
                    if (review.isEnabled() || R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
                        uiReview = null;
                        if (this.checkChildReviewCompatibility(review)) {
                            if (review.getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                                uiReview = new R4EUIReviewExtended(this, review, review.getType(), false);
                                ((R4EUIReviewExtended)uiReview).setName(String.valueOf(((R4EUIReviewExtended)uiReview).getPhaseString(((R4EReviewState)review.getState()).getState())) + ": " + uiReview.getName());
                            } else {
                                uiReview = new R4EUIReviewBasic(this, review, review.getType(), false);
                            }
                        } else {
                            uiReview = new R4EUIReview(this, review, false);
                        }
                        this.addChildren(uiReview);
                    }
                    ++i;
                }
            }
            EList ruleSetlocations = this.fGroup.getDesignRuleLocations();
            block5: for (String ruleSetlocation : ruleSetlocations) {
                for (R4EUIRuleSet ruleSet : ((R4EUIRootElement)this.getParent()).getRuleSets()) {
                    String path = R4EUIRuleSet.extractRuleSetName(ruleSet.getRuleSetFile());
                    if (!path.equals(ruleSetlocation)) continue;
                    this.fRuleSets.add(ruleSet);
                    continue block5;
                }
            }
            this.fOpen = true;
            this.fImage = UIUtils.loadIcon(REVIEW_GROUP_ICON_FILE);
        } else {
            this.close();
        }
    }

    public boolean checkChildReviewCompatibility(R4EReview aReview) throws ResourceHandlingException {
        String oldVersion;
        String newVersion = Persistence.Roots.REVIEW.getVersion();
        String validReviewName = ResourceUtils.toValidFileName((String)aReview.getName());
        URI upgradeRootUri = URI.createFileURI((String)(String.valueOf(this.getReviewGroup().getFolder()) + "/" + validReviewName));
        URI reviewResourceUri = upgradeRootUri.appendSegment(String.valueOf(validReviewName) + "_review.xrer");
        try {
            oldVersion = R4EUpgradeController.getVersionFromResourceFile((URI)reviewResourceUri);
        }
        catch (IOException e1) {
            throw new ResourceHandlingException("Cannot find Review Group resource file " + reviewResourceUri, (Throwable)e1);
        }
        try {
            return R4EUpgradeController.upgradeCompatibilityCheck((URI)reviewResourceUri, (String)oldVersion, (String)newVersion);
        }
        catch (IOException e) {
            R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
            return false;
        }
    }

    @Override
    public void setEnabled(boolean aEnabled) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        this.fGroup = R4EUIModelController.FModelExt.openR4EReviewGroup(this.fGroupFileURI);
        Long bookNum = R4EUIModelController.FResourceUpdater.checkOut((EObject)this.fGroup, R4EUIModelController.getReviewer());
        this.fGroup.setEnabled(aEnabled);
        R4EUIModelController.FResourceUpdater.checkIn(bookNum);
        R4EUIModelController.FModelExt.closeR4EReviewGroup(this.fGroup);
    }

    @Override
    public boolean isEnabled() {
        if (this.fResolved) {
            return this.fGroup.isEnabled();
        }
        return true;
    }

    @Override
    public IR4EUIModelElement[] getChildren() {
        return this.fReviews.toArray(new R4EUIReview[this.fReviews.size()]);
    }

    public void replaceReview(R4EUIReview aOldReview, R4EUIReview aNewReview) {
        this.fReviews.set(this.fReviews.indexOf(aOldReview), aNewReview);
    }

    public R4EUIReview getReview(String aReviewName) {
        for (R4EUIReview review : this.fReviews) {
            if (review.getReview() == null || !aReviewName.equals(review.getReview().getName())) continue;
            return review;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.isOpen() && this.fReviews.size() > 0;
    }

    @Override
    public IR4EUIModelElement createChildren(ReviewComponent aModelComponent) throws ResourceHandlingException, OutOfSyncException {
        R4EUIReviewBasic addedChild;
        String reviewName = ((R4EReview)aModelComponent).getName();
        R4EReviewType type = ((R4EReview)aModelComponent).getType();
        for (R4EUIReview review : this.fReviews) {
            if (!review.getReview().getName().equals(reviewName)) continue;
            final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Error while creating new review ", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Review " + reviewName + " already exists", null), 4);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    dialog.open();
                }
            });
            return null;
        }
        if (type.equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
            addedChild = new R4EUIReviewExtended(this, (R4EReview)R4EUIModelController.FModelExt.createR4EFormalReview(this.getReviewGroup(), reviewName, R4EUIModelController.getReviewer()), type, true);
            ((R4EUIReviewExtended)addedChild).updatePhase(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
        } else {
            addedChild = new R4EUIReviewBasic(this, R4EUIModelController.FModelExt.createR4EReview(this.getReviewGroup(), reviewName, R4EUIModelController.getReviewer()), type, true);
            addedChild.updatePhase(R4EReviewPhase.R4E_REVIEW_PHASE_STARTED);
        }
        addedChild.setModelData(aModelComponent);
        this.addChildren(addedChild);
        return addedChild;
    }

    @Override
    public void addChildren(IR4EUIModelElement aChildToAdd) {
        this.fReviews.add((R4EUIReview)aChildToAdd);
    }

    @Override
    public void removeChildren(IR4EUIModelElement aChildToRemove, boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        if (((R4EUIReviewBasic)aChildToRemove).isOpen()) {
            R4EUIModelController.setActiveReview(null);
        }
        R4EUIReview removedElement = this.fReviews.get(this.fReviews.indexOf(aChildToRemove));
        removedElement.removeAllChildren(aFileRemove);
        removedElement.setEnabled(false);
        if (!R4EUIPlugin.getDefault().getPreferenceStore().getBoolean("showDisabled")) {
            this.fReviews.remove(removedElement);
        }
    }

    @Override
    public void removeAllChildren(boolean aFileRemove) throws ResourceHandlingException, OutOfSyncException, CompatibilityException {
        for (R4EUIReview review : this.fReviews) {
            this.removeChildren(review, aFileRemove);
        }
    }

    @Override
    public boolean isOpenElementCmd() {
        return !this.fResolved || this.isEnabled() && !this.isOpen();
    }

    @Override
    public String getOpenElementCmdName() {
        return OPEN_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getOpenElementCmdTooltip() {
        return OPEN_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isCloseElementCmd() {
        return this.fResolved && this.isEnabled() && this.isOpen();
    }

    @Override
    public String getCloseElementCmdName() {
        return CLOSE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getCloseElementCmdTooltip() {
        return CLOSE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isNewChildElementCmd() {
        return this.fResolved && this.isEnabled() && this.isOpen() && !this.isReadOnly();
    }

    @Override
    public String getNewChildElementCmdName() {
        return NEW_CHILD_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getNewChildElementCmdTooltip() {
        return NEW_CHILD_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRemoveElementCmd() {
        return this.fResolved && !this.isOpen() && this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRemoveElementCmdName() {
        return REMOVE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRemoveElementCmdTooltip() {
        return REMOVE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isRestoreElementCmd() {
        return (!this.fResolved || !this.isOpen()) && !this.isEnabled() && !this.isReadOnly();
    }

    @Override
    public String getRestoreElementCmdName() {
        return RESTORE_ELEMENT_COMMAND_NAME;
    }

    @Override
    public String getRestoreElementCmdTooltip() {
        return RESTORE_ELEMENT_COMMAND_TOOLTIP;
    }

    @Override
    public boolean isShowPropertiesCmd() {
        return this.fResolved;
    }
}

